/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.dtos.split;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.split.api.dtos.split.Bucket;
import io.split.api.dtos.split.Condition;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Rule {
    private List<Bucket> buckets;
    private Condition condition;

    public Rule() {
    }

    private Rule(Builder builder) {
        this.buckets = builder.buckets;
        this.condition = builder.condition;
    }

    @JsonProperty
    public Condition condition() {
        return this.condition;
    }

    @JsonProperty
    public List<Bucket> buckets() {
        return this.buckets;
    }

    public void setBuckets(List<Bucket> buckets) {
        this.buckets = buckets;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Rule other) {
        return new Builder(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this.buckets != null ? !this.buckets.equals(rule.buckets) : rule.buckets != null) {
            return false;
        }
        return this.condition != null ? this.condition.equals(rule.condition) : rule.condition == null;
    }

    public int hashCode() {
        int result = this.buckets != null ? this.buckets.hashCode() : 0;
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Rule{buckets=" + this.buckets + ", condition=" + this.condition + '}';
    }

    public static class Builder {
        private List<Bucket> buckets;
        private Condition condition;

        public Builder buckets(List<Bucket> buckets) {
            this.buckets = buckets;
            return this;
        }

        public Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        Builder() {
        }

        Builder(Rule prototype) {
            this.buckets = prototype.buckets;
            this.condition = prototype.condition;
        }

        public Rule build() {
            return new Rule(this);
        }
    }
}

