/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.resources;

import io.split.api.client.HttpClient;
import io.split.api.client.utils.EncodingUtil;
import io.split.api.dtos.result.ListResultDTO;
import io.split.api.dtos.split.Split;

public class SplitClient {
    private HttpClient _client;

    public SplitClient(HttpClient client) {
        this._client = client;
    }

    public Split get(String name) {
        String result = this._client.get("/v1/splits/%s", name);
        return EncodingUtil.parse(result, Split.class);
    }

    public Boolean delete(String name) {
        String result = this._client.delete("/v1/splits/%s", name);
        return EncodingUtil.parse(result, Boolean.class);
    }

    public Split create(Split split, String trafficTypeNameOrIds) {
        String result = this._client.post(split, "/v1/splits/trafficTypes/%s", trafficTypeNameOrIds);
        return EncodingUtil.parse(result, Split.class);
    }

    public ListResultDTO<Split> list() {
        return this.list(null, null);
    }

    public ListResultDTO<Split> list(Integer offset, Integer limit) {
        String queryParams = (offset != null ? String.format("offset=%s", offset) : "") + (limit != null ? String.format("&limit=%s", limit) : "");
        String result = this._client.get("/v1/splits?%s", queryParams);
        return EncodingUtil.parseListResult(result, Split.class);
    }
}

