/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.dtos.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.split.api.dtos.result.FailureDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ResultDTO<T> {
    private List<T> objects;
    private List<FailureDTO<T>> failed;
    private Map<String, String> metadata;
    private Integer offset;
    private Integer limit;
    private Integer count;
    private Integer total;

    public ResultDTO() {
        this.objects = new ArrayList<T>();
        this.failed = new ArrayList<FailureDTO<T>>();
        this.metadata = new HashMap<String, String>();
    }

    public ResultDTO(Builder builder) {
        this.objects = builder.objects;
        this.failed = builder.failed;
        this.metadata = builder.metadata;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.count = builder.count;
        this.total = builder.total;
    }

    @JsonProperty
    public List<T> objects() {
        return this.objects;
    }

    @JsonProperty
    public List<FailureDTO<T>> failed() {
        return this.failed;
    }

    @JsonProperty
    public Integer offset() {
        return this.offset;
    }

    @JsonProperty
    public Integer limit() {
        return this.limit;
    }

    @JsonProperty
    public Integer count() {
        return this.count;
    }

    @JsonProperty
    public Integer total() {
        return this.total;
    }

    @JsonProperty
    public Map<String, String> metadata() {
        return this.metadata;
    }

    public void setObjects(List<T> objects) {
        this.objects = objects;
    }

    public void setFailed(List<FailureDTO<T>> failed) {
        this.failed = failed;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultDTO resultDTO = (ResultDTO)o;
        if (this.objects != null ? !this.objects.equals(resultDTO.objects) : resultDTO.objects != null) {
            return false;
        }
        if (this.failed != null ? !this.failed.equals(resultDTO.failed) : resultDTO.failed != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(resultDTO.metadata) : resultDTO.metadata != null) {
            return false;
        }
        if (this.offset != null ? !this.offset.equals(resultDTO.offset) : resultDTO.offset != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(resultDTO.limit) : resultDTO.limit != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(resultDTO.count) : resultDTO.count != null) {
            return false;
        }
        return this.total != null ? this.total.equals(resultDTO.total) : resultDTO.total == null;
    }

    public int hashCode() {
        int result = this.objects != null ? this.objects.hashCode() : 0;
        result = 31 * result + (this.failed != null ? this.failed.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
        result = 31 * result + (this.total != null ? this.total.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResultDTO{objects=" + this.objects + ", failed=" + this.failed + ", metadata=" + this.metadata + ", offset=" + this.offset + ", limit=" + this.limit + ", count=" + this.count + ", total=" + this.total + '}';
    }

    public static class Builder<T> {
        private Integer offset;
        private Integer limit;
        private List<T> objects;
        private List<FailureDTO<T>> failed;
        private Map<String, String> metadata;
        private Integer count;
        private Integer total;

        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public Builder objects(List<T> objects) {
            this.objects = objects;
            return this;
        }

        public Builder failed(List<FailureDTO<T>> failed) {
            this.failed = failed;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        Builder() {
            this.objects = new ArrayList<T>();
            this.failed = new ArrayList<FailureDTO<T>>();
            this.metadata = new HashMap<String, String>();
        }

        Builder(ResultDTO prototype) {
            this.offset = prototype.offset;
            this.limit = prototype.limit;
            this.objects = prototype.objects;
            this.failed = prototype.failed;
            this.total = prototype.total;
            this.count = prototype.count;
        }

        public ResultDTO<T> build() {
            return new ResultDTO(this);
        }
    }
}

