/*
 * Decompiled with CFR 0.152.
 */
package me.dwtj.java.compiler.runner;

import com.sun.source.tree.CompilationUnitTree;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import me.dwtj.java.compiler.proc.CompilationUnitsProcessor;
import me.dwtj.java.compiler.proc.UniversalProcessor;

public final class CompilationTaskBuilder {
    private boolean isBuilt = false;
    private List<Processor> processors = new ArrayList<Processor>();
    private List<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
    private List<String> options = new ArrayList<String>();
    private List<String> classes = new ArrayList<String>();
    private StandardJavaFileManagerConfig fileManagerConfig = new StandardJavaFileManagerConfig();
    public static final String TEMP_DIR_PREFIX = "java-compiler-runner-";

    private CompilationTaskBuilder() {
    }

    public static CompilationTaskBuilder newBuilder() {
        return new CompilationTaskBuilder();
    }

    public JavaCompiler.CompilationTask build() throws IOException {
        if (this.isBuilt) {
            String msg = "`CompilationTaskBuilder.build()` can only be called once.";
            throw new IllegalStateException(msg);
        }
        JavaCompiler.CompilationTask task = this.buildTask();
        this.finish();
        return task;
    }

    public CompilationTaskBuilder addProc(Processor proc) {
        assert (proc != null);
        this.processors.add(proc);
        return this;
    }

    public CompilationTaskBuilder addProc(BiConsumer<ProcessingEnvironment, RoundEnvironment> task) {
        assert (task != null);
        this.addProc(new UniversalProcessor(task));
        return this;
    }

    public CompilationTaskBuilder addProc(Consumer<CompilationUnitTree> task) {
        assert (task != null);
        this.addProc(new CompilationUnitsProcessor(task));
        return this;
    }

    public CompilationTaskBuilder setFileManagerConfig(StandardJavaFileManagerConfig config) {
        assert (config != null);
        this.fileManagerConfig = config;
        return this;
    }

    public CompilationTaskBuilder addClass(String cls) {
        this.classes.add(cls);
        return this;
    }

    public CompilationTaskBuilder addAllClasses(Iterable<String> classes) {
        classes.forEach(this::addClass);
        return this;
    }

    public CompilationTaskBuilder addOption(String opt) {
        this.options.add(opt);
        return this;
    }

    public CompilationTaskBuilder addAllOptions(Iterable<String> opts) {
        opts.forEach(this::addOption);
        return null;
    }

    public CompilationTaskBuilder addCompilationUnit(JavaFileObject unit) {
        assert (unit != null);
        this.compilationUnits.add(unit);
        return this;
    }

    public CompilationTaskBuilder addAllCompilationUnits(Iterable<JavaFileObject> units) {
        assert (units != null);
        units.forEach(this::addCompilationUnit);
        return this;
    }

    public CompilationTaskBuilder addProcOnlyOption() {
        this.options.add("-proc:only");
        return this;
    }

    private JavaCompiler.CompilationTask buildTask() throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        this.fileManagerConfig.config(fileManager);
        for (String c : this.classes) {
            JavaFileObject srcFile = fileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, c, JavaFileObject.Kind.SOURCE);
            if (srcFile == null) {
                throw new IOException("No such class found on the source path: " + c);
            }
            this.compilationUnits.add(srcFile);
        }
        if (this.compilationUnits.isEmpty()) {
            String msg = "CompilationTaskBuilder: No compilation units have been added.";
            throw new IllegalStateException(msg);
        }
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, this.options, null, this.compilationUnits);
        task.setProcessors(this.processors);
        return task;
    }

    private void finish() {
        this.isBuilt = true;
        this.processors = null;
        this.compilationUnits = null;
        this.options = null;
        this.fileManagerConfig = null;
    }

    public static File tempDir() throws IOException {
        return Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
    }

    public static class StandardJavaFileManagerConfig {
        private EnumMap<StandardLocation, List<File>> locations;

        public static StandardJavaFileManagerConfig makeConfig() {
            return new StandardJavaFileManagerConfig();
        }

        public static StandardJavaFileManagerConfig makeConfig(StandardJavaFileManager from) {
            assert (from != null);
            StandardJavaFileManagerConfig to = StandardJavaFileManagerConfig.makeConfig();
            for (StandardLocation l : StandardLocation.values()) {
                Iterable<? extends File> files = from.getLocation(l);
                if (files == null) continue;
                to.addAllTo(l, files);
            }
            return to;
        }

        public static StandardJavaFileManagerConfig makeConfig(StandardJavaFileManagerConfig from) {
            assert (from != null);
            StandardJavaFileManagerConfig to = StandardJavaFileManagerConfig.makeConfig();
            for (StandardLocation l : StandardLocation.values()) {
                Iterable files = from.locations.get(l);
                if (files == null) continue;
                to.addAllTo(l, files);
            }
            return to;
        }

        private StandardJavaFileManagerConfig() {
            this.reInit();
        }

        public void reInit() {
            this.locations = new EnumMap(StandardLocation.class);
        }

        public StandardJavaFileManagerConfig addTo(StandardLocation location, File file) {
            assert (location != null);
            assert (file != null);
            this.locations.putIfAbsent(location, new ArrayList());
            this.locations.get(location).add(file);
            return this;
        }

        public StandardJavaFileManagerConfig addAllTo(StandardLocation location, Iterable<? extends File> files) {
            assert (location != null);
            assert (files != null);
            files.forEach(f -> this.addTo(location, (File)f));
            return this;
        }

        public StandardJavaFileManagerConfig setAs(StandardLocation location, File file) {
            assert (location != null);
            this.locations.put(location, null);
            if (file != null) {
                this.addTo(location, file);
            }
            return this;
        }

        public StandardJavaFileManagerConfig addToClassPath(File f) {
            this.addTo(StandardLocation.CLASS_PATH, f);
            return this;
        }

        public StandardJavaFileManagerConfig addAllToClassPath(Iterable<File> fs) {
            this.addAllTo(StandardLocation.CLASS_PATH, fs);
            return this;
        }

        public StandardJavaFileManagerConfig addToSourcePath(File f) {
            this.addTo(StandardLocation.SOURCE_PATH, f);
            return this;
        }

        public StandardJavaFileManagerConfig addAllToSourcePath(Iterable<File> fs) {
            this.addAllTo(StandardLocation.SOURCE_PATH, fs);
            return this;
        }

        public StandardJavaFileManagerConfig setClassOutputDir(File dir) {
            this.setAs(StandardLocation.CLASS_OUTPUT, dir);
            return this;
        }

        public StandardJavaFileManagerConfig setSourceOutputDir(File dir) {
            this.setAs(StandardLocation.SOURCE_OUTPUT, dir);
            return this;
        }

        public StandardJavaFileManager config(StandardJavaFileManager fileManager) throws IOException {
            assert (fileManager != null);
            for (StandardLocation l : StandardLocation.values()) {
                fileManager.setLocation(l, (Iterable<? extends File>)this.locations.get(l));
            }
            this.reInit();
            return fileManager;
        }
    }
}

