/*
 * Decompiled with CFR 0.152.
 */
package com.kamikaze.pfordelta;

import com.kamikaze.pfordelta.PForDeltaUnpack128;
import com.kamikaze.pfordelta.Simple16;
import java.util.Arrays;

public class PForDelta {
    private static final int[] POSSIBLE_B = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 20, 28};
    private static final int MAX_BITS = 32;
    private static final int HEADER_NUM = 2;
    private static final int HEADER_SIZE = 64;
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};

    public static int[] compressOneBlockOpt(int[] inBlock, int blockSize) {
        int currentB = POSSIBLE_B[0];
        int[] outBlock = null;
        int tmpB = currentB;
        boolean hasBigNum = PForDelta.checkBigNumbers(inBlock, POSSIBLE_B[POSSIBLE_B.length - 1], blockSize);
        if (hasBigNum) {
            currentB = 4;
            System.out.println("has big num and the currentB is: " + currentB);
        } else {
            int optSize = PForDelta.estimateCompressedSize(inBlock, tmpB, blockSize);
            for (int i = 1; i < POSSIBLE_B.length; ++i) {
                tmpB = POSSIBLE_B[i];
                int curSize = PForDelta.estimateCompressedSize(inBlock, tmpB, blockSize);
                if (curSize >= optSize) continue;
                currentB = tmpB;
                optSize = curSize;
            }
        }
        outBlock = PForDelta.compressOneBlock(inBlock, currentB, blockSize);
        return outBlock;
    }

    public static int decompressOneBlock(int[] outBlock, int[] inBlock, int blockSize) {
        int[] expAux = new int[blockSize * 2];
        int expNum = inBlock[0] & 0x3FF;
        int bits = inBlock[0] >>> 10 & 0x1F;
        int offset = 64;
        int compressedBits = 0;
        if (bits == 0) {
            Arrays.fill(outBlock, 0);
        } else {
            compressedBits = PForDelta.decompressBBitSlots(outBlock, inBlock, blockSize, bits);
        }
        offset += compressedBits;
        if (expNum > 0) {
            compressedBits = PForDelta.decompressBlockByS16(expAux, inBlock, offset, expNum * 2);
            offset += compressedBits;
            for (int i = 0; i < expNum; ++i) {
                int curExpPos = expAux[i];
                int curHighBits = expAux[i + expNum];
                outBlock[curExpPos] = outBlock[curExpPos] & MASK[bits] | (curHighBits & MASK[32 - bits]) << bits;
            }
        }
        return offset;
    }

    public static int estimateCompressedSize(int[] inputBlock, int bits, int blockSize) throws IllegalArgumentException {
        int maxNoExp = (1 << bits) - 1;
        int outputOffset = 64 + bits * blockSize;
        int expNum = 0;
        for (int i = 0; i < blockSize; ++i) {
            if (inputBlock[i] <= maxNoExp) continue;
            ++expNum;
        }
        return outputOffset += expNum << 5;
    }

    public static boolean checkBigNumbers(int[] inputBlock, int bits, int blockSize) throws IllegalArgumentException {
        int maxNoExp = (1 << bits) - 1;
        for (int i = 0; i < blockSize; ++i) {
            if (inputBlock[i] <= maxNoExp) continue;
            return true;
        }
        return false;
    }

    public static int[] compressOneBlock(int[] inputBlock, int bits, int blockSize) throws IllegalArgumentException {
        int[] expAux = new int[blockSize * 2];
        int maxCompBitSize = 64 + blockSize * 96 + 32;
        int[] tmpCompressedBlock = new int[maxCompBitSize >>> 5];
        int outputOffset = 64;
        int expUpperBound = 1 << bits;
        int expNum = 0;
        for (int elem : inputBlock) {
            if (elem < expUpperBound) continue;
            ++expNum;
        }
        int expIndex = 0;
        for (int i = 0; i < blockSize; ++i) {
            if (inputBlock[i] < expUpperBound) {
                PForDelta.writeBits(tmpCompressedBlock, inputBlock[i], outputOffset, bits);
            } else {
                PForDelta.writeBits(tmpCompressedBlock, inputBlock[i] & MASK[bits], outputOffset, bits);
                expAux[expIndex] = i;
                expAux[expIndex + expNum] = inputBlock[i] >>> bits & MASK[32 - bits];
                ++expIndex;
            }
            outputOffset += bits;
        }
        tmpCompressedBlock[0] = (bits & MASK[10]) << 10 | expNum & 0x3FF;
        tmpCompressedBlock[1] = inputBlock[blockSize - 1];
        if (expNum > 0) {
            int compressedBitSize = PForDelta.compressBlockByS16(tmpCompressedBlock, outputOffset, expAux, expNum * 2);
            outputOffset += compressedBitSize;
        }
        int compressedSizeInInts = outputOffset + 31 >>> 5;
        int[] compBlock = new int[compressedSizeInInts];
        System.arraycopy(tmpCompressedBlock, 0, compBlock, 0, compressedSizeInInts);
        return compBlock;
    }

    public static int decompressBBitSlots(int[] outDecompSlots, int[] inCompBlock, int blockSize, int bits) {
        int compressedBitSize = 0;
        int offset = 64;
        for (int i = 0; i < blockSize; ++i) {
            outDecompSlots[i] = PForDelta.readBits(inCompBlock, offset, bits);
            offset += bits;
        }
        compressedBitSize = bits * blockSize;
        return compressedBitSize;
    }

    private static int compressBlockByS16(int[] outCompBlock, int outStartOffsetInBits, int[] inBlock, int blockSize) {
        int num;
        int outOffset = outStartOffsetInBits + 31 >>> 5;
        int inOffset = 0;
        for (int numLeft = blockSize; numLeft > 0; numLeft -= num) {
            num = Simple16.s16Compress(outCompBlock, outOffset, inBlock, inOffset, numLeft, blockSize);
            ++outOffset;
            inOffset += num;
        }
        int compressedBitSize = (outOffset << 5) - outStartOffsetInBits;
        return compressedBitSize;
    }

    public static int decompressBlockByS16(int[] outDecompBlock, int[] inCompBlock, int inStartOffsetInBits, int blockSize) {
        int num;
        int inOffset = inStartOffsetInBits + 31 >>> 5;
        int outOffset = 0;
        for (int numLeft = blockSize; numLeft > 0; numLeft -= num) {
            num = Simple16.s16Decompress(outDecompBlock, outOffset, inCompBlock, inOffset, numLeft);
            outOffset += num;
            ++inOffset;
        }
        int compressedBitSize = (inOffset << 5) - inStartOffsetInBits;
        return compressedBitSize;
    }

    public static final void writeBits(int[] out, int val, int outOffset, int bits) {
        if (bits == 0) {
            return;
        }
        int index = outOffset >>> 5;
        int skip = outOffset & 0x1F;
        int n = index;
        out[n] = out[n] | (val &= -1 >>> 32 - bits) << skip;
        if (32 - skip < bits) {
            int n2 = index + 1;
            out[n2] = out[n2] | val >>> 32 - skip;
        }
    }

    static int decompressBBitSlotsWithHardCodes(int[] decompressedSlots, int[] compBlock, int blockSize, int bits) {
        int compressedBitSize = 0;
        PForDeltaUnpack128.unpack(decompressedSlots, compBlock, bits);
        compressedBitSize = bits * blockSize;
        return compressedBitSize;
    }

    public static final int readBits(int[] in, int inOffset, int bits) {
        int index = inOffset >>> 5;
        int skip = inOffset & 0x1F;
        int val = in[index] >>> skip;
        if (32 - skip < bits) {
            val |= in[index + 1] << 32 - skip;
        }
        return val & -1 >>> 32 - bits;
    }
}

