/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.benchmarktools;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Random;
import me.lemire.integercompression.BinaryPacking;
import me.lemire.integercompression.DeltaZigzagBinaryPacking;
import me.lemire.integercompression.DeltaZigzagVariableByte;
import me.lemire.integercompression.FastPFOR;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.IntegratedBinaryPacking;
import me.lemire.integercompression.JustCopy;
import me.lemire.integercompression.XorBinaryPacking;
import me.lemire.integercompression.benchmarktools.PerformanceLogger;

public class BenchmarkOffsettedSeries {
    private static final int DEFAULT_MEAN = 0x100000;
    private static final int DEFAULT_RANGE = 1024;
    private static final int DEFAULT_REPEAT = 5;
    private static final int DEFAULT_WARMUP = 2;

    public static void run(PrintWriter csvWriter, int count, int length) {
        IntegerCODEC[] codecs = new IntegerCODEC[]{new JustCopy(), new BinaryPacking(), new DeltaZigzagBinaryPacking(), new DeltaZigzagVariableByte(), new IntegratedBinaryPacking(), new XorBinaryPacking(), new FastPFOR()};
        csvWriter.format("\"Dataset\",\"CODEC\",\"Bits per int\",\"Compress speed (MiS)\",\"Decompress speed (MiS)\"\n", new Object[0]);
        BenchmarkOffsettedSeries.benchmark(csvWriter, codecs, count, length, 0x100000, 1024);
        BenchmarkOffsettedSeries.benchmark(csvWriter, codecs, count, length, 32768, 1024);
        IntegerCODEC[] codecs2 = new IntegerCODEC[]{new JustCopy(), new BinaryPacking(), new DeltaZigzagBinaryPacking(), new DeltaZigzagVariableByte(), new IntegratedBinaryPacking(), new XorBinaryPacking(), new FastPFOR()};
        int freq = length / 4;
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 0x100000, 1024, freq);
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 32768, 1024, freq);
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 1024, 1024, freq);
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 0x100000, 256, freq);
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 32768, 256, freq);
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 1024, 256, freq);
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 0x100000, 64, freq);
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 32768, 64, freq);
        BenchmarkOffsettedSeries.benchmarkSine(csvWriter, codecs2, count, length, 1024, 64, freq);
    }

    private static void benchmarkSine(PrintWriter csvWriter, IntegerCODEC[] codecs, int count, int length, int mean, int range, int freq) {
        String dataProp = String.format("(mean=%1$d range=%2$d freq=%2$d)", mean, range, freq);
        int[][] data = BenchmarkOffsettedSeries.generateSineDataChunks(0L, count, length, mean, range, freq);
        BenchmarkOffsettedSeries.benchmark(csvWriter, "Sine " + dataProp, codecs, data, 5, 2);
        BenchmarkOffsettedSeries.benchmark(csvWriter, "Sine+delta " + dataProp, codecs, data, 5, 2);
    }

    private static void benchmark(PrintWriter csvWriter, IntegerCODEC[] codecs, int count, int length, int mean, int range) {
        String dataProp = String.format("(mean=%1$d range=%2$d)", mean, range);
        int[][] randData = BenchmarkOffsettedSeries.generateDataChunks(0L, count, length, mean, range);
        int[][] deltaData = BenchmarkOffsettedSeries.deltaDataChunks(randData);
        int[][] sortedData = BenchmarkOffsettedSeries.sortDataChunks(randData);
        int[][] sortedDeltaData = BenchmarkOffsettedSeries.deltaDataChunks(sortedData);
        BenchmarkOffsettedSeries.benchmark(csvWriter, "Random " + dataProp, codecs, randData, 5, 2);
        BenchmarkOffsettedSeries.benchmark(csvWriter, "Random+delta " + dataProp, codecs, deltaData, 5, 2);
        BenchmarkOffsettedSeries.benchmark(csvWriter, "Sorted " + dataProp, codecs, sortedData, 5, 2);
        BenchmarkOffsettedSeries.benchmark(csvWriter, "Sorted+delta " + dataProp, codecs, sortedDeltaData, 5, 2);
    }

    private static void benchmark(PrintWriter csvWriter, String dataName, IntegerCODEC[] codecs, int[][] data, int repeat, int warmup) {
        System.out.println("Processing: " + dataName);
        for (IntegerCODEC codec : codecs) {
            String codecName = codec.toString();
            for (int i = 0; i < warmup; ++i) {
                BenchmarkOffsettedSeries.benchmark(null, null, null, codec, data, repeat);
            }
            BenchmarkOffsettedSeries.benchmark(csvWriter, dataName, codecName, codec, data, repeat);
        }
    }

    private static void benchmark(PrintWriter csvWriter, String dataName, String codecName, IntegerCODEC codec, int[][] data, int repeat) {
        PerformanceLogger logger = new PerformanceLogger();
        int maxLen = BenchmarkOffsettedSeries.getMaxLen(data);
        int[] compressBuffer = new int[4 * maxLen + 1024];
        int[] decompressBuffer = new int[maxLen];
        for (int i = 0; i < repeat; ++i) {
            for (int[] array : data) {
                int compSize = BenchmarkOffsettedSeries.compress(logger, codec, array, compressBuffer);
                int decompSize = BenchmarkOffsettedSeries.decompress(logger, codec, compressBuffer, compSize, decompressBuffer);
                BenchmarkOffsettedSeries.checkArray(array, decompressBuffer, decompSize, codec);
            }
        }
        if (csvWriter != null) {
            csvWriter.format("\"%1$s\",\"%2$s\",%3$.2f,%4$.0f,%5$.0f\n", dataName, codecName, logger.getBitPerInt(), logger.getCompressSpeed(), logger.getDecompressSpeed());
        }
    }

    private static void checkArray(int[] expected, int[] actualArray, int actualLen, IntegerCODEC codec) {
        if (actualLen != expected.length) {
            throw new RuntimeException("Length mismatch: expected=" + expected.length + " actual=" + actualLen + " codec=" + codec.toString());
        }
        for (int i = 0; i < expected.length; ++i) {
            if (actualArray[i] == expected[i]) continue;
            throw new RuntimeException("Value mismatch:  where=" + i + " expected=" + expected[i] + " actual=" + actualArray[i] + " codec=" + codec.toString());
        }
    }

    private static int compress(PerformanceLogger logger, IntegerCODEC codec, int[] src, int[] dst) {
        IntWrapper inpos = new IntWrapper();
        IntWrapper outpos = new IntWrapper();
        logger.compressionTimer.start();
        codec.compress(src, inpos, src.length, dst, outpos);
        logger.compressionTimer.end();
        int outSize = outpos.get();
        logger.addOriginalSize(src.length);
        logger.addCompressedSize(outSize);
        return outSize;
    }

    private static int decompress(PerformanceLogger logger, IntegerCODEC codec, int[] src, int srcLen, int[] dst) {
        IntWrapper inpos = new IntWrapper();
        IntWrapper outpos = new IntWrapper();
        logger.decompressionTimer.start();
        codec.uncompress(src, inpos, srcLen, dst, outpos);
        logger.decompressionTimer.end();
        return outpos.get();
    }

    private static int getMaxLen(int[][] data) {
        int maxLen = 0;
        for (int[] array : data) {
            if (array.length <= maxLen) continue;
            maxLen = array.length;
        }
        return maxLen;
    }

    private static int[][] generateSineDataChunks(long seed, int count, int length, int mean, int range, int freq) {
        int[][] chunks = new int[count][];
        Random r = new Random(seed);
        for (int i = 0; i < count; ++i) {
            chunks[i] = new int[length];
            int[] chunk = chunks[i];
            int phase = r.nextInt(2 * freq);
            for (int j = 0; j < length; ++j) {
                double angle = Math.PI * 2 * (double)(j + phase) / (double)freq;
                chunk[j] = (int)((double)mean + Math.sin(angle) * (double)range);
            }
        }
        return chunks;
    }

    private static int[][] generateDataChunks(long seed, int count, int length, int mean, int range) {
        int offset = mean - range / 2;
        int[][] chunks = new int[count][];
        Random r = new Random(seed);
        for (int i = 0; i < count; ++i) {
            chunks[i] = new int[length];
            int[] chunk = chunks[i];
            for (int j = 0; j < length; ++j) {
                chunk[j] = r.nextInt(range) + offset;
            }
        }
        return chunks;
    }

    private static int[][] deltaDataChunks(int[][] src) {
        int[][] dst = new int[src.length][];
        for (int i = 0; i < src.length; ++i) {
            int[] s = src[i];
            dst[i] = new int[s.length];
            int[] d = dst[i];
            int prev = 0;
            for (int j = 0; j < s.length; ++j) {
                d[j] = s[j] - prev;
                prev = s[j];
            }
        }
        return dst;
    }

    private static int[][] sortDataChunks(int[][] src) {
        int[][] dst = new int[src.length][];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Arrays.copyOf(src[i], src[i].length);
            Arrays.sort(dst[i]);
        }
        return dst;
    }

    public static void main(String[] args) throws Exception {
        File csvFile = new File(String.format("benchmark-offsetted-%1$tY%1$tm%1$tdT%1$tH%1$tM%1$tS.csv", System.currentTimeMillis()));
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(csvFile);
            System.out.println("# Results will be written into a CSV file: " + csvFile.getName());
            System.out.println();
            BenchmarkOffsettedSeries.run(writer, 8192, 1280);
            System.out.println();
            System.out.println("# Results were written into a CSV file: " + csvFile.getName());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

