/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.differential;

import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.Util;
import me.lemire.integercompression.differential.IntegratedBitPacking;
import me.lemire.integercompression.differential.IntegratedIntegerCODEC;

public class IntegratedBinaryPacking
implements IntegratedIntegerCODEC {
    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if ((inlength = inlength / 128 * 128) == 0) {
            return;
        }
        out[outpos.get()] = inlength;
        outpos.increment();
        int tmpoutpos = outpos.get();
        int initoffset = 0;
        for (int s = inpos.get(); s < inpos.get() + inlength; s += 128) {
            int mbits1 = Util.maxdiffbits(initoffset, in, s, 32);
            int initoffset2 = in[s + 31];
            int mbits2 = Util.maxdiffbits(initoffset2, in, s + 32, 32);
            int initoffset3 = in[s + 32 + 31];
            int mbits3 = Util.maxdiffbits(initoffset3, in, s + 64, 32);
            int initoffset4 = in[s + 64 + 31];
            int mbits4 = Util.maxdiffbits(initoffset4, in, s + 96, 32);
            out[tmpoutpos++] = mbits1 << 24 | mbits2 << 16 | mbits3 << 8 | mbits4;
            IntegratedBitPacking.integratedpack(initoffset, in, s, out, tmpoutpos, mbits1);
            IntegratedBitPacking.integratedpack(initoffset2, in, s + 32, out, tmpoutpos += mbits1, mbits2);
            IntegratedBitPacking.integratedpack(initoffset3, in, s + 64, out, tmpoutpos += mbits2, mbits3);
            IntegratedBitPacking.integratedpack(initoffset4, in, s + 96, out, tmpoutpos += mbits3, mbits4);
            tmpoutpos += mbits4;
            initoffset = in[s + 96 + 31];
        }
        inpos.add(inlength);
        outpos.set(tmpoutpos);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outlength = in[inpos.get()];
        inpos.increment();
        int tmpinpos = inpos.get();
        int initoffset = 0;
        for (int s = outpos.get(); s < outpos.get() + outlength; s += 128) {
            int mbits1 = in[tmpinpos] >>> 24;
            int mbits2 = in[tmpinpos] >>> 16 & 0xFF;
            int mbits3 = in[tmpinpos] >>> 8 & 0xFF;
            int mbits4 = in[tmpinpos] & 0xFF;
            IntegratedBitPacking.integratedunpack(initoffset, in, ++tmpinpos, out, s, mbits1);
            initoffset = out[s + 31];
            IntegratedBitPacking.integratedunpack(initoffset, in, tmpinpos += mbits1, out, s + 32, mbits2);
            initoffset = out[s + 32 + 31];
            IntegratedBitPacking.integratedunpack(initoffset, in, tmpinpos += mbits2, out, s + 64, mbits3);
            initoffset = out[s + 64 + 31];
            IntegratedBitPacking.integratedunpack(initoffset, in, tmpinpos += mbits3, out, s + 96, mbits4);
            tmpinpos += mbits4;
            initoffset = out[s + 96 + 31];
        }
        outpos.add(outlength);
        inpos.set(tmpinpos);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

