/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.differential;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.differential.IntegratedByteIntegerCODEC;
import me.lemire.integercompression.differential.IntegratedIntegerCODEC;

public class IntegratedVariableByte
implements IntegratedIntegerCODEC,
IntegratedByteIntegerCODEC {
    private static byte extract7bits(int i, long val) {
        return (byte)(val >> 7 * i & 0x7FL);
    }

    private static byte extract7bitsmaskless(int i, long val) {
        return (byte)(val >> 7 * i);
    }

    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int initoffset = 0;
        ByteBuffer buf = ByteBuffer.allocateDirect(inlength * 8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = (long)(in[k] - initoffset) & 0xFFFFFFFFL;
            initoffset = in[k];
            if (val < 128L) {
                buf.put((byte)(val | 0x80L));
                continue;
            }
            if (val < 16384L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(1, val) | 0x80));
                continue;
            }
            if (val < 0x200000L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put(IntegratedVariableByte.extract7bits(1, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(2, val) | 0x80));
                continue;
            }
            if (val < 0x10000000L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put(IntegratedVariableByte.extract7bits(1, val));
                buf.put(IntegratedVariableByte.extract7bits(2, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(3, val) | 0x80));
                continue;
            }
            buf.put(IntegratedVariableByte.extract7bits(0, val));
            buf.put(IntegratedVariableByte.extract7bits(1, val));
            buf.put(IntegratedVariableByte.extract7bits(2, val));
            buf.put(IntegratedVariableByte.extract7bits(3, val));
            buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(4, val) | 0x80));
        }
        while (buf.position() % 4 != 0) {
            buf.put((byte)0);
        }
        int length = buf.position();
        buf.flip();
        IntBuffer ibuf = buf.asIntBuffer();
        ibuf.get(out, outpos.get(), length / 4);
        outpos.add(length / 4);
        inpos.add(inlength);
    }

    public void compress(int[] in, IntWrapper inpos, int inlength, byte[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int initoffset = 0;
        ByteBuffer buf = ByteBuffer.allocateDirect(inlength * 8);
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = (long)(in[k] - initoffset) & 0xFFFFFFFFL;
            initoffset = in[k];
            if (val < 128L) {
                buf.put((byte)(val | 0x80L));
                continue;
            }
            if (val < 16384L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(1, val) | 0x80));
                continue;
            }
            if (val < 0x200000L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put(IntegratedVariableByte.extract7bits(1, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(2, val) | 0x80));
                continue;
            }
            if (val < 0x10000000L) {
                buf.put(IntegratedVariableByte.extract7bits(0, val));
                buf.put(IntegratedVariableByte.extract7bits(1, val));
                buf.put(IntegratedVariableByte.extract7bits(2, val));
                buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(3, val) | 0x80));
                continue;
            }
            buf.put(IntegratedVariableByte.extract7bits(0, val));
            buf.put(IntegratedVariableByte.extract7bits(1, val));
            buf.put(IntegratedVariableByte.extract7bits(2, val));
            buf.put(IntegratedVariableByte.extract7bits(3, val));
            buf.put((byte)(IntegratedVariableByte.extract7bitsmaskless(4, val) | 0x80));
        }
        while (buf.position() % 4 != 0) {
            buf.put((byte)0);
        }
        int length = buf.position();
        buf.flip();
        buf.get(out, 0, length);
        outpos.set(length);
        inpos.add(inlength);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int s = 0;
        int val = 0;
        int p = inpos.get();
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        int initoffset = 0;
        int v = 0;
        int shift = 0;
        while (p < finalp) {
            val = in[p];
            byte c = (byte)(val >>> s);
            if ((s += 8) == 32) {
                s = 0;
                ++p;
            }
            v += (c & 0x7F) << shift;
            if ((c & 0x80) == 128) {
                out[tmpoutpos] = v + initoffset;
                initoffset = out[tmpoutpos];
                ++tmpoutpos;
                v = 0;
                shift = 0;
                continue;
            }
            shift += 7;
        }
        outpos.set(tmpoutpos);
        inpos.add(inlength);
    }

    public void uncompress(byte[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int p;
        int initoffset = 0;
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        int v = 0;
        int shift = 0;
        for (p = inpos.get(); p < finalp; ++p) {
            byte c = in[p];
            v += (c & 0x7F) << shift;
            if ((c & 0x80) == 128) {
                out[tmpoutpos] = v + initoffset;
                initoffset = out[tmpoutpos];
                ++tmpoutpos;
                v = 0;
                shift = 0;
                continue;
            }
            shift += 7;
        }
        outpos.set(tmpoutpos);
        inpos.add(p);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

