/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import java.nio.ByteBuffer;
import java.util.Arrays;
import me.lemire.integercompression.BitPacking;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.Util;

public final class FastPFOR
implements IntegerCODEC {
    int PageSize;
    static final int BlockSize = 128;
    static final int overheadofeachexcept = 8;
    int[][] datatobepacked = new int[32][];
    ByteBuffer bytecontainer;

    public FastPFOR(int pagesize) {
        this.PageSize = pagesize;
        this.initArrays();
    }

    public FastPFOR() {
        this.PageSize = 65536;
        this.initArrays();
    }

    public void initArrays() {
        this.bytecontainer = ByteBuffer.allocateDirect(3 * this.PageSize / 128 + this.PageSize);
        for (int k = 1; k < 32; ++k) {
            this.datatobepacked[k] = new int[this.PageSize / 32 * 4];
        }
    }

    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        inlength = inlength / 128 * 128;
        int finalinpos = inpos.get() + inlength;
        out[outpos.get()] = inlength;
        outpos.increment();
        while (inpos.get() != finalinpos) {
            int thissize = finalinpos > this.PageSize + inpos.get() ? this.PageSize : finalinpos - inpos.get();
            this.encodePage(in, inpos, thissize, out, outpos);
        }
    }

    public static void getBestBFromData(int[] in, int pos, byte[] bestbbestcexceptmaxb) {
        byte cexcept;
        int[] freqs = new int[32];
        for (int k = pos; k < 128 + pos; ++k) {
            int n = Util.bits(in[k]);
            freqs[n] = freqs[n] + 1;
        }
        bestbbestcexceptmaxb[0] = 31;
        while (freqs[bestbbestcexceptmaxb[0]] == 0) {
            bestbbestcexceptmaxb[0] = (byte)(bestbbestcexceptmaxb[0] - 1);
        }
        bestbbestcexceptmaxb[2] = bestbbestcexceptmaxb[0];
        int bestcost = bestbbestcexceptmaxb[0] * 128;
        bestbbestcexceptmaxb[1] = cexcept = 0;
        for (int b = bestbbestcexceptmaxb[0] - 1; b >= 0 && (cexcept = (byte)(cexcept + freqs[b + 1])) >= 0; --b) {
            int thiscost = cexcept * 8 + cexcept * (bestbbestcexceptmaxb[2] - b) + b * 128 + 8;
            if (thiscost >= bestcost) continue;
            bestcost = thiscost;
            bestbbestcexceptmaxb[0] = (byte)b;
            bestbbestcexceptmaxb[1] = cexcept;
        }
    }

    private void encodePage(int[] in, IntWrapper inpos, int thissize, int[] out, IntWrapper outpos) {
        int k;
        int headerpos = outpos.get();
        outpos.increment();
        int tmpoutpos = outpos.get();
        int[] datapointers = new int[32];
        this.bytecontainer.clear();
        byte[] bestbbestcexceptmaxb = new byte[3];
        int tmpinpos = inpos.get();
        int finalinpos = tmpinpos + thissize;
        while (tmpinpos + 128 <= finalinpos) {
            FastPFOR.getBestBFromData(in, tmpinpos, bestbbestcexceptmaxb);
            byte tmpbestb = bestbbestcexceptmaxb[0];
            this.bytecontainer.put(bestbbestcexceptmaxb[0]);
            this.bytecontainer.put(bestbbestcexceptmaxb[1]);
            if (bestbbestcexceptmaxb[1] > 0) {
                this.bytecontainer.put(bestbbestcexceptmaxb[2]);
                int index = bestbbestcexceptmaxb[2] - bestbbestcexceptmaxb[0];
                if (datapointers[index] + bestbbestcexceptmaxb[1] >= this.datatobepacked[index].length) {
                    int newsize = 2 * (datapointers[index] + bestbbestcexceptmaxb[1]);
                    newsize = (newsize + 31) / 32 * 32;
                    this.datatobepacked[index] = Arrays.copyOf(this.datatobepacked[index], newsize);
                }
                int maxval = 1 << bestbbestcexceptmaxb[0];
                for (int k2 = 0; k2 < 128; ++k2) {
                    if (in[k2 + tmpinpos] < maxval) continue;
                    this.bytecontainer.put((byte)k2);
                    int n = index;
                    int n2 = datapointers[n];
                    datapointers[n] = n2 + 1;
                    this.datatobepacked[index][n2] = in[k2 + tmpinpos] >>> tmpbestb;
                }
            }
            for (int k3 = 0; k3 < 128; k3 += 32) {
                BitPacking.fastpack(in, tmpinpos + k3, out, tmpoutpos, tmpbestb);
                tmpoutpos += tmpbestb;
            }
            tmpinpos += 128;
        }
        inpos.set(tmpinpos);
        out[headerpos] = tmpoutpos - headerpos;
        while ((this.bytecontainer.position() & 3) != 0) {
            this.bytecontainer.put((byte)0);
        }
        int bytesize = this.bytecontainer.position();
        out[tmpoutpos++] = bytesize;
        int howmanyints = bytesize / 4;
        this.bytecontainer.flip();
        this.bytecontainer.asIntBuffer().get(out, tmpoutpos, howmanyints);
        tmpoutpos += howmanyints;
        int bitmap = 0;
        for (k = 1; k <= 31; ++k) {
            if (datapointers[k] == 0) continue;
            bitmap |= 1 << k - 1;
        }
        out[tmpoutpos++] = bitmap;
        for (k = 1; k <= 31; ++k) {
            if (datapointers[k] == 0) continue;
            out[tmpoutpos++] = datapointers[k];
            for (int j = 0; j < datapointers[k]; j += 32) {
                BitPacking.fastpack(this.datatobepacked[k], j, out, tmpoutpos, k);
                tmpoutpos += k;
            }
        }
        outpos.set(tmpoutpos);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int mynvalue = in[inpos.get()];
        inpos.increment();
        int finalout = outpos.get() + mynvalue;
        while (outpos.get() != finalout) {
            int thissize = finalout > this.PageSize + outpos.get() ? this.PageSize : finalout - outpos.get();
            this.decodePage(in, inpos, out, outpos, thissize);
        }
    }

    private void decodePage(int[] in, IntWrapper inpos, int[] out, IntWrapper outpos, int thissize) {
        int initpos = inpos.get();
        int wheremeta = in[inpos.get()];
        inpos.increment();
        int inexcept = initpos + wheremeta;
        int bytesize = in[inexcept++];
        this.bytecontainer.clear();
        this.bytecontainer.asIntBuffer().put(in, inexcept, bytesize / 4);
        inexcept += bytesize / 4;
        int bitmap = in[inexcept++];
        for (int k = 1; k <= 31; ++k) {
            int size;
            if ((bitmap & 1 << k - 1) == 0) continue;
            if (this.datatobepacked[k].length < (size = in[inexcept++])) {
                this.datatobepacked[k] = new int[(size + 31) / 32 * 32];
            }
            for (int j = 0; j < size; j += 32) {
                BitPacking.fastunpack(in, inexcept, this.datatobepacked[k], j, k);
                inexcept += k;
            }
        }
        int[] datapointers = new int[32];
        int tmpoutpos = outpos.get();
        int tmpinpos = inpos.get();
        int run = 0;
        while (run < thissize / 128) {
            byte b = this.bytecontainer.get();
            int cexcept = this.bytecontainer.get();
            for (int k = 0; k < 128; k += 32) {
                BitPacking.fastunpack(in, tmpinpos, out, tmpoutpos + k, b);
                tmpinpos += b;
            }
            if (cexcept > 0) {
                byte maxbits = this.bytecontainer.get();
                int index = maxbits - b;
                for (int k = 0; k < cexcept; ++k) {
                    byte pos = this.bytecontainer.get();
                    int n = index;
                    int n2 = datapointers[n];
                    datapointers[n] = n2 + 1;
                    int exceptvalue = this.datatobepacked[index][n2];
                    int n3 = pos + tmpoutpos;
                    out[n3] = out[n3] | exceptvalue << b;
                }
            }
            ++run;
            tmpoutpos += 128;
        }
        outpos.set(tmpoutpos);
        inpos.set(inexcept);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

