/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import me.lemire.integercompression.BitPacking;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.S9;
import me.lemire.integercompression.Util;

public final class OptPFDS9
implements IntegerCODEC {
    final int PageSize;
    static final int BlockSize = 128;
    int[] exceptbuffer = new int[256];
    protected static final int[] bits = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 20, 32};
    protected static final int[] invbits = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};

    public OptPFDS9() {
        this.PageSize = 65536;
    }

    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if ((inlength = inlength / 128 * 128) == 0) {
            return;
        }
        int finalinpos = inpos.get() + inlength;
        out[outpos.get()] = inlength;
        outpos.increment();
        while (inpos.get() != finalinpos) {
            int thissize = finalinpos > this.PageSize + inpos.get() ? this.PageSize : finalinpos - inpos.get();
            this.encodePage(in, inpos, thissize, out, outpos);
        }
    }

    protected void getBestBFromData(int[] in, int pos, IntWrapper bestb, IntWrapper bestexcept) {
        int mini = 0;
        int mb = Util.maxbits(in, pos, 128);
        if (mini + 28 < bits[invbits[mb]]) {
            mini = bits[invbits[mb]] - 28;
        }
        int besti = bits.length - 1;
        int bestcost = bits[besti] * 4;
        int exceptcounter = 0;
        for (int i = mini; i < bits.length - 1; ++i) {
            int k;
            int tmpcounter = 0;
            for (k = pos; k < 128 + pos; ++k) {
                if (in[k] >>> bits[i] == 0) continue;
                ++tmpcounter;
            }
            if (tmpcounter == 128) continue;
            int c = 0;
            for (k = pos; k < pos + 128; ++k) {
                if (in[k] >>> bits[i] == 0) continue;
                this.exceptbuffer[tmpcounter + c] = k - pos;
                this.exceptbuffer[c] = in[k] >>> bits[i];
                ++c;
            }
            int thiscost = bits[i] * 4 + S9.estimatecompress(this.exceptbuffer, 0, 2 * tmpcounter);
            if (thiscost > bestcost) continue;
            bestcost = thiscost;
            besti = i;
            exceptcounter = tmpcounter;
        }
        bestb.set(besti);
        bestexcept.set(exceptcounter);
    }

    private void encodePage(int[] in, IntWrapper inpos, int thissize, int[] out, IntWrapper outpos) {
        int tmpoutpos = outpos.get();
        int tmpinpos = inpos.get();
        IntWrapper bestb = new IntWrapper();
        IntWrapper bestexcept = new IntWrapper();
        int finalinpos = tmpinpos + thissize;
        while (tmpinpos + 128 <= finalinpos) {
            this.getBestBFromData(in, tmpinpos, bestb, bestexcept);
            int tmpbestb = bestb.get();
            int nbrexcept = bestexcept.get();
            int exceptsize = 0;
            int remember = tmpoutpos++;
            if (nbrexcept > 0) {
                int c = 0;
                for (int i = 0; i < 128; ++i) {
                    if (in[tmpinpos + i] >>> bits[tmpbestb] == 0) continue;
                    this.exceptbuffer[c + nbrexcept] = i;
                    this.exceptbuffer[c] = in[tmpinpos + i] >>> bits[tmpbestb];
                    ++c;
                }
                exceptsize = S9.compress(this.exceptbuffer, 0, 2 * nbrexcept, out, tmpoutpos);
                tmpoutpos += exceptsize;
            }
            out[remember] = tmpbestb | nbrexcept << 8 | exceptsize << 16;
            for (int k = 0; k < 128; k += 32) {
                BitPacking.fastpack(in, tmpinpos + k, out, tmpoutpos, bits[tmpbestb]);
                tmpoutpos += bits[tmpbestb];
            }
            tmpinpos += 128;
        }
        inpos.set(tmpinpos);
        outpos.set(tmpoutpos);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int mynvalue = in[inpos.get()];
        inpos.increment();
        int finalout = outpos.get() + mynvalue;
        while (outpos.get() != finalout) {
            int thissize = finalout > this.PageSize + outpos.get() ? this.PageSize : finalout - outpos.get();
            this.decodePage(in, inpos, out, outpos, thissize);
        }
    }

    private void decodePage(int[] in, IntWrapper inpos, int[] out, IntWrapper outpos, int thissize) {
        int tmpoutpos = outpos.get();
        int tmpinpos = inpos.get();
        int run = 0;
        while (run < thissize / 128) {
            int k;
            int b = in[tmpinpos] & 0xFF;
            int cexcept = in[tmpinpos] >>> 8 & 0xFF;
            int exceptsize = in[tmpinpos] >>> 16;
            S9.uncompress(in, ++tmpinpos, exceptsize, this.exceptbuffer, 0, 2 * cexcept);
            tmpinpos += exceptsize;
            for (k = 0; k < 128; k += 32) {
                BitPacking.fastunpack(in, tmpinpos, out, tmpoutpos + k, bits[b]);
                tmpinpos += bits[b];
            }
            for (k = 0; k < cexcept; ++k) {
                int n = tmpoutpos + this.exceptbuffer[k + cexcept];
                out[n] = out[n] | this.exceptbuffer[k] << bits[b];
            }
            ++run;
            tmpoutpos += 128;
        }
        outpos.set(tmpoutpos);
        inpos.set(tmpinpos);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

