/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;

public class VariableByte
implements IntegerCODEC {
    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(inlength * 8);
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            int val = in[k];
            do {
                int b = val & 0x7F;
                if ((val >>>= 7) != 0) {
                    b |= 0x80;
                }
                buf.put((byte)b);
            } while (val != 0);
        }
        while (buf.position() % 4 != 0) {
            buf.put((byte)-128);
        }
        int length = buf.position();
        buf.flip();
        IntBuffer ibuf = buf.asIntBuffer();
        ibuf.get(out, outpos.get(), length / 4);
        outpos.add(length / 4);
        inpos.add(inlength);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int s = 0;
        int p = inpos.get();
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        int v = 0;
        int shift = 0;
        while (p < finalp) {
            byte c = (byte)(in[p] >>> 24 - s);
            if ((s += 8) == 32) {
                s = 0;
                ++p;
            }
            v += (c & 0x7F) << shift;
            if ((c & 0x80) == 0) {
                out[tmpoutpos++] = v;
                v = 0;
                shift = 0;
                continue;
            }
            shift += 7;
        }
        outpos.set(tmpoutpos);
        inpos.add(inlength);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

