/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import me.lemire.integercompression.BitPacking;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegratedIntegerCODEC;

public final class XorBinaryPacking
implements IntegratedIntegerCODEC {
    public static final boolean DEBUG_DISABLE_BITPACKING = false;
    public static final int BLOCK_LENGTH = 128;

    public void compress(int[] inBuf, IntWrapper inPos, int inLen, int[] outBuf, IntWrapper outPos) {
        int ip;
        if ((inLen -= inLen % 128) == 0) {
            return;
        }
        outBuf[outPos.get()] = inLen;
        outPos.increment();
        int context = 0;
        int[] work = new int[32];
        int op = outPos.get();
        int inPosLast = ip + inLen;
        for (ip = inPos.get(); ip < inPosLast; ip += 128) {
            int bits1 = XorBinaryPacking.xorMaxBits(inBuf, ip + 0, 32, context);
            int bits2 = XorBinaryPacking.xorMaxBits(inBuf, ip + 32, 32, inBuf[ip + 31]);
            int bits3 = XorBinaryPacking.xorMaxBits(inBuf, ip + 64, 32, inBuf[ip + 63]);
            int bits4 = XorBinaryPacking.xorMaxBits(inBuf, ip + 96, 32, inBuf[ip + 95]);
            outBuf[op++] = bits1 << 24 | bits2 << 16 | bits3 << 8 | bits4 << 0;
            op += XorBinaryPacking.xorPack(inBuf, ip + 0, outBuf, op, bits1, context, work);
            op += XorBinaryPacking.xorPack(inBuf, ip + 32, outBuf, op, bits2, inBuf[ip + 31], work);
            op += XorBinaryPacking.xorPack(inBuf, ip + 64, outBuf, op, bits3, inBuf[ip + 63], work);
            op += XorBinaryPacking.xorPack(inBuf, ip + 96, outBuf, op, bits4, inBuf[ip + 95], work);
            context = inBuf[ip + 127];
        }
        inPos.add(inLen);
        outPos.set(op);
    }

    public void uncompress(int[] inBuf, IntWrapper inPos, int inLen, int[] outBuf, IntWrapper outPos) {
        int op;
        if (inLen == 0) {
            return;
        }
        int outLen = inBuf[inPos.get()];
        inPos.increment();
        int context = 0;
        int[] work = new int[32];
        int ip = inPos.get();
        int outPosLast = op + outLen;
        for (op = outPos.get(); op < outPosLast; op += 128) {
            int bits1 = inBuf[ip] >>> 24;
            int bits2 = inBuf[ip] >>> 16 & 0xFF;
            int bits3 = inBuf[ip] >>> 8 & 0xFF;
            int bits4 = inBuf[ip] >>> 0 & 0xFF;
            ++ip;
            ip += XorBinaryPacking.xorUnpack(inBuf, ip, outBuf, op + 0, bits1, context, work);
            ip += XorBinaryPacking.xorUnpack(inBuf, ip, outBuf, op + 32, bits2, outBuf[op + 31], work);
            ip += XorBinaryPacking.xorUnpack(inBuf, ip, outBuf, op + 64, bits3, outBuf[op + 63], work);
            ip += XorBinaryPacking.xorUnpack(inBuf, ip, outBuf, op + 96, bits4, outBuf[op + 95], work);
            context = outBuf[op + 127];
        }
        outPos.add(outLen);
        inPos.set(ip);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static int xorMaxBits(int[] buf, int offset, int length, int context) {
        int mask = buf[offset] ^ context;
        int M = offset + length;
        int i = offset + 1;
        int prev = offset;
        while (i < M) {
            mask |= buf[i] ^ buf[prev];
            ++i;
            ++prev;
        }
        return 32 - Integer.numberOfLeadingZeros(mask);
    }

    public static int xorPack(int[] inBuf, int inOff, int[] outBuf, int outOff, int validBits, int context, int[] work) {
        work[0] = inBuf[inOff] ^ context;
        int i = 1;
        int p = inOff + 1;
        while (i < 32) {
            work[i] = inBuf[p] ^ inBuf[p - 1];
            ++i;
            ++p;
        }
        BitPacking.fastpackwithoutmask(work, 0, outBuf, outOff, validBits);
        return validBits;
    }

    public static int xorUnpack(int[] inBuf, int inOff, int[] outBuf, int outOff, int validBits, int context, int[] work) {
        BitPacking.fastunpack(inBuf, inOff, work, 0, validBits);
        outBuf[outOff] = context = work[0] ^ context;
        int i = 1;
        int p = outOff + 1;
        while (i < 32) {
            outBuf[p] = context = work[i] ^ context;
            ++i;
            ++p;
        }
        return validBits;
    }
}

