/*
 * Decompiled with CFR 0.152.
 */
package com.kamikaze.pfordelta;

import com.kamikaze.pfordelta.PForDeltaUnpack128;
import com.kamikaze.pfordelta.PForDeltaUnpack128WIthIntBuffer;
import com.kamikaze.pfordelta.Simple16;
import com.kamikaze.pfordelta.Simple16WithHardCodes;
import java.nio.IntBuffer;
import java.util.Arrays;

public class LCPForDelta {
    private static final int[] POSSIBLE_B = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 20, 28};
    private static final int POSSIBLE_B_BITS = 5;
    private static final int MAX_BITS = 32;
    private static final int HEADER_NUM = 1;
    private static final int HEADER_SIZE = 32;
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private int[] compBuffer;

    public int[] getCompBuffer() {
        return this.compBuffer;
    }

    public void setCompBuffer(int[] buffer) {
        this.compBuffer = buffer;
    }

    public int compress(int[] inBlock, int blockSize) {
        int currentB;
        int tmpB = currentB = POSSIBLE_B[0];
        boolean hasBigNum = LCPForDelta.checkBigNumbers(inBlock, blockSize, POSSIBLE_B[POSSIBLE_B.length - 1]);
        if (hasBigNum) {
            currentB = 4;
        } else {
            int optSize = LCPForDelta.estimateCompressedSize(inBlock, blockSize, tmpB);
            for (int i = 1; i < POSSIBLE_B.length; ++i) {
                tmpB = POSSIBLE_B[i];
                int curSize = LCPForDelta.estimateCompressedSize(inBlock, blockSize, tmpB);
                if (curSize >= optSize) continue;
                currentB = tmpB;
                optSize = curSize;
            }
        }
        int compressedSizeInInts = this.compressOneBlockCore(inBlock, blockSize, currentB);
        return compressedSizeInInts;
    }

    public int compressOneBlockCore(int[] inputBlock, int blockSize, int bits) throws IllegalArgumentException {
        int outputOffset = 32;
        int expUpperBound = 1 << bits;
        int expNum = 0;
        int maxCompBitSize = 32 + blockSize * 96 + 32;
        int[] tmpCompBuffer = new int[maxCompBitSize >>> 5];
        int[] expPosBuffer = new int[blockSize];
        int[] expHighBitsBuffer = new int[blockSize];
        for (int i = 0; i < blockSize; ++i) {
            int value = inputBlock[i];
            if (value < expUpperBound) {
                LCPForDelta.writeBits(tmpCompBuffer, value, outputOffset, bits);
            } else {
                LCPForDelta.writeBits(tmpCompBuffer, value & MASK[bits], outputOffset, bits);
                expPosBuffer[expNum] = i;
                expHighBitsBuffer[expNum] = value >>> bits & MASK[32 - bits];
                ++expNum;
            }
            outputOffset += bits;
        }
        tmpCompBuffer[0] = (bits & MASK[5]) << 26 | expNum & MASK[26];
        if (expNum > 0) {
            int compressedBitSize = LCPForDelta.compressBlockByS16(tmpCompBuffer, outputOffset, expPosBuffer, expNum, blockSize, inputBlock);
            outputOffset += compressedBitSize;
            compressedBitSize = LCPForDelta.compressBlockByS16(tmpCompBuffer, outputOffset, expHighBitsBuffer, expNum, blockSize, inputBlock);
            outputOffset += compressedBitSize;
        }
        int compressedSizeInInts = outputOffset + 31 >>> 5;
        this.compBuffer = tmpCompBuffer;
        return compressedSizeInInts;
    }

    public int compressOneBlockCore2(int[] inputBlock, int blockSize, int bits) throws IllegalArgumentException {
        int outputOffset = 32;
        int expUpperBound = 1 << bits;
        int expNum = 0;
        int maxCompBitSize = 32 + blockSize * 96 + 32;
        int[] tmpCompBuffer = new int[maxCompBitSize >>> 5];
        int[] expPosBuffer = new int[blockSize];
        int[] expHighBitsBuffer = new int[blockSize];
        for (int i = 0; i < blockSize; ++i) {
            int value = inputBlock[i];
            if (value < expUpperBound) {
                LCPForDelta.writeBits(tmpCompBuffer, value, outputOffset, bits);
            } else {
                LCPForDelta.writeBits(tmpCompBuffer, value & MASK[bits], outputOffset, bits);
                expPosBuffer[expNum] = i;
                expHighBitsBuffer[expNum] = value >>> bits & MASK[32 - bits];
                ++expNum;
            }
            outputOffset += bits;
        }
        tmpCompBuffer[0] = (bits & MASK[5]) << 26 | expNum & MASK[26];
        if (expNum > 0) {
            int[] expBuffer = new int[expNum * 2];
            System.arraycopy(expPosBuffer, 0, expBuffer, 0, expNum);
            System.arraycopy(expHighBitsBuffer, 0, expBuffer, expNum, expNum);
            int compressedBitSize = LCPForDelta.compressBlockByS16(tmpCompBuffer, outputOffset, expBuffer, expNum * 2, blockSize, inputBlock);
            outputOffset += compressedBitSize;
        }
        int compressedSizeInInts = outputOffset + 31 >>> 5;
        this.compBuffer = tmpCompBuffer;
        return compressedSizeInInts;
    }

    public static void decompressOneBlock(int[] decompBlock, int[] inBlock, int blockSize) {
        int expNum = inBlock[0] & MASK[26];
        int bits = inBlock[0] >>> 26 & 0x1F;
        int[] expPosBuffer = new int[blockSize];
        int[] expHighBitsBuffer = new int[blockSize];
        int offset = 32;
        int compressedBits = 0;
        if (bits == 0) {
            Arrays.fill(decompBlock, 0);
        } else {
            compressedBits = LCPForDelta.decompressBBitSlots(decompBlock, inBlock, blockSize, bits);
        }
        offset += compressedBits;
        if (expNum > 0) {
            compressedBits = LCPForDelta.decompressBlockByS16(expPosBuffer, inBlock, offset, expNum);
            offset += compressedBits;
            compressedBits = LCPForDelta.decompressBlockByS16(expHighBitsBuffer, inBlock, offset, expNum);
            offset += compressedBits;
            for (int i = 0; i < expNum; ++i) {
                int curExpPos = expPosBuffer[i];
                int curHighBits = expHighBitsBuffer[i];
                decompBlock[curExpPos] = decompBlock[curExpPos] & MASK[bits] | (curHighBits & MASK[32 - bits]) << bits;
            }
        }
    }

    public static void decompressOneBlockWithSize(int[] decompBlock, int[] inBlock, int blockSize, int[] expPosBuffer, int[] expHighBitsBuffer, int inBlockLen) {
        int expNum = inBlock[0] & MASK[26];
        int bits = inBlock[0] >>> 26 & 0x1F;
        int offset = 32;
        int compressedBits = 0;
        if (bits == 0) {
            Arrays.fill(decompBlock, 0, inBlockLen, 0);
        } else {
            compressedBits = LCPForDelta.decompressBBitSlots(decompBlock, inBlock, blockSize, bits);
        }
        offset += compressedBits;
        if (expNum > 0) {
            compressedBits = LCPForDelta.decompressBlockByS16(expPosBuffer, inBlock, offset, expNum);
            offset += compressedBits;
            compressedBits = LCPForDelta.decompressBlockByS16(expHighBitsBuffer, inBlock, offset, expNum);
            offset += compressedBits;
            for (int i = 0; i < expNum; ++i) {
                int curExpPos = expPosBuffer[i];
                int curHighBits = expHighBitsBuffer[i];
                decompBlock[curExpPos] = decompBlock[curExpPos] & MASK[bits] | (curHighBits & MASK[32 - bits]) << bits;
            }
        }
    }

    public static void decompressOneBlockWithSizeWithIntBuffer(int[] decompBlock, IntBuffer inBlock, int blockSize, int[] expPosBuffer, int[] expHighBitsBuffer, int inBlockLen) {
        int flag = inBlock.get();
        int expNum = flag & MASK[26];
        int bits = flag >>> 26 & 0x1F;
        if (bits == 0) {
            Arrays.fill(decompBlock, 0, inBlockLen, 0);
        } else {
            PForDeltaUnpack128WIthIntBuffer.unpack(decompBlock, inBlock, bits);
        }
        if (expNum > 0) {
            int numLeft;
            int num;
            int outOffset = 0;
            for (numLeft = expNum; numLeft > 0; numLeft -= num) {
                num = Simple16WithHardCodes.s16DecompressWithIntBufferWithHardCodes(expPosBuffer, outOffset, inBlock.get(), numLeft);
                outOffset += num;
            }
            outOffset = 0;
            for (numLeft = expNum; numLeft > 0; numLeft -= num) {
                num = Simple16WithHardCodes.s16DecompressWithIntBufferIntegrated2(decompBlock, outOffset, inBlock.get(), numLeft, expPosBuffer, bits);
                outOffset += num;
            }
        }
    }

    public static int estimateCompressedSize(int[] inputBlock, int blockSize, int bits) throws IllegalArgumentException {
        int maxNoExp = (1 << bits) - 1;
        int outputOffset = 32 + bits * blockSize;
        int expNum = 0;
        for (int i = 0; i < blockSize; ++i) {
            if (inputBlock[i] <= maxNoExp) continue;
            ++expNum;
        }
        return outputOffset += expNum << 5;
    }

    public static boolean checkBigNumbers(int[] inputBlock, int blockSize, int bits) throws IllegalArgumentException {
        int maxNoExp = (1 << bits) - 1;
        for (int i = 0; i < blockSize; ++i) {
            if (inputBlock[i] <= maxNoExp) continue;
            return true;
        }
        return false;
    }

    public static int decompressBBitSlots(int[] outDecompSlots, int[] inCompBlock, int blockSize, int bits) {
        int compressedBitSize = 0;
        int offset = 32;
        for (int i = 0; i < blockSize; ++i) {
            outDecompSlots[i] = LCPForDelta.readBits(inCompBlock, offset, bits);
            offset += bits;
        }
        compressedBitSize = bits * blockSize;
        return compressedBitSize;
    }

    public static int decompressBBitSlotsWithHardCodes(int[] outDecompSlots, int[] inCompBlock, int blockSize, int bits) {
        int compressedBitSize = 0;
        PForDeltaUnpack128.unpack(outDecompSlots, inCompBlock, bits);
        compressedBitSize = bits * blockSize;
        return compressedBitSize;
    }

    public static int decompressBBitSlotsWithHardCodesWithIntBuffer(int[] outDecompSlots, IntBuffer inCompBlock, int blockSize, int bits) {
        PForDeltaUnpack128WIthIntBuffer.unpack(outDecompSlots, inCompBlock, bits);
        return bits * blockSize;
    }

    private static int compressBlockByS16(int[] outCompBlock, int outStartOffsetInBits, int[] inBlock, int blockSize, int oriBlockSize, int[] oriInputBlock) {
        int num;
        int outOffset = outStartOffsetInBits + 31 >>> 5;
        int inOffset = 0;
        for (int numLeft = blockSize; numLeft > 0; numLeft -= num) {
            num = Simple16WithHardCodes.s16Compress(outCompBlock, outOffset, inBlock, inOffset, numLeft, blockSize, oriBlockSize, oriInputBlock);
            ++outOffset;
            inOffset += num;
        }
        int compressedBitSize = (outOffset << 5) - outStartOffsetInBits;
        return compressedBitSize;
    }

    public static int decompressBlockByS16(int[] outDecompBlock, int[] inCompBlock, int inStartOffsetInBits, int blockSize) {
        int num;
        int inOffset = inStartOffsetInBits + 31 >>> 5;
        int outOffset = 0;
        for (int numLeft = blockSize; numLeft > 0; numLeft -= num) {
            num = Simple16.s16Decompress(outDecompBlock, outOffset, inCompBlock, inOffset, numLeft);
            outOffset += num;
            ++inOffset;
        }
        int compressedBitSize = (inOffset << 5) - inStartOffsetInBits;
        return compressedBitSize;
    }

    public static void decompressBlockByS16WithIntBuffer(int[] outDecompBlock, IntBuffer inCompBlock, int blockSize) {
        int num;
        int outOffset = 0;
        for (int numLeft = blockSize; numLeft > 0; numLeft -= num) {
            num = Simple16WithHardCodes.s16DecompressWithIntBuffer(outDecompBlock, outOffset, inCompBlock.get(), numLeft);
            outOffset += num;
        }
    }

    public static void decompressBlockByS16WithIntBufferIntegrated(int[] outDecompBlock, IntBuffer inCompBlock, int blockSize, int[] expPosBuffer, int oribits) {
        int num;
        int outOffset = 0;
        for (int numLeft = blockSize; numLeft > 0; numLeft -= num) {
            num = Simple16WithHardCodes.s16DecompressWithIntBufferIntegrated(outDecompBlock, outOffset, inCompBlock.get(), numLeft, expPosBuffer, oribits);
            outOffset += num;
        }
    }

    public static final void writeBits(int[] out, int val, int outOffset, int bits) {
        if (bits == 0) {
            return;
        }
        int index = outOffset >>> 5;
        int skip = outOffset & 0x1F;
        int n = index;
        out[n] = out[n] | (val &= -1 >>> 32 - bits) << skip;
        if (32 - skip < bits) {
            int n2 = index + 1;
            out[n2] = out[n2] | val >>> 32 - skip;
        }
    }

    public static final int readBits(int[] in, int inOffset, int bits) {
        int index = inOffset >>> 5;
        int skip = inOffset & 0x1F;
        int val = in[index] >>> skip;
        if (32 - skip < bits) {
            val |= in[index + 1] << 32 - skip;
        }
        return val & -1 >>> 32 - bits;
    }

    public static final int readBitsWithBuffer(int[] in, int inOffset, int bits) {
        int index = inOffset >>> 5;
        int skip = inOffset & 0x1F;
        int val = in[index] >>> skip;
        if (32 - skip < bits) {
            val |= in[index + 1] << 32 - skip;
        }
        return val & -1 >>> 32 - bits;
    }
}

