/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import me.lemire.integercompression.DeltaZigzagEncoding;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;

public final class DeltaZigzagVariableByte
implements IntegerCODEC {
    public String toString() {
        return DeltaZigzagVariableByte.class.getSimpleName();
    }

    public void compress(int[] inBuf, IntWrapper inPos, int inLen, int[] outBuf, IntWrapper outPos) {
        int ip;
        if (inLen == 0) {
            return;
        }
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(inLen * 5 + 3);
        DeltaZigzagEncoding.Encoder ctx = new DeltaZigzagEncoding.Encoder();
        int inPosLast = ip + inLen;
        for (ip = inPos.get(); ip < inPosLast; ++ip) {
            int n = ctx.encodeInt(inBuf[ip]);
            switch (Integer.numberOfLeadingZeros(n)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    byteBuf.put((byte)(n >>> 28 & 0x7F | 0x80));
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    byteBuf.put((byte)(n >>> 21 & 0x7F | 0x80));
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    byteBuf.put((byte)(n >>> 14 & 0x7F | 0x80));
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    byteBuf.put((byte)(n >>> 7 & 0x7F | 0x80));
                }
            }
            byteBuf.put((byte)(n & 0x7F));
        }
        for (int i = (4 - byteBuf.position() % 4) % 4; i > 0; --i) {
            byteBuf.put((byte)-128);
        }
        int outLen = byteBuf.position() / 4;
        byteBuf.flip();
        IntBuffer intBuf = byteBuf.asIntBuffer();
        intBuf.get(outBuf, outPos.get(), outLen);
        inPos.add(inLen);
        outPos.add(outLen);
    }

    public void uncompress(int[] inBuf, IntWrapper inPos, int inLen, int[] outBuf, IntWrapper outPos) {
        DeltaZigzagEncoding.Decoder ctx = new DeltaZigzagEncoding.Decoder();
        int ip = inPos.get();
        int op = outPos.get();
        int vbcNum = 0;
        int vbcShift = 24;
        int inPosLast = ip + inLen;
        while (ip < inPosLast) {
            int n = inBuf[ip] >>> vbcShift & 0xFF;
            if (vbcShift > 0) {
                vbcShift -= 8;
            } else {
                vbcShift = 24;
                ++ip;
            }
            vbcNum = (vbcNum << 7) + (n & 0x7F);
            if ((n & 0x80) != 0) continue;
            outBuf[op++] = ctx.decodeInt(vbcNum);
            vbcNum = 0;
        }
        outPos.set(op);
        inPos.set(inPosLast);
    }
}

