/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.benchmarktools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegratedBinaryPacking;
import me.lemire.integercompression.IntegratedByteIntegerCODEC;
import me.lemire.integercompression.IntegratedComposition;
import me.lemire.integercompression.IntegratedFastPFOR;
import me.lemire.integercompression.IntegratedIntegerCODEC;
import me.lemire.integercompression.IntegratedVariableByte;

public class BenchmarkCSV {
    static IntegratedIntegerCODEC[] codecs = new IntegratedIntegerCODEC[]{new IntegratedComposition(new IntegratedFastPFOR(), new IntegratedVariableByte()), new IntegratedComposition(new IntegratedBinaryPacking(), new IntegratedVariableByte()), new IntegratedVariableByte()};
    static IntegratedByteIntegerCODEC[] bcodecs = new IntegratedByteIntegerCODEC[]{new IntegratedVariableByte()};

    public static int[] loadIntegers(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String s = br.readLine();
        String[] numbers = s.split("[,;;]");
        int[] answer = new int[numbers.length];
        for (int k = 0; k < numbers.length; ++k) {
            answer[k] = Integer.parseInt(numbers[k].trim());
        }
        return answer;
    }

    public static void main(String[] args) throws IOException {
        int[][] data = new int[args.length][];
        for (int k = 0; k < args.length; ++k) {
            data[k] = BenchmarkCSV.loadIntegers(args[k]);
        }
        System.out.println("Loaded " + data.length + " arrays");
        BenchmarkCSV.bench(data, false);
        BenchmarkCSV.bench(data, false);
        BenchmarkCSV.bench(data, true);
        BenchmarkCSV.bytebench(data, false);
        BenchmarkCSV.bytebench(data, false);
        BenchmarkCSV.bytebench(data, true);
    }

    public static void bench(int[][] postings, boolean verbose) {
        int maxlength = 0;
        for (int[] x : postings) {
            if (maxlength >= x.length) continue;
            maxlength = x.length;
        }
        if (verbose) {
            System.out.println("Max array length: " + maxlength);
        }
        int[] compbuffer = new int[maxlength + 1024];
        int[] decompbuffer = new int[maxlength];
        if (verbose) {
            System.out.println("Scheme -- bits/int -- speed (mis)");
        }
        for (IntegratedIntegerCODEC c : codecs) {
            long bef = 0L;
            long aft = 0L;
            long decomptime = 0L;
            long volumein = 0L;
            long volumeout = 0L;
            int[][] compdata = new int[postings.length][];
            for (int k = 0; k < postings.length; ++k) {
                int[] in = postings[k];
                IntWrapper inpos = new IntWrapper(0);
                IntWrapper outpos = new IntWrapper(0);
                c.compress(in, inpos, in.length, compbuffer, outpos);
                int clength = outpos.get();
                inpos = new IntWrapper(0);
                outpos = new IntWrapper(0);
                c.uncompress(compbuffer, inpos, clength, decompbuffer, outpos);
                volumein += (long)in.length;
                volumeout += (long)clength;
                if (outpos.get() != in.length) {
                    throw new RuntimeException("bug");
                }
                for (int z = 0; z < in.length; ++z) {
                    if (in[z] == decompbuffer[z]) continue;
                    throw new RuntimeException("bug");
                }
                compdata[k] = Arrays.copyOf(compbuffer, clength);
            }
            bef = System.nanoTime();
            for (int[] cin : compdata) {
                IntWrapper inpos = new IntWrapper(0);
                IntWrapper outpos = new IntWrapper(0);
                c.uncompress(cin, inpos, cin.length, decompbuffer, outpos);
                if (inpos.get() == cin.length) continue;
                throw new RuntimeException("bug");
            }
            aft = System.nanoTime();
            double bitsPerInt = (double)volumeout * 32.0 / (double)volumein;
            double decompressSpeed = (double)volumein * 1000.0 / (double)(decomptime += aft - bef);
            if (!verbose) continue;
            System.out.println(c.toString() + "\t" + String.format("\t%1$.2f\t%2$.2f", bitsPerInt, decompressSpeed));
        }
    }

    public static void bytebench(int[][] postings, boolean verbose) {
        int maxlength = 0;
        for (int[] x : postings) {
            if (maxlength >= x.length) continue;
            maxlength = x.length;
        }
        if (verbose) {
            System.out.println("Max array length: " + maxlength);
        }
        byte[] compbuffer = new byte[4 * (maxlength + 1024)];
        int[] decompbuffer = new int[maxlength];
        if (verbose) {
            System.out.println("Scheme -- bits/int -- speed (mis)");
        }
        for (IntegratedByteIntegerCODEC c : bcodecs) {
            long bef = 0L;
            long aft = 0L;
            long decomptime = 0L;
            long volumein = 0L;
            long volumeout = 0L;
            byte[][] compdata = new byte[postings.length][];
            for (int k = 0; k < postings.length; ++k) {
                int[] in = postings[k];
                IntWrapper inpos = new IntWrapper(0);
                IntWrapper outpos = new IntWrapper(0);
                c.compress(in, inpos, in.length, compbuffer, outpos);
                int clength = outpos.get();
                inpos = new IntWrapper(0);
                outpos = new IntWrapper(0);
                c.uncompress(compbuffer, inpos, clength, decompbuffer, outpos);
                volumein += (long)in.length;
                volumeout += (long)clength;
                if (outpos.get() != in.length) {
                    throw new RuntimeException("bug");
                }
                for (int z = 0; z < in.length; ++z) {
                    if (in[z] == decompbuffer[z]) continue;
                    throw new RuntimeException("bug");
                }
                compdata[k] = Arrays.copyOf(compbuffer, clength);
            }
            bef = System.nanoTime();
            for (byte[] cin : compdata) {
                IntWrapper inpos = new IntWrapper(0);
                IntWrapper outpos = new IntWrapper(0);
                c.uncompress(cin, inpos, cin.length, decompbuffer, outpos);
                if (inpos.get() == cin.length) continue;
                throw new RuntimeException("bug");
            }
            aft = System.nanoTime();
            double bitsPerInt = (double)volumeout * 32.0 / (double)volumein;
            double decompressSpeed = (double)volumein * 1000.0 / (double)(decomptime += aft - bef);
            if (!verbose) continue;
            System.out.println(c.toString() + "\t" + String.format("\t%1$.2f\t%2$.2f", bitsPerInt, decompressSpeed));
        }
    }
}

