/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

public final class PerformanceLogger {
    public final Timer compressionTimer = new Timer();
    public final Timer decompressionTimer = new Timer();
    private long originalSize = 0L;
    private long compressedSize = 0L;

    public long addOriginalSize(long value) {
        return this.originalSize += value;
    }

    public long addCompressedSize(long value) {
        return this.compressedSize += value;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public double getBitPerInt() {
        return (double)this.compressedSize * 32.0 / (double)this.originalSize;
    }

    private static double getMiS(long size, long nanoTime) {
        return (double)size * 1.0E-6 / ((double)nanoTime * 1.0E-9);
    }

    public double getCompressSpeed() {
        return PerformanceLogger.getMiS(this.originalSize, this.compressionTimer.getDuration());
    }

    public double getDecompressSpeed() {
        return PerformanceLogger.getMiS(this.originalSize, this.decompressionTimer.getDuration());
    }

    public static class Timer {
        private long startNano;
        private long duration = 0L;

        public void start() {
            this.startNano = System.nanoTime();
        }

        public long end() {
            return this.duration += System.nanoTime() - this.startNano;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

