/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.benchmarktools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import me.lemire.integercompression.BinaryPacking;
import me.lemire.integercompression.ByteIntegerCODEC;
import me.lemire.integercompression.Composition;
import me.lemire.integercompression.FastPFOR;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.IntegratedBinaryPacking;
import me.lemire.integercompression.IntegratedByteIntegerCODEC;
import me.lemire.integercompression.IntegratedComposition;
import me.lemire.integercompression.IntegratedFastPFOR;
import me.lemire.integercompression.IntegratedIntegerCODEC;
import me.lemire.integercompression.IntegratedVariableByte;
import me.lemire.integercompression.VariableByte;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkCSV {
    static IntegratedIntegerCODEC[] codecs = new IntegratedIntegerCODEC[]{new IntegratedComposition(new IntegratedFastPFOR(), new IntegratedVariableByte()), new IntegratedComposition(new IntegratedBinaryPacking(), new IntegratedVariableByte())};
    static IntegratedByteIntegerCODEC[] bcodecs = new IntegratedByteIntegerCODEC[]{new IntegratedVariableByte()};
    static IntegerCODEC[] regcodecs = new IntegerCODEC[]{new Composition(new FastPFOR(), new VariableByte()), new Composition(new BinaryPacking(), new VariableByte())};
    static ByteIntegerCODEC[] regbcodecs = new ByteIntegerCODEC[]{new VariableByte()};

    public static ArrayList<int[]> loadIntegers(String filename, Format f) throws IOException {
        String s;
        int misparsed = 0;
        if (f == Format.ONEARRAYPERLINE) {
            String s2;
            ArrayList<int[]> answer = new ArrayList<int[]>();
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((s2 = br.readLine()) != null) {
                String[] numbers = s2.split("[,;;]");
                int[] a = new int[numbers.length];
                for (int k = 0; k < numbers.length; ++k) {
                    try {
                        a[k] = Integer.parseInt(numbers[k].trim());
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        if (misparsed == 0) {
                            System.err.println(nfe);
                        }
                        ++misparsed;
                    }
                }
                answer.add(a);
            }
            if (misparsed > 0) {
                System.out.println("Failed to parse " + misparsed + " entries");
            }
            return answer;
        }
        if (f == Format.ONEARRAYPERFILE) {
            String s3;
            ArrayList<Integer> answer = new ArrayList<Integer>();
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((s3 = br.readLine()) != null) {
                String[] numbers = s3.split("[,;;]");
                for (int k = 0; k < numbers.length; ++k) {
                    try {
                        answer.add(Integer.parseInt(numbers[k].trim()));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        if (misparsed == 0) {
                            System.err.println(nfe);
                        }
                        ++misparsed;
                    }
                }
            }
            int[] actualanswer = new int[answer.size()];
            for (int i = 0; i < answer.size(); ++i) {
                actualanswer[i] = (Integer)answer.get(i);
            }
            ArrayList<int[]> wrap = new ArrayList<int[]>();
            wrap.add(actualanswer);
            if (misparsed > 0) {
                System.out.println("Failed to parse " + misparsed + " entries");
            }
            return wrap;
        }
        ArrayList<Integer> answer = new ArrayList<Integer>();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((s = br.readLine()) != null) {
            try {
                answer.add(Integer.parseInt(s.trim()));
            }
            catch (NumberFormatException nfe) {
                if (misparsed == 0) {
                    System.err.println(nfe);
                }
                ++misparsed;
            }
        }
        int[] actualanswer = new int[answer.size()];
        for (int i = 0; i < answer.size(); ++i) {
            actualanswer[i] = (Integer)answer.get(i);
        }
        ArrayList<int[]> wrap = new ArrayList<int[]>();
        wrap.add(actualanswer);
        if (misparsed > 0) {
            System.out.println("Failed to parse " + misparsed + " entries");
        }
        return wrap;
    }

    public static void main(String[] args) throws IOException {
        Format myformat = Format.ONEARRAYPERLINE;
        CompressionMode cm = CompressionMode.DELTA;
        ArrayList<String> files = new ArrayList<String>();
        for (String s : args) {
            if (s.startsWith("-")) {
                if (s.equals("--onearrayperfile")) {
                    myformat = Format.ONEARRAYPERFILE;
                    continue;
                }
                if (s.equals("--nodelta")) {
                    cm = CompressionMode.AS_IS;
                    continue;
                }
                if (s.equals("--oneintperline")) {
                    myformat = Format.ONEINTPERLINE;
                    continue;
                }
                throw new RuntimeException("I don't understand: " + s);
            }
            files.add(s);
        }
        if (myformat == Format.ONEARRAYPERFILE) {
            System.out.println("Treating each file as one array.");
        } else if (myformat == Format.ONEARRAYPERLINE) {
            System.out.println("Each line of each file is an array: use --onearrayperfile or --oneintperline to change.");
        } else if (myformat == Format.ONEINTPERLINE) {
            System.out.println("Treating each file as one array, with one integer per line.");
        }
        if (cm == CompressionMode.AS_IS) {
            System.out.println("Compressing the integers 'as is' (no differential coding)");
        } else {
            System.out.println("Using differential coding (arrays will be sorted): use --nodelta to prevent sorting");
        }
        ArrayList<int[]> data = new ArrayList<int[]>();
        for (String fn : files) {
            for (int[] x : BenchmarkCSV.loadIntegers(fn, myformat)) {
                data.add(x);
            }
        }
        System.out.println("Loaded " + data.size() + " array(s)");
        if (cm == CompressionMode.DELTA) {
            System.out.println("Sorting the arrray(s) because you are using differential coding");
            for (int[] x : data) {
                Arrays.sort(x);
            }
        }
        BenchmarkCSV.bench(data, cm, false);
        BenchmarkCSV.bench(data, cm, false);
        BenchmarkCSV.bench(data, cm, true);
        BenchmarkCSV.bytebench(data, cm, false);
        BenchmarkCSV.bytebench(data, cm, false);
        BenchmarkCSV.bytebench(data, cm, true);
    }

    public static void bench(ArrayList<int[]> postings, CompressionMode cm, boolean verbose) {
        int maxlength = 0;
        for (int[] x : postings) {
            if (maxlength >= x.length) continue;
            maxlength = x.length;
        }
        if (verbose) {
            System.out.println("Max array length: " + maxlength);
        }
        int[] compbuffer = new int[2 * maxlength + 1024];
        int[] decompbuffer = new int[maxlength];
        if (verbose) {
            System.out.println("Scheme -- bits/int -- speed (mis)");
        }
        for (IntegerCODEC c : cm == CompressionMode.DELTA ? codecs : regcodecs) {
            long bef = 0L;
            long aft = 0L;
            long decomptime = 0L;
            long volumein = 0L;
            long volumeout = 0L;
            int[][] compdata = new int[postings.size()][];
            for (int k = 0; k < postings.size(); ++k) {
                int[] in = postings.get(k);
                IntWrapper inpos = new IntWrapper(0);
                IntWrapper outpos = new IntWrapper(0);
                c.compress(in, inpos, in.length, compbuffer, outpos);
                int clength = outpos.get();
                inpos = new IntWrapper(0);
                outpos = new IntWrapper(0);
                c.uncompress(compbuffer, inpos, clength, decompbuffer, outpos);
                volumein += (long)in.length;
                volumeout += (long)clength;
                if (outpos.get() != in.length) {
                    throw new RuntimeException("bug");
                }
                for (int z = 0; z < in.length; ++z) {
                    if (in[z] == decompbuffer[z]) continue;
                    throw new RuntimeException("bug");
                }
                compdata[k] = Arrays.copyOf(compbuffer, clength);
            }
            bef = System.nanoTime();
            for (int[] cin : compdata) {
                IntWrapper inpos = new IntWrapper(0);
                IntWrapper outpos = new IntWrapper(0);
                c.uncompress(cin, inpos, cin.length, decompbuffer, outpos);
                if (inpos.get() == cin.length) continue;
                throw new RuntimeException("bug");
            }
            aft = System.nanoTime();
            double bitsPerInt = (double)volumeout * 32.0 / (double)volumein;
            double decompressSpeed = (double)volumein * 1000.0 / (double)(decomptime += aft - bef);
            if (!verbose) continue;
            System.out.println(c.toString() + "\t" + String.format("\t%1$.2f\t%2$.2f", bitsPerInt, decompressSpeed));
        }
    }

    public static void bytebench(ArrayList<int[]> postings, CompressionMode cm, boolean verbose) {
        int maxlength = 0;
        for (int[] x : postings) {
            if (maxlength >= x.length) continue;
            maxlength = x.length;
        }
        if (verbose) {
            System.out.println("Max array length: " + maxlength);
        }
        byte[] compbuffer = new byte[6 * (maxlength + 1024)];
        int[] decompbuffer = new int[maxlength];
        if (verbose) {
            System.out.println("Scheme -- bits/int -- speed (mis)");
        }
        for (ByteIntegerCODEC c : cm == CompressionMode.DELTA ? bcodecs : regbcodecs) {
            long bef = 0L;
            long aft = 0L;
            long decomptime = 0L;
            long volumein = 0L;
            long volumeout = 0L;
            byte[][] compdata = new byte[postings.size()][];
            for (int k = 0; k < postings.size(); ++k) {
                int[] in = postings.get(k);
                IntWrapper inpos = new IntWrapper(0);
                IntWrapper outpos = new IntWrapper(0);
                c.compress(in, inpos, in.length, compbuffer, outpos);
                int clength = outpos.get();
                inpos = new IntWrapper(0);
                outpos = new IntWrapper(0);
                c.uncompress(compbuffer, inpos, clength, decompbuffer, outpos);
                volumein += (long)in.length;
                volumeout += (long)clength;
                if (outpos.get() != in.length) {
                    throw new RuntimeException("bug");
                }
                for (int z = 0; z < in.length; ++z) {
                    if (in[z] == decompbuffer[z]) continue;
                    throw new RuntimeException("bug");
                }
                compdata[k] = Arrays.copyOf(compbuffer, clength);
            }
            bef = System.nanoTime();
            for (byte[] cin : compdata) {
                IntWrapper inpos = new IntWrapper(0);
                IntWrapper outpos = new IntWrapper(0);
                c.uncompress(cin, inpos, cin.length, decompbuffer, outpos);
                if (inpos.get() == cin.length) continue;
                throw new RuntimeException("bug");
            }
            aft = System.nanoTime();
            double bitsPerInt = (double)volumeout * 8.0 / (double)volumein;
            double decompressSpeed = (double)volumein * 1000.0 / (double)(decomptime += aft - bef);
            if (!verbose) continue;
            System.out.println(c.toString() + "\t" + String.format("\t%1$.2f\t%2$.2f", bitsPerInt, decompressSpeed));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionMode {
        AS_IS,
        DELTA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        ONEARRAYPERLINE,
        ONEARRAYPERFILE,
        ONEINTPERLINE;

    }
}

