/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.SkippableIntegerCODEC;

public final class Simple9
implements IntegerCODEC,
SkippableIntegerCODEC {
    private static final int[] bitLength = new int[]{1, 2, 3, 4, 5, 7, 9, 14, 28};
    private static final int[] codeNum = new int[]{28, 14, 9, 7, 5, 4, 3, 2, 1};

    @Override
    public void headlessCompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int i;
        int max;
        int b;
        int compressedNum;
        int res;
        int selector;
        int tmpoutpos = outpos.get();
        int currentPos = inpos.get();
        int finalin = currentPos + inlength;
        block0: while (currentPos < finalin - 28) {
            block1: for (selector = 0; selector < 8; ++selector) {
                res = 0;
                compressedNum = codeNum[selector];
                b = bitLength[selector];
                max = 1 << b;
                for (i = 0; i < compressedNum; ++i) {
                    if (max <= in[currentPos + i]) continue block1;
                    res = (res << b) + in[currentPos + i];
                }
                out[tmpoutpos++] = res |= selector << 28;
                currentPos += compressedNum;
                continue block0;
            }
            selector = 8;
            if (in[currentPos] >= 1 << bitLength[8]) {
                throw new RuntimeException("Too big a number");
            }
            out[tmpoutpos++] = in[currentPos++] | Integer.MIN_VALUE;
        }
        block3: while (currentPos < finalin) {
            block4: for (selector = 0; selector < 8; ++selector) {
                res = 0;
                compressedNum = codeNum[selector];
                if (finalin <= currentPos + compressedNum - 1) {
                    compressedNum = finalin - currentPos;
                }
                b = bitLength[selector];
                max = 1 << b;
                for (i = 0; i < compressedNum; ++i) {
                    if (max <= in[currentPos + i]) continue block4;
                    res = (res << b) + in[currentPos + i];
                }
                if (compressedNum != codeNum[selector]) {
                    res <<= (codeNum[selector] - compressedNum) * b;
                }
                out[tmpoutpos++] = res |= selector << 28;
                currentPos += compressedNum;
                continue block3;
            }
            selector = 8;
            if (in[currentPos] >= 1 << bitLength[8]) {
                throw new RuntimeException("Too big a number");
            }
            out[tmpoutpos++] = in[currentPos++] | Integer.MIN_VALUE;
        }
        inpos.set(currentPos);
        outpos.set(tmpoutpos);
    }

    @Override
    public void headlessUncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, int outlength) {
        int header;
        int val;
        int currentPos = outpos.get();
        int tmpinpos = inpos.get();
        int finalout = currentPos + outlength;
        block22: while (currentPos < finalout - 28) {
            val = in[tmpinpos++];
            header = val >>> 28;
            switch (header) {
                case 0: {
                    out[currentPos++] = val << 4 >>> 31;
                    out[currentPos++] = val << 5 >>> 31;
                    out[currentPos++] = val << 6 >>> 31;
                    out[currentPos++] = val << 7 >>> 31;
                    out[currentPos++] = val << 8 >>> 31;
                    out[currentPos++] = val << 9 >>> 31;
                    out[currentPos++] = val << 10 >>> 31;
                    out[currentPos++] = val << 11 >>> 31;
                    out[currentPos++] = val << 12 >>> 31;
                    out[currentPos++] = val << 13 >>> 31;
                    out[currentPos++] = val << 14 >>> 31;
                    out[currentPos++] = val << 15 >>> 31;
                    out[currentPos++] = val << 16 >>> 31;
                    out[currentPos++] = val << 17 >>> 31;
                    out[currentPos++] = val << 18 >>> 31;
                    out[currentPos++] = val << 19 >>> 31;
                    out[currentPos++] = val << 20 >>> 31;
                    out[currentPos++] = val << 21 >>> 31;
                    out[currentPos++] = val << 22 >>> 31;
                    out[currentPos++] = val << 23 >>> 31;
                    out[currentPos++] = val << 24 >>> 31;
                    out[currentPos++] = val << 25 >>> 31;
                    out[currentPos++] = val << 26 >>> 31;
                    out[currentPos++] = val << 27 >>> 31;
                    out[currentPos++] = val << 28 >>> 31;
                    out[currentPos++] = val << 29 >>> 31;
                    out[currentPos++] = val << 30 >>> 31;
                    out[currentPos++] = val << 31 >>> 31;
                    continue block22;
                }
                case 1: {
                    out[currentPos++] = val << 4 >>> 30;
                    out[currentPos++] = val << 6 >>> 30;
                    out[currentPos++] = val << 8 >>> 30;
                    out[currentPos++] = val << 10 >>> 30;
                    out[currentPos++] = val << 12 >>> 30;
                    out[currentPos++] = val << 14 >>> 30;
                    out[currentPos++] = val << 16 >>> 30;
                    out[currentPos++] = val << 18 >>> 30;
                    out[currentPos++] = val << 20 >>> 30;
                    out[currentPos++] = val << 22 >>> 30;
                    out[currentPos++] = val << 24 >>> 30;
                    out[currentPos++] = val << 26 >>> 30;
                    out[currentPos++] = val << 28 >>> 30;
                    out[currentPos++] = val << 30 >>> 30;
                    continue block22;
                }
                case 2: {
                    out[currentPos++] = val << 5 >>> 29;
                    out[currentPos++] = val << 8 >>> 29;
                    out[currentPos++] = val << 11 >>> 29;
                    out[currentPos++] = val << 14 >>> 29;
                    out[currentPos++] = val << 17 >>> 29;
                    out[currentPos++] = val << 20 >>> 29;
                    out[currentPos++] = val << 23 >>> 29;
                    out[currentPos++] = val << 26 >>> 29;
                    out[currentPos++] = val << 29 >>> 29;
                    continue block22;
                }
                case 3: {
                    out[currentPos++] = val << 4 >>> 28;
                    out[currentPos++] = val << 8 >>> 28;
                    out[currentPos++] = val << 12 >>> 28;
                    out[currentPos++] = val << 16 >>> 28;
                    out[currentPos++] = val << 20 >>> 28;
                    out[currentPos++] = val << 24 >>> 28;
                    out[currentPos++] = val << 28 >>> 28;
                    continue block22;
                }
                case 4: {
                    out[currentPos++] = val << 7 >>> 27;
                    out[currentPos++] = val << 12 >>> 27;
                    out[currentPos++] = val << 17 >>> 27;
                    out[currentPos++] = val << 22 >>> 27;
                    out[currentPos++] = val << 27 >>> 27;
                    continue block22;
                }
                case 5: {
                    out[currentPos++] = val << 4 >>> 25;
                    out[currentPos++] = val << 11 >>> 25;
                    out[currentPos++] = val << 18 >>> 25;
                    out[currentPos++] = val << 25 >>> 25;
                    continue block22;
                }
                case 6: {
                    out[currentPos++] = val << 5 >>> 23;
                    out[currentPos++] = val << 14 >>> 23;
                    out[currentPos++] = val << 23 >>> 23;
                    continue block22;
                }
                case 7: {
                    out[currentPos++] = val << 4 >>> 18;
                    out[currentPos++] = val << 18 >>> 18;
                    continue block22;
                }
                case 8: {
                    out[currentPos++] = val << 4 >>> 4;
                    continue block22;
                }
            }
            throw new RuntimeException("shouldn't happen: limited to 28-bit integers");
        }
        block23: while (currentPos < finalout) {
            val = in[tmpinpos++];
            header = val >>> 28;
            switch (header) {
                case 0: {
                    int k;
                    int howmany = finalout - currentPos;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << k + 4 >>> 31;
                    }
                    continue block23;
                }
                case 1: {
                    int k;
                    int howmany = finalout - currentPos < 14 ? finalout - currentPos : 14;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 2 * k + 4 >>> 30;
                    }
                    continue block23;
                }
                case 2: {
                    int k;
                    int howmany = finalout - currentPos < 9 ? finalout - currentPos : 9;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 3 * k + 5 >>> 29;
                    }
                    continue block23;
                }
                case 3: {
                    int k;
                    int howmany = finalout - currentPos < 7 ? finalout - currentPos : 7;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 4 * k + 4 >>> 28;
                    }
                    continue block23;
                }
                case 4: {
                    int k;
                    int howmany = finalout - currentPos < 5 ? finalout - currentPos : 5;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 5 * k + 7 >>> 27;
                    }
                    continue block23;
                }
                case 5: {
                    int k;
                    int howmany = finalout - currentPos < 4 ? finalout - currentPos : 4;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 7 * k + 4 >>> 25;
                    }
                    continue block23;
                }
                case 6: {
                    int k;
                    int howmany = finalout - currentPos < 3 ? finalout - currentPos : 3;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 9 * k + 5 >>> 23;
                    }
                    continue block23;
                }
                case 7: {
                    int k;
                    int howmany = finalout - currentPos < 2 ? finalout - currentPos : 2;
                    for (k = 0; k < howmany; ++k) {
                        out[currentPos++] = val << 14 * k + 4 >>> 18;
                    }
                    continue block23;
                }
                case 8: {
                    out[currentPos++] = val << 4 >>> 4;
                    break;
                }
                default: {
                    throw new RuntimeException("shouldn't happen");
                }
            }
        }
        outpos.set(currentPos);
        inpos.set(tmpinpos);
    }

    @Override
    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        out[outpos.get()] = inlength;
        outpos.increment();
        this.headlessCompress(in, inpos, inlength, out, outpos);
    }

    @Override
    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outlength = in[inpos.get()];
        inpos.increment();
        this.headlessUncompress(in, inpos, inlength, out, outpos, outlength);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

