/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import com.kamikaze.pfordelta.PForDelta;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.SkippableIntegerCODEC;
import me.lemire.integercompression.Util;

public class Kamikaze
implements SkippableIntegerCODEC,
IntegerCODEC {
    private int BLOCK_SIZE = 128;

    @Override
    public void headlessCompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if ((inlength = Util.greatestMultiple(inlength, this.BLOCK_SIZE)) > 0) {
            int[] out2 = PForDelta.compressOneBlockOpt(in, inlength);
            inpos.add(inlength);
            System.arraycopy(out2, 0, out, outpos.get(), out2.length);
            outpos.add(out2.length);
        }
    }

    @Override
    public void headlessUncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, int num) {
        if ((num = Util.greatestMultiple(num, this.BLOCK_SIZE)) > 0) {
            int d = PForDelta.decompressOneBlock(out, in, num);
            inpos.add(d / 32);
            outpos.add(num);
        }
    }

    public String toString() {
        return "Kamikaze's PForDelta";
    }

    @Override
    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if ((inlength = Util.greatestMultiple(inlength, this.BLOCK_SIZE)) == 0) {
            return;
        }
        out[outpos.get()] = inlength;
        outpos.increment();
        this.headlessCompress(in, inpos, inlength, out, outpos);
    }

    @Override
    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outlength = in[inpos.get()];
        inpos.increment();
        this.headlessUncompress(in, inpos, inlength, out, outpos, outlength);
    }
}

