/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import me.lemire.integercompression.ByteIntegerCODEC;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.SkippableIntegerCODEC;

public class VariableByte
implements IntegerCODEC,
ByteIntegerCODEC,
SkippableIntegerCODEC {
    private static byte extract7bits(int i, long val) {
        return (byte)(val >> 7 * i & 0x7FL);
    }

    private static byte extract7bitsmaskless(int i, long val) {
        return (byte)(val >> 7 * i);
    }

    @Override
    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        this.headlessCompress(in, inpos, inlength, out, outpos);
    }

    @Override
    public void headlessCompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        ByteBuffer buf = ByteBuffer.allocateDirect(inlength * 8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = (long)in[k] & 0xFFFFFFFFL;
            if (val < 128L) {
                buf.put((byte)(val | 0x80L));
                continue;
            }
            if (val < 16384L) {
                buf.put(VariableByte.extract7bits(0, val));
                buf.put((byte)(VariableByte.extract7bitsmaskless(1, val) | 0x80));
                continue;
            }
            if (val < 0x200000L) {
                buf.put(VariableByte.extract7bits(0, val));
                buf.put(VariableByte.extract7bits(1, val));
                buf.put((byte)(VariableByte.extract7bitsmaskless(2, val) | 0x80));
                continue;
            }
            if (val < 0x10000000L) {
                buf.put(VariableByte.extract7bits(0, val));
                buf.put(VariableByte.extract7bits(1, val));
                buf.put(VariableByte.extract7bits(2, val));
                buf.put((byte)(VariableByte.extract7bitsmaskless(3, val) | 0x80));
                continue;
            }
            buf.put(VariableByte.extract7bits(0, val));
            buf.put(VariableByte.extract7bits(1, val));
            buf.put(VariableByte.extract7bits(2, val));
            buf.put(VariableByte.extract7bits(3, val));
            buf.put((byte)(VariableByte.extract7bitsmaskless(4, val) | 0x80));
        }
        while (buf.position() % 4 != 0) {
            buf.put((byte)0);
        }
        int length = buf.position();
        buf.flip();
        IntBuffer ibuf = buf.asIntBuffer();
        ibuf.get(out, outpos.get(), length / 4);
        outpos.add(length / 4);
        inpos.add(inlength);
    }

    @Override
    public void compress(int[] in, IntWrapper inpos, int inlength, byte[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outpostmp = outpos.get();
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = (long)in[k] & 0xFFFFFFFFL;
            if (val < 128L) {
                out[outpostmp++] = (byte)(val | 0x80L);
                continue;
            }
            if (val < 16384L) {
                out[outpostmp++] = VariableByte.extract7bits(0, val);
                out[outpostmp++] = (byte)(VariableByte.extract7bitsmaskless(1, val) | 0x80);
                continue;
            }
            if (val < 0x200000L) {
                out[outpostmp++] = VariableByte.extract7bits(0, val);
                out[outpostmp++] = VariableByte.extract7bits(1, val);
                out[outpostmp++] = (byte)(VariableByte.extract7bitsmaskless(2, val) | 0x80);
                continue;
            }
            if (val < 0x10000000L) {
                out[outpostmp++] = VariableByte.extract7bits(0, val);
                out[outpostmp++] = VariableByte.extract7bits(1, val);
                out[outpostmp++] = VariableByte.extract7bits(2, val);
                out[outpostmp++] = (byte)(VariableByte.extract7bitsmaskless(3, val) | 0x80);
                continue;
            }
            out[outpostmp++] = VariableByte.extract7bits(0, val);
            out[outpostmp++] = VariableByte.extract7bits(1, val);
            out[outpostmp++] = VariableByte.extract7bits(2, val);
            out[outpostmp++] = VariableByte.extract7bits(3, val);
            out[outpostmp++] = (byte)(VariableByte.extract7bitsmaskless(4, val) | 0x80);
        }
        outpos.set(outpostmp);
        inpos.add(inlength);
    }

    @Override
    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int s = 0;
        int val = 0;
        int p = inpos.get();
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        int v = 0;
        int shift = 0;
        while (p < finalp) {
            val = in[p];
            byte c = (byte)(val >>> s);
            p += (s += 8) >> 5;
            s &= 0x1F;
            v += (c & 0x7F) << shift;
            if ((c & 0x80) == 128) {
                out[tmpoutpos++] = v;
                v = 0;
                shift = 0;
                continue;
            }
            shift += 7;
        }
        outpos.set(tmpoutpos);
        inpos.add(inlength);
    }

    @Override
    public void uncompress(byte[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int p = inpos.get();
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        int v = 0;
        while (p < finalp) {
            v = in[p] & 0x7F;
            if (in[p] < 0) {
                ++p;
            } else {
                v = (in[p + 1] & 0x7F) << 7 | v;
                if (in[p + 1] < 0) {
                    p += 2;
                } else {
                    v = (in[p + 2] & 0x7F) << 14 | v;
                    if (in[p + 2] < 0) {
                        p += 3;
                    } else {
                        v = (in[p + 3] & 0x7F) << 21 | v;
                        if (in[p + 3] < 0) {
                            p += 4;
                        } else {
                            v = (in[p + 4] & 0x7F) << 28 | v;
                            p += 5;
                        }
                    }
                }
            }
            out[tmpoutpos++] = v;
        }
        outpos.set(tmpoutpos);
        inpos.add(p);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void headlessUncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, int num) {
        int s = 0;
        int val = 0;
        int p = inpos.get();
        int tmpoutpos = outpos.get();
        int finaloutpos = num + tmpoutpos;
        int v = 0;
        int shift = 0;
        while (tmpoutpos < finaloutpos) {
            val = in[p];
            int c = val >>> s;
            p += (s += 8) >> 5;
            s &= 0x1F;
            v += (c & 0x7F) << shift;
            if ((c & 0x80) == 128) {
                out[tmpoutpos++] = v;
                v = 0;
                shift = 0;
                continue;
            }
            shift += 7;
        }
        outpos.set(tmpoutpos);
        inpos.set(p + (s != 0 ? 1 : 0));
    }
}

