/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import java.util.Arrays;
import me.lemire.integercompression.BinaryPacking;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.SkippableComposition;
import me.lemire.integercompression.SkippableIntegerCODEC;
import me.lemire.integercompression.UncompressibleInputException;
import me.lemire.integercompression.VariableByte;

public class IntCompressor {
    SkippableIntegerCODEC codec;

    public IntCompressor(SkippableIntegerCODEC c) {
        this.codec = c;
    }

    public IntCompressor() {
        this.codec = new SkippableComposition(new BinaryPacking(), new VariableByte());
    }

    public int[] compress(int[] input) {
        int[] compressed = new int[input.length + input.length / 100 + 1024];
        compressed[0] = input.length;
        IntWrapper outpos = new IntWrapper(1);
        try {
            this.codec.headlessCompress(input, new IntWrapper(0), input.length, compressed, outpos);
        }
        catch (IndexOutOfBoundsException ioebe) {
            throw new UncompressibleInputException("Your input is too poorly compressible with the current codec : " + String.valueOf(this.codec));
        }
        compressed = Arrays.copyOf(compressed, outpos.intValue());
        return compressed;
    }

    public int[] uncompress(int[] compressed) {
        int[] decompressed = new int[compressed[0]];
        IntWrapper inpos = new IntWrapper(1);
        this.codec.headlessUncompress(compressed, inpos, compressed.length - inpos.intValue(), decompressed, new IntWrapper(0), decompressed.length);
        return decompressed;
    }
}

