/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.differential;

import java.util.Arrays;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.UncompressibleInputException;
import me.lemire.integercompression.differential.IntegratedBinaryPacking;
import me.lemire.integercompression.differential.IntegratedVariableByte;
import me.lemire.integercompression.differential.SkippableIntegratedComposition;
import me.lemire.integercompression.differential.SkippableIntegratedIntegerCODEC;

public class IntegratedIntCompressor {
    SkippableIntegratedIntegerCODEC codec;

    public IntegratedIntCompressor(SkippableIntegratedIntegerCODEC c) {
        this.codec = c;
    }

    public IntegratedIntCompressor() {
        this.codec = new SkippableIntegratedComposition(new IntegratedBinaryPacking(), new IntegratedVariableByte());
    }

    public int[] compress(int[] input) {
        int[] compressed = new int[input.length + input.length / 100 + 1024];
        compressed[0] = input.length;
        IntWrapper outpos = new IntWrapper(1);
        IntWrapper initvalue = new IntWrapper(0);
        try {
            this.codec.headlessCompress(input, new IntWrapper(0), input.length, compressed, outpos, initvalue);
        }
        catch (IndexOutOfBoundsException ioebe) {
            throw new UncompressibleInputException("Your input is too poorly compressible with the current codec : " + String.valueOf(this.codec));
        }
        compressed = Arrays.copyOf(compressed, outpos.intValue());
        return compressed;
    }

    public int[] uncompress(int[] compressed) {
        int[] decompressed = new int[compressed[0]];
        IntWrapper inpos = new IntWrapper(1);
        this.codec.headlessUncompress(compressed, inpos, compressed.length - inpos.intValue(), decompressed, new IntWrapper(0), decompressed.length, new IntWrapper(0));
        return decompressed;
    }
}

