/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.longcompression;

import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.Util;
import me.lemire.longcompression.LongBitPacking;
import me.lemire.longcompression.LongCODEC;
import me.lemire.longcompression.LongUtil;
import me.lemire.longcompression.SkippableLongCODEC;

public final class LongBinaryPacking
implements LongCODEC,
SkippableLongCODEC {
    static final int BLOCK_SIZE = 64;

    @Override
    public void compress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        if ((inlength = Util.greatestMultiple(inlength, 64)) == 0) {
            return;
        }
        out[outpos.get()] = inlength;
        outpos.increment();
        this.headlessCompress(in, inpos, inlength, out, outpos);
    }

    @Override
    public void headlessCompress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        inlength = Util.greatestMultiple(inlength, 64);
        int tmpoutpos = outpos.get();
        int s = inpos.get();
        while (s + 512 - 1 < inpos.get() + inlength) {
            int mbits1 = LongUtil.maxbits(in, s + 0, 64);
            int mbits2 = LongUtil.maxbits(in, s + 64, 64);
            int mbits3 = LongUtil.maxbits(in, s + 128, 64);
            int mbits4 = LongUtil.maxbits(in, s + 192, 64);
            int mbits5 = LongUtil.maxbits(in, s + 256, 64);
            int mbits6 = LongUtil.maxbits(in, s + 320, 64);
            int mbits7 = LongUtil.maxbits(in, s + 384, 64);
            int mbits8 = LongUtil.maxbits(in, s + 448, 64);
            out[tmpoutpos++] = (long)mbits1 << 56 | (long)mbits2 << 48 | (long)mbits3 << 40 | (long)mbits4 << 32 | (long)(mbits5 << 24) | (long)(mbits6 << 16) | (long)(mbits7 << 8) | (long)mbits8;
            LongBitPacking.fastpackwithoutmask(in, s + 0, out, tmpoutpos, mbits1);
            LongBitPacking.fastpackwithoutmask(in, s + 64, out, tmpoutpos += mbits1, mbits2);
            LongBitPacking.fastpackwithoutmask(in, s + 128, out, tmpoutpos += mbits2, mbits3);
            LongBitPacking.fastpackwithoutmask(in, s + 192, out, tmpoutpos += mbits3, mbits4);
            LongBitPacking.fastpackwithoutmask(in, s + 256, out, tmpoutpos += mbits4, mbits5);
            LongBitPacking.fastpackwithoutmask(in, s + 320, out, tmpoutpos += mbits5, mbits6);
            LongBitPacking.fastpackwithoutmask(in, s + 384, out, tmpoutpos += mbits6, mbits7);
            LongBitPacking.fastpackwithoutmask(in, s + 448, out, tmpoutpos += mbits7, mbits8);
            tmpoutpos += mbits8;
            s += 512;
        }
        while (s < inpos.get() + inlength) {
            int mbits = LongUtil.maxbits(in, s, 64);
            out[tmpoutpos++] = mbits;
            LongBitPacking.fastpackwithoutmask(in, s, out, tmpoutpos, mbits);
            tmpoutpos += mbits;
            s += 64;
        }
        inpos.add(inlength);
        outpos.set(tmpoutpos);
    }

    @Override
    public void uncompress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outlength = (int)in[inpos.get()];
        inpos.increment();
        this.headlessUncompress(in, inpos, inlength, out, outpos, outlength);
    }

    @Override
    public void headlessUncompress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos, int num) {
        int outlength = Util.greatestMultiple(num, 64);
        int tmpinpos = inpos.get();
        int s = outpos.get();
        while (s + 512 - 1 < outpos.get() + outlength) {
            int mbits1 = (int)(in[tmpinpos] >>> 56);
            int mbits2 = (int)(in[tmpinpos] >>> 48 & 0xFFL);
            int mbits3 = (int)(in[tmpinpos] >>> 40 & 0xFFL);
            int mbits4 = (int)(in[tmpinpos] >>> 32 & 0xFFL);
            int mbits5 = (int)(in[tmpinpos] >>> 24 & 0xFFL);
            int mbits6 = (int)(in[tmpinpos] >>> 16 & 0xFFL);
            int mbits7 = (int)(in[tmpinpos] >>> 8 & 0xFFL);
            int mbits8 = (int)(in[tmpinpos] & 0xFFL);
            LongBitPacking.fastunpack(in, ++tmpinpos, out, s + 0, mbits1);
            LongBitPacking.fastunpack(in, tmpinpos += mbits1, out, s + 64, mbits2);
            LongBitPacking.fastunpack(in, tmpinpos += mbits2, out, s + 128, mbits3);
            LongBitPacking.fastunpack(in, tmpinpos += mbits3, out, s + 192, mbits4);
            LongBitPacking.fastunpack(in, tmpinpos += mbits4, out, s + 256, mbits5);
            LongBitPacking.fastunpack(in, tmpinpos += mbits5, out, s + 320, mbits6);
            LongBitPacking.fastunpack(in, tmpinpos += mbits6, out, s + 384, mbits7);
            LongBitPacking.fastunpack(in, tmpinpos += mbits7, out, s + 448, mbits8);
            tmpinpos += mbits8;
            s += 512;
        }
        while (s < outpos.get() + outlength) {
            int mbits = (int)in[tmpinpos];
            LongBitPacking.fastunpack(in, ++tmpinpos, out, s, mbits);
            tmpinpos += mbits;
            s += 64;
        }
        outpos.add(outlength);
        inpos.set(tmpinpos);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

