/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.longcompression;

import java.util.Arrays;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.UncompressibleInputException;
import me.lemire.longcompression.LongBinaryPacking;
import me.lemire.longcompression.LongVariableByte;
import me.lemire.longcompression.SkippableLongCODEC;
import me.lemire.longcompression.SkippableLongComposition;

public class LongCompressor {
    SkippableLongCODEC codec;

    public LongCompressor(SkippableLongCODEC c) {
        this.codec = c;
    }

    public LongCompressor() {
        this.codec = new SkippableLongComposition(new LongBinaryPacking(), new LongVariableByte());
    }

    public long[] compress(long[] input) {
        long[] compressed = new long[input.length + input.length / 100 + 1024];
        compressed[0] = input.length;
        IntWrapper outpos = new IntWrapper(1);
        try {
            this.codec.headlessCompress(input, new IntWrapper(0), input.length, compressed, outpos);
        }
        catch (IndexOutOfBoundsException ioebe) {
            throw new UncompressibleInputException("Your input is too poorly compressible with the current codec : " + String.valueOf(this.codec));
        }
        compressed = Arrays.copyOf(compressed, outpos.intValue());
        return compressed;
    }

    public long[] uncompress(long[] compressed) {
        long[] decompressed = new long[(int)compressed[0]];
        IntWrapper inpos = new IntWrapper(1);
        this.codec.headlessUncompress(compressed, inpos, compressed.length - inpos.intValue(), decompressed, new IntWrapper(0), decompressed.length);
        return decompressed;
    }
}

