/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.longcompression;

import java.util.Arrays;

public final class LongBitPacking {
    public static void fastpackwithoutmask(long[] in, int inpos, long[] out, int outpos, int bit) {
        if (bit == 0) {
            LongBitPacking.fastpackwithoutmask0(in, inpos, out, outpos);
        } else if (bit == 64) {
            LongBitPacking.fastpackwithoutmask64(in, inpos, out, outpos);
        } else if (bit > 0 && bit < 64) {
            LongBitPacking.slowpackwithoutmask(in, inpos, out, outpos, bit);
        } else {
            throw new IllegalArgumentException("Unsupported bit width: " + bit);
        }
    }

    protected static void fastpackwithoutmask0(long[] in, int inpos, long[] out, int outpos) {
    }

    protected static void fastpackwithoutmask64(long[] in, int inpos, long[] out, int outpos) {
        System.arraycopy(in, inpos, out, outpos, 64);
    }

    protected static void slowpackwithoutmask(long[] in, int inpos, long[] out, int outpos, int bit) {
        int bucket = 0;
        int shift = 0;
        out[outpos + bucket] = 0L;
        for (int i = 0; i < 64; ++i) {
            if (shift >= 64) {
                out[++bucket + outpos] = 0L;
                if ((shift -= 64) > 0) {
                    int n = outpos + bucket;
                    out[n] = out[n] | in[inpos + i - 1] >> bit - shift;
                }
            }
            int n = outpos + bucket;
            out[n] = out[n] | in[inpos + i] << shift;
            shift += bit;
        }
    }

    public static void fastunpack(long[] in, int inpos, long[] out, int outpos, int bit) {
        if (bit == 0) {
            LongBitPacking.fastunpack0(in, inpos, out, outpos);
        } else if (bit == 64) {
            LongBitPacking.fastunpack64(in, inpos, out, outpos);
        } else if (bit > 0 && bit < 64) {
            LongBitPacking.slowunpack(in, inpos, out, outpos, bit);
        } else {
            throw new IllegalArgumentException("Unsupported bit width: " + bit);
        }
    }

    protected static void fastunpack0(long[] in, int inpos, long[] out, int outpos) {
        Arrays.fill(out, outpos, outpos + 64, 0L);
    }

    protected static void fastunpack64(long[] in, int inpos, long[] out, int outpos) {
        System.arraycopy(in, inpos, out, outpos, 64);
    }

    protected static void slowunpack(long[] in, int inpos, long[] out, int outpos, int bit) {
        int bucket = 0;
        int shift = 0;
        for (int i = 0; i < 64; ++i) {
            if (shift >= 64) {
                ++bucket;
                if ((shift -= 64) > 0) {
                    int n = outpos + i - 1;
                    out[n] = out[n] | in[inpos + bucket] << bit - shift & (1L << bit) - 1L;
                }
            }
            out[outpos + i] = in[inpos + bucket] >>> shift & (1L << bit) - 1L;
            shift += bit;
        }
    }
}

