/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.longcompression.differential;

public final class LongDelta {
    public static void delta(long[] data) {
        for (int i = data.length - 1; i > 0; --i) {
            int n = i;
            data[n] = data[n] - data[i - 1];
        }
    }

    public static long delta(long[] data, int start, int length, int init) {
        long nextinit = data[start + length - 1];
        for (int i = length - 1; i > 0; --i) {
            int n = start + i;
            data[n] = data[n] - data[start + i - 1];
        }
        int n = start;
        data[n] = data[n] - (long)init;
        return nextinit;
    }

    public static long delta(long[] data, int start, int length, int init, long[] out) {
        for (int i = length - 1; i > 0; --i) {
            out[i] = data[start + i] - data[start + i - 1];
        }
        out[0] = data[start] - (long)init;
        return data[start + length - 1];
    }

    public static void inverseDelta(long[] data) {
        for (int i = 1; i < data.length; ++i) {
            int n = i;
            data[n] = data[n] + data[i - 1];
        }
    }

    public static void fastinverseDelta(long[] data) {
        int i;
        int sz0 = data.length / 4 * 4;
        if (sz0 >= 4) {
            long a = data[0];
            for (i = 1; i < sz0 - 4; i += 4) {
                int n = i;
                long l = data[n] + a;
                data[n] = l;
                a = l;
                int n2 = i + 1;
                long l2 = data[n2] + a;
                data[n2] = l2;
                a = l2;
                int n3 = i + 2;
                long l3 = data[n3] + a;
                data[n3] = l3;
                a = l3;
                int n4 = i + 3;
                long l4 = data[n4] + a;
                data[n4] = l4;
                a = l4;
            }
        }
        while (i < data.length) {
            int n = i;
            data[n] = data[n] + data[i - 1];
            ++i;
        }
    }

    public static long fastinverseDelta(long[] data, int start, int length, int init) {
        int i;
        int n = start;
        data[n] = data[n] + (long)init;
        int sz0 = length / 4 * 4;
        if (sz0 >= 4) {
            long a = data[start];
            for (i = 1; i < sz0 - 4; i += 4) {
                int n2 = start + i;
                long l = data[n2] + a;
                data[n2] = l;
                a = l;
                int n3 = start + i + 1;
                long l2 = data[n3] + a;
                data[n3] = l2;
                a = l2;
                int n4 = start + i + 2;
                long l3 = data[n4] + a;
                data[n4] = l3;
                a = l3;
                int n5 = start + i + 3;
                long l4 = data[n5] + a;
                data[n5] = l4;
                a = l4;
            }
        }
        while (i != length) {
            int n6 = start + i;
            data[n6] = data[n6] + data[start + i - 1];
            ++i;
        }
        return data[start + length - 1];
    }
}

