/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.SkippableIntegerCODEC;

public final class Simple16
implements IntegerCODEC,
SkippableIntegerCODEC {
    private static final int S16_NUMSIZE = 16;
    private static final int S16_BITSSIZE = 28;
    private static final int[] S16_NUM = new int[]{28, 21, 21, 21, 14, 9, 8, 7, 6, 6, 5, 5, 4, 3, 2, 1};
    private static final int[][] S16_BITS = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {4, 3, 3, 3, 3, 3, 3, 3, 3}, {3, 4, 4, 4, 4, 3, 3, 3}, {4, 4, 4, 4, 4, 4, 4}, {5, 5, 5, 5, 4, 4}, {4, 4, 5, 5, 5, 5}, {6, 6, 6, 5, 5}, {5, 5, 6, 6, 6}, {7, 7, 7, 7}, {10, 9, 9}, {14, 14}, {28}};
    private static final int[][] SHIFTED_S16_BITS = Simple16.shiftme(S16_BITS);

    @Override
    public void headlessCompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        int i_inpos = inpos.get();
        int i_outpos = outpos.get();
        int finalin = i_inpos + inlength;
        while (i_inpos < finalin) {
            int inoffset;
            if ((inoffset = Simple16.compressblock(out, i_outpos++, in, i_inpos, inlength)) == -1) {
                throw new RuntimeException("Too big a number");
            }
            i_inpos += inoffset;
            inlength -= inoffset;
        }
        inpos.set(i_inpos);
        outpos.set(i_outpos);
    }

    public static final int compressblock(int[] out, int outOffset, int[] in, int inOffset, int n) {
        for (int numIdx = 0; numIdx < 16; ++numIdx) {
            int j;
            out[outOffset] = numIdx << 28;
            int num = S16_NUM[numIdx] < n ? S16_NUM[numIdx] : n;
            int bits = 0;
            for (j = 0; j < num && in[inOffset + j] < SHIFTED_S16_BITS[numIdx][j]; ++j) {
                int n2 = outOffset;
                out[n2] = out[n2] | in[inOffset + j] << bits;
                bits += S16_BITS[numIdx][j];
            }
            if (j != num) continue;
            return num;
        }
        return -1;
    }

    public static final int decompressblock(int[] out, int outOffset, int[] in, int inOffset, int n) {
        int j = 0;
        int bits = 0;
        int numIdx = in[inOffset] >>> 28;
        int num = S16_NUM[numIdx] < n ? S16_NUM[numIdx] : n;
        bits = 0;
        for (j = 0; j < num; ++j) {
            out[outOffset + j] = in[inOffset] >>> bits & -1 >>> 32 - S16_BITS[numIdx][j];
            bits += S16_BITS[numIdx][j];
        }
        return num;
    }

    @Override
    public void headlessUncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, int num) {
        int i_inpos = inpos.get();
        int i_outpos = outpos.get();
        while (num > 0) {
            int howmany = Simple16.decompressblock(out, i_outpos, in, i_inpos, num);
            num -= howmany;
            i_outpos += howmany;
            ++i_inpos;
        }
        inpos.set(i_inpos);
        outpos.set(i_outpos);
    }

    @Override
    public int maxHeadlessCompressedLength(IntWrapper compressedPositions, int inlength) {
        compressedPositions.add(inlength);
        return inlength;
    }

    public static void uncompress(int[] in, int tmpinpos, int inlength, int[] out, int currentPos, int outlength) {
        int finalpos = tmpinpos + inlength;
        while (tmpinpos < finalpos) {
            int howmany = Simple16.decompressblock(out, currentPos, in, tmpinpos, outlength);
            outlength -= howmany;
            currentPos += howmany;
            ++tmpinpos;
        }
    }

    private static int[][] shiftme(int[][] x) {
        int[][] answer = new int[x.length][];
        for (int k = 0; k < x.length; ++k) {
            answer[k] = new int[x[k].length];
            for (int z = 0; z < answer[k].length; ++z) {
                answer[k][z] = 1 << x[k][z];
            }
        }
        return answer;
    }

    @Override
    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        out[outpos.get()] = inlength;
        outpos.increment();
        this.headlessCompress(in, inpos, inlength, out, outpos);
    }

    @Override
    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outlength = in[inpos.get()];
        inpos.increment();
        this.headlessUncompress(in, inpos, inlength, out, outpos, outlength);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

