/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.longcompression;

import java.util.Arrays;
import me.lemire.integercompression.BinaryPacking;
import me.lemire.integercompression.Composition;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.VariableByte;
import me.lemire.longcompression.LongCODEC;
import me.lemire.longcompression.RoaringIntPacking;

public class LongAs2IntsCodec
implements LongCODEC {
    final IntegerCODEC highPartsCodec;
    final IntegerCODEC lowPartsCodec;

    public LongAs2IntsCodec(IntegerCODEC highPartsCodec, IntegerCODEC lowPartsCodec) {
        this.highPartsCodec = highPartsCodec;
        this.lowPartsCodec = lowPartsCodec;
    }

    public LongAs2IntsCodec() {
        this(new VariableByte(), new Composition(new BinaryPacking(), new VariableByte()));
    }

    @Override
    public void compress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        boolean hasLeftover;
        long pack;
        int i;
        if (inlength == 0) {
            return;
        }
        int[] highParts = new int[inlength];
        int[] lowParts = new int[inlength];
        for (int i2 = 0; i2 < inlength; ++i2) {
            int inPosition = inpos.get() + i2;
            highParts[i2] = RoaringIntPacking.high(in[inPosition]);
            lowParts[i2] = RoaringIntPacking.low(in[inPosition]);
        }
        int[] buffer = new int[inlength * 16];
        int outPosition = outpos.get();
        IntWrapper highPartsOutPosition = new IntWrapper(1);
        this.highPartsCodec.compress(highParts, new IntWrapper(), inlength, buffer, highPartsOutPosition);
        buffer[0] = highPartsOutPosition.get() - 1;
        for (i = 0; i < highPartsOutPosition.get() / 2; ++i) {
            pack = RoaringIntPacking.pack(buffer[i * 2], buffer[i * 2 + 1]);
            out[outPosition++] = pack;
        }
        if (1 == highPartsOutPosition.get() % 2) {
            hasLeftover = true;
            buffer[0] = buffer[highPartsOutPosition.get() - 1];
        } else {
            hasLeftover = false;
        }
        IntWrapper lowPartsOutPosition = new IntWrapper(1);
        if (hasLeftover) {
            lowPartsOutPosition.set(2);
        }
        this.lowPartsCodec.compress(lowParts, new IntWrapper(0), inlength, buffer, lowPartsOutPosition);
        buffer[hasLeftover ? 1 : 0] = lowPartsOutPosition.get() - (hasLeftover ? 2 : 1);
        for (i = 0; i < lowPartsOutPosition.get() / 2; ++i) {
            pack = RoaringIntPacking.pack(buffer[i * 2], buffer[i * 2 + 1]);
            out[outPosition++] = pack;
        }
        if (1 == lowPartsOutPosition.get() % 2) {
            long pack2 = RoaringIntPacking.pack(buffer[lowPartsOutPosition.get() - 1], 0);
            out[outPosition++] = pack2;
        }
        inpos.add(inlength);
        outpos.set(outPosition);
    }

    @Override
    public void uncompress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int longIndex = inpos.get();
        int nbCompressedHighParts = RoaringIntPacking.high(in[longIndex]);
        int[] compressedHighParts = new int[nbCompressedHighParts];
        boolean highPart = false;
        for (int i = 0; i < nbCompressedHighParts; ++i) {
            int nextInt = highPart ? RoaringIntPacking.high(in[longIndex + (i + 1) / 2]) : RoaringIntPacking.low(in[longIndex + (i + 1) / 2]);
            compressedHighParts[i] = nextInt;
            highPart = !highPart;
        }
        int[] buffer = new int[inlength * 16];
        IntWrapper highPartsOutPosition = new IntWrapper();
        this.highPartsCodec.uncompress(compressedHighParts, new IntWrapper(), compressedHighParts.length, buffer, highPartsOutPosition);
        int[] highParts = Arrays.copyOf(buffer, highPartsOutPosition.get());
        int intIndexNbCompressedLowParts = longIndex * 2 + 1 + nbCompressedHighParts;
        int nbCompressedLowParts = highPart ? RoaringIntPacking.high(in[intIndexNbCompressedLowParts / 2]) : RoaringIntPacking.low(in[intIndexNbCompressedLowParts / 2]);
        highPart = !highPart;
        int[] compressedLowParts = new int[nbCompressedLowParts];
        for (int i = 0; i < nbCompressedLowParts; ++i) {
            int nextInt = highPart ? RoaringIntPacking.high(in[(intIndexNbCompressedLowParts + 1 + i) / 2]) : RoaringIntPacking.low(in[(intIndexNbCompressedLowParts + 1 + i) / 2]);
            compressedLowParts[i] = nextInt;
            highPart = !highPart;
        }
        IntWrapper lowPartsOutPosition = new IntWrapper();
        this.lowPartsCodec.uncompress(compressedLowParts, new IntWrapper(), compressedLowParts.length, buffer, lowPartsOutPosition);
        int[] lowParts = Arrays.copyOf(buffer, lowPartsOutPosition.get());
        assert (highParts.length == lowParts.length);
        int outposition = outpos.get();
        for (int i = 0; i < highParts.length; ++i) {
            out[outposition++] = RoaringIntPacking.pack(highParts[i], lowParts[i]);
        }
        inpos.add(inlength);
        outpos.set(outposition);
    }
}

