/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.differential;

import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.Util;
import me.lemire.integercompression.differential.IntegratedBitPacking;
import me.lemire.integercompression.differential.IntegratedIntegerCODEC;
import me.lemire.integercompression.differential.SkippableIntegratedIntegerCODEC;

public class IntegratedBinaryPacking
implements IntegratedIntegerCODEC,
SkippableIntegratedIntegerCODEC {
    public static final int BLOCK_SIZE = 32;
    private static final int MAX_BIT_WIDTH = 32;

    @Override
    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if ((inlength = Util.greatestMultiple(inlength, 32)) == 0) {
            return;
        }
        out[outpos.get()] = inlength;
        outpos.increment();
        this.headlessCompress(in, inpos, inlength, out, outpos, new IntWrapper(0));
    }

    @Override
    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outlength = in[inpos.get()];
        inpos.increment();
        this.headlessUncompress(in, inpos, inlength, out, outpos, outlength, new IntWrapper(0));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void headlessCompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, IntWrapper initvalue) {
        if ((inlength = Util.greatestMultiple(inlength, 32)) == 0) {
            return;
        }
        int tmpoutpos = outpos.get();
        int initoffset = initvalue.get();
        initvalue.set(in[inpos.get() + inlength - 1]);
        int s = inpos.get();
        while (s + 128 - 1 < inpos.get() + inlength) {
            int mbits1 = Util.maxdiffbits(initoffset, in, s, 32);
            int initoffset2 = in[s + 31];
            int mbits2 = Util.maxdiffbits(initoffset2, in, s + 32, 32);
            int initoffset3 = in[s + 32 + 31];
            int mbits3 = Util.maxdiffbits(initoffset3, in, s + 64, 32);
            int initoffset4 = in[s + 64 + 31];
            int mbits4 = Util.maxdiffbits(initoffset4, in, s + 96, 32);
            out[tmpoutpos++] = mbits1 << 24 | mbits2 << 16 | mbits3 << 8 | mbits4;
            IntegratedBitPacking.integratedpack(initoffset, in, s, out, tmpoutpos, mbits1);
            IntegratedBitPacking.integratedpack(initoffset2, in, s + 32, out, tmpoutpos += mbits1, mbits2);
            IntegratedBitPacking.integratedpack(initoffset3, in, s + 64, out, tmpoutpos += mbits2, mbits3);
            IntegratedBitPacking.integratedpack(initoffset4, in, s + 96, out, tmpoutpos += mbits3, mbits4);
            tmpoutpos += mbits4;
            initoffset = in[s + 96 + 31];
            s += 128;
        }
        while (s < inpos.get() + inlength) {
            int mbits = Util.maxdiffbits(initoffset, in, s, 32);
            out[tmpoutpos++] = mbits;
            IntegratedBitPacking.integratedpack(initoffset, in, s, out, tmpoutpos, mbits);
            tmpoutpos += mbits;
            initoffset = in[s + 31];
            s += 32;
        }
        inpos.add(inlength);
        outpos.set(tmpoutpos);
    }

    @Override
    public void headlessUncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, int num, IntWrapper initvalue) {
        int outlength = Util.greatestMultiple(num, 32);
        int tmpinpos = inpos.get();
        int initoffset = initvalue.get();
        int s = outpos.get();
        while (s + 128 - 1 < outpos.get() + outlength) {
            int mbits1 = in[tmpinpos] >>> 24;
            int mbits2 = in[tmpinpos] >>> 16 & 0xFF;
            int mbits3 = in[tmpinpos] >>> 8 & 0xFF;
            int mbits4 = in[tmpinpos] & 0xFF;
            IntegratedBitPacking.integratedunpack(initoffset, in, ++tmpinpos, out, s, mbits1);
            initoffset = out[s + 31];
            IntegratedBitPacking.integratedunpack(initoffset, in, tmpinpos += mbits1, out, s + 32, mbits2);
            initoffset = out[s + 32 + 31];
            IntegratedBitPacking.integratedunpack(initoffset, in, tmpinpos += mbits2, out, s + 64, mbits3);
            initoffset = out[s + 64 + 31];
            IntegratedBitPacking.integratedunpack(initoffset, in, tmpinpos += mbits3, out, s + 96, mbits4);
            tmpinpos += mbits4;
            initoffset = out[s + 96 + 31];
            s += 128;
        }
        while (s < outpos.get() + outlength) {
            int mbits = in[tmpinpos];
            IntegratedBitPacking.integratedunpack(initoffset, in, ++tmpinpos, out, s, mbits);
            initoffset = out[s + 31];
            tmpinpos += mbits;
            s += 32;
        }
        outpos.add(outlength);
        initvalue.set(initoffset);
        inpos.set(tmpinpos);
    }

    @Override
    public int maxHeadlessCompressedLength(IntWrapper compressedPositions, int inlength) {
        int blockCount = inlength / 32;
        int headersSizeInInts = blockCount / 4 + blockCount % 4;
        int blocksSizeInInts = blockCount * 32;
        compressedPositions.add(blockCount * 32);
        return headersSizeInInts + blocksSizeInInts;
    }
}

