/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.longcompression;

import me.lemire.integercompression.IntWrapper;
import me.lemire.longcompression.LongCODEC;

public class LongComposition
implements LongCODEC {
    LongCODEC F1;
    LongCODEC F2;

    public LongComposition(LongCODEC f1, LongCODEC f2) {
        this.F1 = f1;
        this.F2 = f2;
    }

    @Override
    public void compress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int inposInit = inpos.get();
        int outposInit = outpos.get();
        this.F1.compress(in, inpos, inlength, out, outpos);
        if (outpos.get() == outposInit) {
            out[outposInit] = 0L;
            outpos.increment();
        }
        this.F2.compress(in, inpos, inlength -= inpos.get() - inposInit, out, outpos);
    }

    @Override
    public void uncompress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int init = inpos.get();
        this.F1.uncompress(in, inpos, inlength, out, outpos);
        this.F2.uncompress(in, inpos, inlength -= inpos.get() - init, out, outpos);
    }

    public String toString() {
        return this.F1.toString() + " + " + this.F2.toString();
    }
}

