/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.longcompression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import me.lemire.integercompression.IntWrapper;
import me.lemire.longcompression.ByteLongCODEC;
import me.lemire.longcompression.LongCODEC;
import me.lemire.longcompression.SkippableLongCODEC;

public class LongVariableByte
implements LongCODEC,
ByteLongCODEC,
SkippableLongCODEC {
    private static final int MAX_BYTES_PER_INT = 10;

    private static byte extract7bits(int i, long val) {
        return (byte)(val >>> 7 * i & 0x7FL);
    }

    private static byte extract7bitsmaskless(int i, long val) {
        return (byte)(val >>> 7 * i);
    }

    @Override
    public void compress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        this.headlessCompress(in, inpos, inlength, out, outpos);
    }

    @Override
    public void headlessCompress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        ByteBuffer buf = this.makeBuffer(inlength * 16);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = in[k];
            if (val >= 0L && val < 128L) {
                buf.put((byte)(val | 0x80L));
                continue;
            }
            if (val >= 0L && val < 16384L) {
                buf.put(LongVariableByte.extract7bits(0, val));
                buf.put((byte)(LongVariableByte.extract7bitsmaskless(1, val) | 0x80));
                continue;
            }
            if (val >= 0L && val < 0x200000L) {
                buf.put(LongVariableByte.extract7bits(0, val));
                buf.put(LongVariableByte.extract7bits(1, val));
                buf.put((byte)(LongVariableByte.extract7bitsmaskless(2, val) | 0x80));
                continue;
            }
            if (val >= 0L && val < 0x10000000L) {
                buf.put(LongVariableByte.extract7bits(0, val));
                buf.put(LongVariableByte.extract7bits(1, val));
                buf.put(LongVariableByte.extract7bits(2, val));
                buf.put((byte)(LongVariableByte.extract7bitsmaskless(3, val) | 0x80));
                continue;
            }
            if (val >= 0L && val < 0x800000000L) {
                buf.put(LongVariableByte.extract7bits(0, val));
                buf.put(LongVariableByte.extract7bits(1, val));
                buf.put(LongVariableByte.extract7bits(2, val));
                buf.put(LongVariableByte.extract7bits(3, val));
                buf.put((byte)(LongVariableByte.extract7bitsmaskless(4, val) | 0x80));
                continue;
            }
            if (val >= 0L && val < 0x40000000000L) {
                buf.put(LongVariableByte.extract7bits(0, val));
                buf.put(LongVariableByte.extract7bits(1, val));
                buf.put(LongVariableByte.extract7bits(2, val));
                buf.put(LongVariableByte.extract7bits(3, val));
                buf.put(LongVariableByte.extract7bits(4, val));
                buf.put((byte)(LongVariableByte.extract7bitsmaskless(5, val) | 0x80));
                continue;
            }
            if (val >= 0L && val < 0x2000000000000L) {
                buf.put(LongVariableByte.extract7bits(0, val));
                buf.put(LongVariableByte.extract7bits(1, val));
                buf.put(LongVariableByte.extract7bits(2, val));
                buf.put(LongVariableByte.extract7bits(3, val));
                buf.put(LongVariableByte.extract7bits(4, val));
                buf.put(LongVariableByte.extract7bits(5, val));
                buf.put((byte)(LongVariableByte.extract7bitsmaskless(6, val) | 0x80));
                continue;
            }
            if (val >= 0L && val < 0x100000000000000L) {
                buf.put(LongVariableByte.extract7bits(0, val));
                buf.put(LongVariableByte.extract7bits(1, val));
                buf.put(LongVariableByte.extract7bits(2, val));
                buf.put(LongVariableByte.extract7bits(3, val));
                buf.put(LongVariableByte.extract7bits(4, val));
                buf.put(LongVariableByte.extract7bits(5, val));
                buf.put(LongVariableByte.extract7bits(6, val));
                buf.put((byte)(LongVariableByte.extract7bitsmaskless(7, val) | 0x80));
                continue;
            }
            if (val >= 0L) {
                buf.put(LongVariableByte.extract7bits(0, val));
                buf.put(LongVariableByte.extract7bits(1, val));
                buf.put(LongVariableByte.extract7bits(2, val));
                buf.put(LongVariableByte.extract7bits(3, val));
                buf.put(LongVariableByte.extract7bits(4, val));
                buf.put(LongVariableByte.extract7bits(5, val));
                buf.put(LongVariableByte.extract7bits(6, val));
                buf.put(LongVariableByte.extract7bits(7, val));
                buf.put((byte)(LongVariableByte.extract7bitsmaskless(8, val) | 0x80));
                continue;
            }
            buf.put(LongVariableByte.extract7bits(0, val));
            buf.put(LongVariableByte.extract7bits(1, val));
            buf.put(LongVariableByte.extract7bits(2, val));
            buf.put(LongVariableByte.extract7bits(3, val));
            buf.put(LongVariableByte.extract7bits(4, val));
            buf.put(LongVariableByte.extract7bits(5, val));
            buf.put(LongVariableByte.extract7bits(6, val));
            buf.put(LongVariableByte.extract7bits(7, val));
            buf.put(LongVariableByte.extract7bits(8, val));
            buf.put((byte)(LongVariableByte.extract7bitsmaskless(9, val) | 0x80));
        }
        while (buf.position() % 8 != 0) {
            buf.put((byte)0);
        }
        int length = buf.position();
        buf.flip();
        LongBuffer ibuf = buf.asLongBuffer();
        ibuf.get(out, outpos.get(), length / 8);
        outpos.add(length / 8);
        inpos.add(inlength);
    }

    @Override
    public void compress(long[] in, IntWrapper inpos, int inlength, byte[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outpostmp = outpos.get();
        for (int k = inpos.get(); k < inpos.get() + inlength; ++k) {
            long val = in[k];
            if (val >= 0L && val < 128L) {
                out[outpostmp++] = (byte)(val | 0x80L);
                continue;
            }
            if (val >= 0L && val < 16384L) {
                out[outpostmp++] = LongVariableByte.extract7bits(0, val);
                out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(1, val) | 0x80);
                continue;
            }
            if (val >= 0L && val < 0x200000L) {
                out[outpostmp++] = LongVariableByte.extract7bits(0, val);
                out[outpostmp++] = LongVariableByte.extract7bits(1, val);
                out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(2, val) | 0x80);
                continue;
            }
            if (val >= 0L && val < 0x10000000L) {
                out[outpostmp++] = LongVariableByte.extract7bits(0, val);
                out[outpostmp++] = LongVariableByte.extract7bits(1, val);
                out[outpostmp++] = LongVariableByte.extract7bits(2, val);
                out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(3, val) | 0x80);
                continue;
            }
            if (val >= 0L && val < 0x800000000L) {
                out[outpostmp++] = LongVariableByte.extract7bits(0, val);
                out[outpostmp++] = LongVariableByte.extract7bits(1, val);
                out[outpostmp++] = LongVariableByte.extract7bits(2, val);
                out[outpostmp++] = LongVariableByte.extract7bits(3, val);
                out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(4, val) | 0x80);
                continue;
            }
            if (val >= 0L && val < 0x40000000000L) {
                out[outpostmp++] = LongVariableByte.extract7bits(0, val);
                out[outpostmp++] = LongVariableByte.extract7bits(1, val);
                out[outpostmp++] = LongVariableByte.extract7bits(2, val);
                out[outpostmp++] = LongVariableByte.extract7bits(3, val);
                out[outpostmp++] = LongVariableByte.extract7bits(4, val);
                out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(5, val) | 0x80);
                continue;
            }
            if (val >= 0L && val < 0x2000000000000L) {
                out[outpostmp++] = LongVariableByte.extract7bits(0, val);
                out[outpostmp++] = LongVariableByte.extract7bits(1, val);
                out[outpostmp++] = LongVariableByte.extract7bits(2, val);
                out[outpostmp++] = LongVariableByte.extract7bits(3, val);
                out[outpostmp++] = LongVariableByte.extract7bits(4, val);
                out[outpostmp++] = LongVariableByte.extract7bits(5, val);
                out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(6, val) | 0x80);
                continue;
            }
            if (val >= 0L && val < 0x100000000000000L) {
                out[outpostmp++] = LongVariableByte.extract7bits(0, val);
                out[outpostmp++] = LongVariableByte.extract7bits(1, val);
                out[outpostmp++] = LongVariableByte.extract7bits(2, val);
                out[outpostmp++] = LongVariableByte.extract7bits(3, val);
                out[outpostmp++] = LongVariableByte.extract7bits(4, val);
                out[outpostmp++] = LongVariableByte.extract7bits(5, val);
                out[outpostmp++] = LongVariableByte.extract7bits(6, val);
                out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(7, val) | 0x80);
                continue;
            }
            if (val >= 0L) {
                out[outpostmp++] = LongVariableByte.extract7bits(0, val);
                out[outpostmp++] = LongVariableByte.extract7bits(1, val);
                out[outpostmp++] = LongVariableByte.extract7bits(2, val);
                out[outpostmp++] = LongVariableByte.extract7bits(3, val);
                out[outpostmp++] = LongVariableByte.extract7bits(4, val);
                out[outpostmp++] = LongVariableByte.extract7bits(5, val);
                out[outpostmp++] = LongVariableByte.extract7bits(6, val);
                out[outpostmp++] = LongVariableByte.extract7bits(7, val);
                out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(8, val) | 0x80);
                continue;
            }
            out[outpostmp++] = LongVariableByte.extract7bits(0, val);
            out[outpostmp++] = LongVariableByte.extract7bits(1, val);
            out[outpostmp++] = LongVariableByte.extract7bits(2, val);
            out[outpostmp++] = LongVariableByte.extract7bits(3, val);
            out[outpostmp++] = LongVariableByte.extract7bits(4, val);
            out[outpostmp++] = LongVariableByte.extract7bits(5, val);
            out[outpostmp++] = LongVariableByte.extract7bits(6, val);
            out[outpostmp++] = LongVariableByte.extract7bits(7, val);
            out[outpostmp++] = LongVariableByte.extract7bits(8, val);
            out[outpostmp++] = (byte)(LongVariableByte.extract7bitsmaskless(9, val) | 0x80);
        }
        outpos.set(outpostmp);
        inpos.add(inlength);
    }

    @Override
    public void uncompress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        int s = 0;
        long val = 0L;
        int p = inpos.get();
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        long v = 0L;
        long shift = 0L;
        while (p < finalp) {
            val = in[p];
            long c = (byte)(val >>> s);
            p += (s += 8) >> 6;
            s &= 0x3F;
            v += (c & 0x7FL) << (int)shift;
            if ((c & 0x80L) == 128L) {
                out[tmpoutpos++] = v;
                v = 0L;
                shift = 0L;
            } else {
                shift += 7L;
            }
            assert (shift < 64L);
        }
        outpos.set(tmpoutpos);
        inpos.add(inlength);
    }

    @Override
    public void uncompress(byte[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos) {
        int p = inpos.get();
        int finalp = inpos.get() + inlength;
        int tmpoutpos = outpos.get();
        long v = 0L;
        while (p < finalp) {
            v = in[p] & 0x7F;
            if (in[p] < 0) {
                ++p;
            } else {
                v = (long)((in[p + 1] & 0x7F) << 7) | v;
                if (in[p + 1] < 0) {
                    p += 2;
                } else {
                    v = (long)((in[p + 2] & 0x7F) << 14) | v;
                    if (in[p + 2] < 0) {
                        p += 3;
                    } else {
                        v = (long)((in[p + 3] & 0x7F) << 21) | v;
                        if (in[p + 3] < 0) {
                            p += 4;
                        } else {
                            v = ((long)in[p + 4] & 0x7FL) << 28 | v;
                            if (in[p + 4] < 0) {
                                p += 5;
                            } else {
                                v = ((long)in[p + 5] & 0x7FL) << 35 | v;
                                if (in[p + 5] < 0) {
                                    p += 6;
                                } else {
                                    v = ((long)in[p + 6] & 0x7FL) << 42 | v;
                                    if (in[p + 6] < 0) {
                                        p += 7;
                                    } else {
                                        v = ((long)in[p + 7] & 0x7FL) << 49 | v;
                                        if (in[p + 7] < 0) {
                                            p += 8;
                                        } else {
                                            v = ((long)in[p + 8] & 0x7FL) << 56 | v;
                                            if (in[p + 8] < 0) {
                                                p += 9;
                                            } else {
                                                v = ((long)in[p + 9] & 0x7FL) << 63 | v;
                                                p += 10;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            out[tmpoutpos++] = v;
        }
        outpos.set(tmpoutpos);
        inpos.add(p);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void headlessUncompress(long[] in, IntWrapper inpos, int inlength, long[] out, IntWrapper outpos, int num) {
        int s = 0;
        long val = 0L;
        int p = inpos.get();
        int tmpoutpos = outpos.get();
        int finaloutpos = num + tmpoutpos;
        long v = 0L;
        long shift = 0L;
        while (tmpoutpos < finaloutpos) {
            val = in[p];
            long c = val >>> s;
            p += (s += 8) >> 6;
            s &= 0x3F;
            v += (c & 0x7FL) << (int)shift;
            if ((c & 0x80L) == 128L) {
                out[tmpoutpos++] = v;
                v = 0L;
                shift = 0L;
            } else {
                shift += 7L;
            }
            assert (shift < 64L);
        }
        outpos.set(tmpoutpos);
        inpos.set(p + (s != 0 ? 1 : 0));
    }

    @Override
    public int maxHeadlessCompressedLength(IntWrapper compressedPositions, int inlength) {
        int maxLengthInBytes = inlength * 10;
        int maxLengthInLongs = (maxLengthInBytes + 8 - 1) / 8;
        compressedPositions.add(inlength);
        return maxLengthInLongs;
    }

    protected ByteBuffer makeBuffer(int sizeInBytes) {
        return ByteBuffer.allocateDirect(sizeInBytes);
    }
}

