/*
 * Decompiled with CFR 0.152.
 */
package me.vilsol.blockly2java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vilsol.blockly2java.BlocklyBlock;
import me.vilsol.blockly2java.Node;
import me.vilsol.blockly2java.annotations.BBlock;
import me.vilsol.blockly2java.annotations.BField;
import me.vilsol.blockly2java.annotations.BStatement;
import me.vilsol.blockly2java.annotations.BValue;

public class Blockly2Java {
    private static HashMap<String, BlocklyBlock> blocks = new HashMap();
    private static Pattern nodePattern = Pattern.compile("(<.*?>)([\\w\\d\\s.]*)");
    private static Pattern attributePattern = Pattern.compile("([a-zA-Z0-9]+)=\"(.+?)\"");

    public static void registerClass(Class<?> block) {
        Field[] fields;
        BBlock b = block.getAnnotation(BBlock.class);
        if (b == null) {
            throw new RuntimeException("Tried to register block (" + block.getName() + ") without @BBlock annotation");
        }
        HashMap<String, Field> blockFields = new HashMap<String, Field>();
        HashMap<String, Field> blockValues = new HashMap<String, Field>();
        HashMap<String, Field> blockStatements = new HashMap<String, Field>();
        for (Field field : fields = block.getDeclaredFields()) {
            Annotation f = field.getAnnotation(BField.class);
            if (f != null) {
                blockFields.put(f.value(), field);
                continue;
            }
            f = field.getAnnotation(BValue.class);
            if (f != null) {
                if (field.getDeclaringClass().getAnnotation(BBlock.class) == null) {
                    throw new RuntimeException("Class:" + block.getName() + " Field:" + field.getName() + " Should be a @BBlock class!");
                }
                blockValues.put(((BValue)f).value(), field);
                continue;
            }
            f = field.getAnnotation(BStatement.class);
            if (f == null) continue;
            if (!field.getType().isAssignableFrom(List.class)) {
                throw new RuntimeException("Class:" + block.getName() + " Field:" + field.getName() + " Should be a list!");
            }
            blockStatements.put(((BStatement)f).value(), field);
        }
        blocks.put(b.value(), new BlocklyBlock(block, b.value(), blockFields, blockValues, blockStatements));
    }

    public static Object parseBlockly(String blockly) {
        Matcher m = nodePattern.matcher(blockly);
        Stack<Node> nodes = new Stack<Node>();
        Node lastNode = null;
        int ignoreBlocks = 0;
        while (m.find()) {
            if (!m.group(1).startsWith("</")) {
                Node node = Blockly2Java.getNode(m.group(1), m.group(2));
                if (node.getName().equals("next")) {
                    nodes.pop();
                    lastNode = (Node)nodes.peek();
                    ++ignoreBlocks;
                    continue;
                }
                if (lastNode != null) {
                    lastNode.addSubnode(node);
                }
                nodes.add(node);
                lastNode = node;
                continue;
            }
            if (nodes.size() <= 0) continue;
            if (((Node)nodes.peek()).getName().equals("block") && ignoreBlocks > 0) {
                --ignoreBlocks;
                continue;
            }
            if (m.group(1).contains("next")) continue;
            nodes.pop();
            if (nodes.size() <= 0) continue;
            lastNode = (Node)nodes.peek();
        }
        assert (lastNode != null);
        return Blockly2Java.parseBlock(lastNode);
    }

    private static Object parseBlock(Node node) {
        BlocklyBlock baseBlock = blocks.get(node.getAttributes().get("type"));
        if (baseBlock == null) {
            throw new RuntimeException("No block with type '" + node.getAttributes().get("type") + "' registered!");
        }
        Object base = baseBlock.newInstance();
        Blockly2Java.fillBlock(baseBlock, base, node);
        return base;
    }

    private static void fillBlock(BlocklyBlock block, Object base, Node node) {
        if (node.getSubnodes() == null || node.getSubnodes().size() == 0) {
            return;
        }
        for (Node s : node.getSubnodes()) {
            switch (s.getName()) {
                case "field": {
                    Field field = block.getFields().get(s.getAttributes().get("name"));
                    if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                        Blockly2Java.setValue(base, field, Integer.parseInt(s.getValue()));
                        break;
                    }
                    if (field.getType().equals(Double.TYPE) || field.getType().equals(Double.class)) {
                        Blockly2Java.setValue(base, field, Double.parseDouble(s.getValue()));
                        break;
                    }
                    if (field.getType().equals(Float.TYPE) || field.getType().equals(Float.class)) {
                        Blockly2Java.setValue(base, field, Float.valueOf(Float.parseFloat(s.getValue())));
                        break;
                    }
                    if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                        Blockly2Java.setValue(base, field, Boolean.parseBoolean(s.getValue()));
                        break;
                    }
                    Blockly2Java.setValue(base, field, s.getValue());
                    break;
                }
                case "value": {
                    Blockly2Java.setValue(base, block.getValues().get(s.getAttributes().get("name")), Blockly2Java.parseBlock((Node)s.getSubnodes().iterator().next()));
                    break;
                }
                case "statement": {
                    ArrayList<Object> objects = new ArrayList<Object>();
                    if (s.getSubnodes() != null && s.getSubnodes().size() > 0) {
                        for (Node n : s.getSubnodes()) {
                            objects.add(Blockly2Java.parseBlock(n));
                        }
                    }
                    Blockly2Java.setValue(base, block.getStatements().get(s.getAttributes().get("name")), objects);
                }
            }
        }
    }

    private static void setValue(Object object, Field field, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static Node getNode(String node, String value) {
        String name = node.split("\\s")[0].split(">")[0].substring(1);
        Matcher m = attributePattern.matcher(node);
        HashMap<String, String> attributes = new HashMap<String, String>();
        while (m.find()) {
            attributes.put(m.group(1), m.group(2));
        }
        return new Node(name, attributes, value);
    }
}

