/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter.surface;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.ericaro.surfaceplotter.DefaultSurfaceModel;
import net.ericaro.surfaceplotter.surface.LineAccumulator;
import net.ericaro.surfaceplotter.surface.Projector;
import net.ericaro.surfaceplotter.surface.SurfaceColor;
import net.ericaro.surfaceplotter.surface.SurfaceModel;
import net.ericaro.surfaceplotter.surface.SurfaceVertex;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.Document;

public class JSurface
extends JComponent {
    private SurfaceModel model;
    private Projector projector;
    private SurfaceVertex[][] surfaceVertex;
    private boolean data_available;
    private boolean interrupted;
    private boolean critical;
    private boolean printing;
    private int prevwidth;
    private int prevheight;
    private int printwidth;
    private int printheight;
    private SurfaceVertex cop;
    private int curve = 0;
    private Graphics graphics;
    private SurfaceModel.PlotType plot_type;
    private int calc_divisions;
    private boolean plotfunc1;
    private boolean plotfunc2;
    private boolean plotboth;
    private boolean isBoxed;
    private boolean isMesh;
    private boolean isScaleBox;
    private boolean isDisplayXY;
    private boolean isDisplayZ;
    private boolean isDisplayGrids;
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private float zmin;
    private float zmax;
    private String xLabel = "X";
    private String yLabel = "Y";
    private static final int TOP = 0;
    private static final int CENTER = 1;
    private static final int UPPER = 1;
    private static final int COINCIDE = 0;
    private static final int LOWER = -1;
    SurfaceColor colors;
    private JSurfaceChangesListener surfaceChangesListener;
    private static JSurface lastFocused;
    private boolean is_data_available;
    private boolean dragged;
    private int click_x;
    private int click_y;
    private int factor_x;
    private int factor_y;
    private int t_x;
    private int t_y;
    private int t_z;
    private float color_factor;
    private Point projection;
    private Color line_color;
    private final int[] poly_x = new int[9];
    private final int[] poly_y = new int[9];
    private final SurfaceVertex[] upperpart = new SurfaceVertex[8];
    private final SurfaceVertex[] lowerpart = new SurfaceVertex[8];
    private final SurfaceVertex[] values1 = new SurfaceVertex[4];
    private final SurfaceVertex[] values2 = new SurfaceVertex[4];
    private final Point[] testpoint = new Point[5];
    private int contour_center_x = 0;
    private int contour_center_y = 0;
    private int contour_space_x = 0;
    private int legend_width = 0;
    private int legend_space = 0;
    private int legend_length = 0;
    private String[] legend_label = null;
    private float contour_width_x = 0.0f;
    private float contour_width_y = 0.0f;
    private Color[] contour_color = null;
    private String[] ylabels = null;
    private int[] xpoints = new int[8];
    private int[] ypoints = new int[8];
    private int[] contour_x = new int[8];
    private int[] contour_y = new int[8];
    private int contour_n = 0;
    private int contour_lines = 10;
    private float[] delta = new float[4];
    private float[] intersection = new float[4];
    private float contour_stepz;
    private SurfaceVertex[] contour_vertex = new SurfaceVertex[4];
    private LineAccumulator accumulator = new LineAccumulator();

    public JSurface() {
        this(new DefaultSurfaceModel());
    }

    public JSurface(SurfaceModel model) {
        this.surfaceChangesListener = new JSurfaceChangesListener();
        JSurfaceMouseListener my = new JSurfaceMouseListener();
        this.addMouseListener(my);
        this.addMouseMotionListener(my);
        this.addMouseWheelListener(my);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                lastFocused = JSurface.this;
            }
        });
        this.setModel(model);
    }

    public static JSurface getFocusedComponent() {
        return lastFocused;
    }

    public SurfaceModel getModel() {
        return this.model;
    }

    public void setModel(SurfaceModel model) {
        if (this.model != null) {
            model.removePropertyChangeListener(this.surfaceChangesListener);
        }
        if (this.model != null) {
            model.removeChangeListener(this.surfaceChangesListener);
        }
        if (model == null) {
            model = new DefaultSurfaceModel();
        }
        this.model = model;
        this.interrupted = false;
        this.data_available = false;
        this.printing = false;
        this.prevheight = -1;
        this.prevwidth = -1;
        this.projector = model.getProjector();
        this.surfaceVertex = new SurfaceVertex[2][];
        model.addPropertyChangeListener(this.surfaceChangesListener);
        model.addChangeListener(this.surfaceChangesListener);
        this.init();
    }

    private String format(float f) {
        return String.format("%.3G", Float.valueOf(f));
    }

    private void init() {
        this.colors = this.model.getColorModel();
        this.setRanges(this.model.getXMin(), this.model.getXMax(), this.model.getYMin(), this.model.getYMax());
        this.data_available = this.model.isDataAvailable();
        if (this.data_available) {
            this.setValuesArray(this.model.getSurfaceVertex());
        }
        this.plot_type = this.model.getPlotType();
        this.isBoxed = this.model.isBoxed();
        this.isMesh = this.model.isMesh();
        this.isScaleBox = this.model.isScaleBox();
        this.isDisplayXY = this.model.isDisplayXY();
        this.isDisplayZ = this.model.isDisplayZ();
        this.isDisplayGrids = this.model.isDisplayGrids();
        this.calc_divisions = this.model.getCalcDivisions();
        this.plotfunc1 = this.model.isPlotFunction1();
        this.plotfunc2 = this.model.isPlotFunction2();
        this.plotboth = this.plotfunc1 && this.plotfunc2;
    }

    public void destroyImage() {
        this.repaint();
    }

    public void setRanges(float xmin, float xmax, float ymin, float ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public float[] getRanges() {
        float[] ranges = new float[]{this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax};
        return ranges;
    }

    public void setDataAvailability(boolean avail) {
        this.data_available = avail;
        this.is_data_available = avail;
    }

    public void setValuesArray(SurfaceVertex[][] vertex) {
        this.surfaceVertex = vertex;
    }

    public SurfaceVertex[][] getValuesArray() {
        if (!this.data_available) {
            return null;
        }
        return this.surfaceVertex;
    }

    public void doExportPNG(File file) throws IOException {
        if (file == null) {
            return;
        }
        int w = 50;
        int h = 30;
        BufferedImage bf = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g2d = bf.createGraphics();
        this.export(g2d);
        boolean b = ImageIO.write((RenderedImage)bf, "PNG", file);
    }

    public void doExportSVG(File file) throws IOException, ParserConfigurationException {
        if (file == null) {
            return;
        }
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        this.export((Graphics)svgGenerator);
        boolean useCSS = true;
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        svgGenerator.stream((Writer)out, useCSS);
    }

    public void paintComponent(Graphics g) {
        if (this.getBounds().width <= 0 || this.getBounds().height <= 0) {
            return;
        }
        if (this.getBounds().width != this.prevwidth || this.getBounds().height != this.prevheight) {
            this.projector.setProjectionArea(new Rectangle(0, 0, this.getBounds().width, this.getBounds().height));
            this.prevwidth = this.getBounds().width;
            this.prevheight = this.getBounds().height;
        }
        this.printing = g instanceof PrintGraphics;
        if (this.printing) {
            this.printing(g);
        }
        if (this.data_available && !this.interrupted) {
            this.draw(g);
        } else {
            g.setColor(this.colors.getBackgroundColor());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            if (this.is3D()) {
                this.drawBoxGridsTicksLabels(g, true);
            }
        }
        this.interrupted = false;
    }

    private boolean is3D() {
        return this.plot_type == SurfaceModel.PlotType.WIREFRAME || this.plot_type == SurfaceModel.PlotType.SURFACE;
    }

    private void printing(Graphics graphics) {
        Dimension pagedimension = ((PrintGraphics)((Object)graphics)).getPrintJob().getPageDimension();
        this.printwidth = pagedimension.width;
        this.printheight = this.prevheight * this.printwidth / this.prevwidth;
        if (this.printheight > pagedimension.height) {
            this.printheight = pagedimension.height;
            this.printwidth = this.prevwidth * this.printheight / this.prevheight;
        }
        float savedscalingfactor = this.projector.get2DScaling();
        this.projector.setProjectionArea(new Rectangle(0, 0, this.printwidth, this.printheight));
        this.projector.set2DScaling(savedscalingfactor * (float)this.printwidth / (float)this.prevwidth);
        graphics.clipRect(0, 0, this.printwidth, this.printheight);
        if (!this.data_available) {
            this.drawBoxGridsTicksLabels(graphics, true);
        }
        graphics.drawRect(0, 0, this.printwidth - 1, this.printheight - 1);
        this.projector.set2DScaling(savedscalingfactor);
        this.projector.setProjectionArea(new Rectangle(0, 0, this.getBounds().width, this.getBounds().height));
    }

    public void update(Graphics g) {
        this.paintComponent(g);
    }

    private void export(Graphics g) {
        if (this.data_available && !this.interrupted) {
            boolean old = this.printing;
            this.printing = true;
            this.draw(g);
            this.printing = old;
        } else {
            System.out.println("empty plot");
            g.setColor(this.colors.getBackgroundColor());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            if (this.is3D()) {
                this.drawBoxGridsTicksLabels(g, true);
            }
        }
    }

    private synchronized void draw(Graphics graphics) {
        this.graphics = graphics;
        int fontsize = (int)Math.round((double)this.projector.get2DScaling() * 0.5);
        SurfaceVertex.invalidate();
        switch (this.plot_type) {
            case CONTOUR: {
                this.plotContour();
                break;
            }
            case DENSITY: {
                this.plotDensity();
                break;
            }
            case WIREFRAME: {
                this.plotWireframe();
                break;
            }
            case SURFACE: {
                this.plotSurface();
            }
        }
        this.cleanUpMemory();
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
        this.firePropertyChange("xLabel", this.xLabel, this.xLabel);
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setYLabel(String yLabel) {
        this.yLabel = yLabel;
        this.firePropertyChange("yLabel", this.yLabel, this.yLabel);
    }

    private final void drawBoundingBox() {
        Point startingpoint = this.projector.project(this.factor_x * 10, this.factor_y * 10, 10.0f);
        this.graphics.setColor(this.colors.getLineBoxColor());
        Point projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
        this.graphics.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
        projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
        this.graphics.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
        projection = this.projector.project(this.factor_x * 10, this.factor_y * 10, -10.0f);
        this.graphics.drawLine(startingpoint.x, startingpoint.y, projection.x, projection.y);
    }

    private final void drawBase(Graphics g, int[] x, int[] y) {
        Point projection = this.projector.project(-10.0f, -10.0f, -10.0f);
        x[0] = projection.x;
        y[0] = projection.y;
        projection = this.projector.project(-10.0f, 10.0f, -10.0f);
        x[1] = projection.x;
        y[1] = projection.y;
        projection = this.projector.project(10.0f, 10.0f, -10.0f);
        x[2] = projection.x;
        y[2] = projection.y;
        projection = this.projector.project(10.0f, -10.0f, -10.0f);
        x[3] = projection.x;
        y[3] = projection.y;
        x[4] = x[0];
        y[4] = y[0];
        g.setColor(this.colors.getBoxColor());
        g.fillPolygon(x, y, 4);
        g.setColor(this.colors.getLineBoxColor());
        g.drawPolygon(x, y, 5);
    }

    private final void drawBoxGridsTicksLabels(Graphics g, boolean draw_axes) {
        boolean x_left = false;
        boolean y_left = false;
        int[] x = new int[5];
        int[] y = new int[5];
        if (this.projector == null) {
            return;
        }
        if (draw_axes) {
            this.drawBase(g, x, y);
            Point projection = this.projector.project(0.0f, 0.0f, -10.0f);
            x[0] = projection.x;
            y[0] = projection.y;
            projection = this.projector.project(10.5f, 0.0f, -10.0f);
            g.drawLine(x[0], y[0], projection.x, projection.y);
            if (projection.x < x[0]) {
                this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "x", 2, 0);
            } else {
                this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "x", 0, 0);
            }
            projection = this.projector.project(0.0f, 11.5f, -10.0f);
            g.drawLine(x[0], y[0], projection.x, projection.y);
            if (projection.x < x[0]) {
                this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "y", 2, 0);
            } else {
                this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "y", 0, 0);
            }
            projection = this.projector.project(0.0f, 0.0f, 10.5f);
            g.drawLine(x[0], y[0], projection.x, projection.y);
            this.outString(g, (int)(1.05 * (double)(projection.x - x[0])) + x[0], (int)(1.05 * (double)(projection.y - y[0])) + y[0], "z", 1, 1);
        } else {
            this.factor_y = 1;
            this.factor_x = 1;
            Point projection = this.projector.project(0.0f, 0.0f, -10.0f);
            x[0] = projection.x;
            projection = this.projector.project(10.5f, 0.0f, -10.0f);
            y_left = projection.x > x[0];
            int i = projection.y;
            projection = this.projector.project(-10.5f, 0.0f, -10.0f);
            if (projection.y > i) {
                this.factor_x = -1;
                y_left = projection.x > x[0];
            }
            projection = this.projector.project(0.0f, 10.5f, -10.0f);
            x_left = projection.x > x[0];
            i = projection.y;
            projection = this.projector.project(0.0f, -10.5f, -10.0f);
            if (projection.y > i) {
                this.factor_y = -1;
                x_left = projection.x > x[0];
            }
            this.setAxesScale();
            this.drawBase(g, x, y);
            if (this.isBoxed) {
                projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, -10.0f);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, 10.0f);
                x[1] = projection.x;
                y[1] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
                x[2] = projection.x;
                y[2] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
                x[3] = projection.x;
                y[3] = projection.y;
                x[4] = x[0];
                y[4] = y[0];
                g.setColor(this.colors.getBoxColor());
                g.fillPolygon(x, y, 4);
                g.setColor(this.colors.getLineBoxColor());
                g.drawPolygon(x, y, 5);
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
                x[2] = projection.x;
                y[2] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
                x[3] = projection.x;
                y[3] = projection.y;
                x[4] = x[0];
                y[4] = y[0];
                g.setColor(this.colors.getBoxColor());
                g.fillPolygon(x, y, 4);
                g.setColor(this.colors.getLineBoxColor());
                g.drawPolygon(x, y, 5);
            } else if (this.isDisplayZ) {
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0f);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0f);
                g.drawLine(x[0], y[0], projection.x, projection.y);
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0f);
                x[0] = projection.x;
                y[0] = projection.y;
                projection = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0f);
                g.drawLine(x[0], y[0], projection.x, projection.y);
            }
            for (i = -9; i <= 9; ++i) {
                Point tickpos;
                if (this.isDisplayXY || this.isDisplayGrids) {
                    if (!this.isDisplayGrids || i % (this.t_y / 2) == 0 || this.isDisplayXY) {
                        projection = this.isDisplayGrids && i % this.t_y == 0 ? this.projector.project(-this.factor_x * 10, i, -10.0f) : (i % this.t_y != 0 ? this.projector.project((float)this.factor_x * 9.8f, i, -10.0f) : this.projector.project((float)this.factor_x * 9.5f, i, -10.0f));
                        tickpos = this.projector.project(this.factor_x * 10, i, -10.0f);
                        g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                        if (i % this.t_y == 0 && this.isDisplayXY) {
                            tickpos = this.projector.project((float)this.factor_x * 10.5f, i, -10.0f);
                            if (y_left) {
                                this.outFloat(g, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.ymax - this.ymin) + (double)this.ymin), 0, 0);
                            } else {
                                this.outFloat(g, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.ymax - this.ymin) + (double)this.ymin), 2, 0);
                            }
                        }
                    }
                    if (!this.isDisplayGrids || i % (this.t_x / 2) == 0 || this.isDisplayXY) {
                        projection = this.isDisplayGrids && i % this.t_x == 0 ? this.projector.project(i, -this.factor_y * 10, -10.0f) : (i % this.t_x != 0 ? this.projector.project(i, (float)this.factor_y * 9.8f, -10.0f) : this.projector.project(i, (float)this.factor_y * 9.5f, -10.0f));
                        tickpos = this.projector.project(i, this.factor_y * 10, -10.0f);
                        g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                        if (i % this.t_x == 0 && this.isDisplayXY) {
                            tickpos = this.projector.project(i, (float)this.factor_y * 10.5f, -10.0f);
                            if (x_left) {
                                this.outFloat(g, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.xmax - this.xmin) + (double)this.xmin), 0, 0);
                            } else {
                                this.outFloat(g, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.xmax - this.xmin) + (double)this.xmin), 2, 0);
                            }
                        }
                    }
                }
                if (this.isDisplayXY) {
                    tickpos = this.projector.project(0.0f, this.factor_y * 14, -10.0f);
                    this.outString(g, tickpos.x, tickpos.y, this.xLabel, 1, 0);
                    tickpos = this.projector.project(this.factor_x * 14, 0.0f, -10.0f);
                    this.outString(g, tickpos.x, tickpos.y, this.yLabel, 1, 0);
                }
                if (!this.isDisplayZ && (!this.isDisplayGrids || !this.isBoxed) || this.isDisplayGrids && i % (this.t_z / 2) != 0 && !this.isDisplayZ) continue;
                if (this.isBoxed && this.isDisplayGrids && i % this.t_z == 0) {
                    projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, i);
                    tickpos = this.projector.project(-this.factor_x * 10, this.factor_y * 10, i);
                } else {
                    projection = i % this.t_z == 0 ? this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.5f, i) : this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.8f, i);
                    tickpos = this.projector.project(-this.factor_x * 10, this.factor_y * 10, i);
                }
                g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                if (this.isDisplayZ) {
                    tickpos = this.projector.project(-this.factor_x * 10, (float)this.factor_y * 10.5f, i);
                    if (i % this.t_z == 0) {
                        if (x_left) {
                            this.outFloat(g, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.zmax - this.zmin) + (double)this.zmin), 0, 1);
                        } else {
                            this.outFloat(g, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.zmax - this.zmin) + (double)this.zmin), 2, 1);
                        }
                    }
                }
                if (this.isDisplayGrids && this.isBoxed && i % this.t_z == 0) {
                    projection = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, i);
                    tickpos = this.projector.project(this.factor_x * 10, -this.factor_y * 10, i);
                } else {
                    projection = i % this.t_z == 0 ? this.projector.project((float)this.factor_x * 9.5f, -this.factor_y * 10, i) : this.projector.project((float)this.factor_x * 9.8f, -this.factor_y * 10, i);
                    tickpos = this.projector.project(this.factor_x * 10, -this.factor_y * 10, i);
                }
                g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                if (this.isDisplayZ) {
                    tickpos = this.projector.project((float)this.factor_x * 10.5f, -this.factor_y * 10, i);
                    if (i % this.t_z == 0) {
                        if (y_left) {
                            this.outFloat(g, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.zmax - this.zmin) + (double)this.zmin), 0, 1);
                        } else {
                            this.outFloat(g, tickpos.x, tickpos.y, (float)((double)(i + 10) / 20.0 * (double)(this.zmax - this.zmin) + (double)this.zmin), 2, 1);
                        }
                    }
                }
                if (!this.isDisplayGrids || !this.isBoxed) continue;
                if (i % this.t_y == 0) {
                    projection = this.projector.project(-this.factor_x * 10, i, -10.0f);
                    tickpos = this.projector.project(-this.factor_x * 10, i, 10.0f);
                    g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
                }
                if (i % this.t_x != 0) continue;
                projection = this.projector.project(i, -this.factor_y * 10, -10.0f);
                tickpos = this.projector.project(i, -this.factor_y * 10, 10.0f);
                g.drawLine(projection.x, projection.y, tickpos.x, tickpos.y);
            }
        }
    }

    private final void setAxesScale() {
        float divisor;
        int longest;
        if (!this.isScaleBox) {
            this.projector.setScaling(1.0f);
            this.t_z = 4;
            this.t_y = 4;
            this.t_x = 4;
            return;
        }
        float scale_x = this.xmax - this.xmin;
        float scale_y = this.ymax - this.ymin;
        float scale_z = this.zmax - this.zmin;
        if (scale_x < scale_y) {
            if (scale_y < scale_z) {
                longest = 3;
                divisor = scale_z;
            } else {
                longest = 2;
                divisor = scale_y;
            }
        } else if (scale_x < scale_z) {
            longest = 3;
            divisor = scale_z;
        } else {
            longest = 1;
            divisor = scale_x;
        }
        scale_y /= divisor;
        scale_z /= divisor;
        if ((scale_x /= divisor) < 0.2f || scale_y < 0.2f && scale_z < 0.2f) {
            switch (longest) {
                case 1: {
                    if (scale_y < scale_z) {
                        scale_y /= scale_z;
                        scale_z = 1.0f;
                        break;
                    }
                    scale_z /= scale_y;
                    scale_y = 1.0f;
                    break;
                }
                case 2: {
                    if (scale_x < scale_z) {
                        scale_x /= scale_z;
                        scale_z = 1.0f;
                        break;
                    }
                    scale_z /= scale_x;
                    scale_x = 1.0f;
                    break;
                }
                case 3: {
                    if (scale_y < scale_x) {
                        scale_y /= scale_x;
                        scale_x = 1.0f;
                        break;
                    }
                    scale_x /= scale_y;
                    scale_y = 1.0f;
                }
            }
        }
        if (scale_x < 0.2f) {
            scale_x = 1.0f;
        }
        this.projector.setXScaling(scale_x);
        if (scale_y < 0.2f) {
            scale_y = 1.0f;
        }
        this.projector.setYScaling(scale_y);
        if (scale_z < 0.2f) {
            scale_z = 1.0f;
        }
        this.projector.setZScaling(scale_z);
        this.t_x = scale_x < 0.5f ? 8 : 4;
        this.t_y = scale_y < 0.5f ? 8 : 4;
        this.t_z = scale_z < 0.5f ? 8 : 4;
    }

    private final void outString(Graphics g, int x, int y, String s, int x_align, int y_align) {
        switch (y_align) {
            case 0: {
                y += g.getFontMetrics(g.getFont()).getAscent();
                break;
            }
            case 1: {
                y += g.getFontMetrics(g.getFont()).getAscent() / 2;
            }
        }
        switch (x_align) {
            case 0: {
                g.drawString(s, x, y);
                break;
            }
            case 2: {
                g.drawString(s, x - g.getFontMetrics(g.getFont()).stringWidth(s), y);
                break;
            }
            case 1: {
                g.drawString(s, x - g.getFontMetrics(g.getFont()).stringWidth(s) / 2, y);
            }
        }
    }

    private final void outFloat(Graphics g, int x, int y, float f, int x_align, int y_align) {
        String s = this.format(f);
        this.outString(g, x, y, s, x_align, y_align);
    }

    private final void plotPlane(SurfaceVertex[] vertex, int verticescount) {
        if (verticescount < 3) {
            return;
        }
        int count = 0;
        float z = 0.0f;
        boolean low1 = vertex[0].z < this.zmin;
        boolean valid1 = !low1 && vertex[0].z <= this.zmax;
        int index = 1;
        for (int loop = 0; loop < verticescount; ++loop) {
            boolean valid2;
            boolean low2 = vertex[index].z < this.zmin;
            boolean bl = valid2 = !low2 && vertex[index].z <= this.zmax;
            if (valid1 || valid2 || low1 ^ low2) {
                float new_y;
                float new_x;
                float ratio;
                float result;
                if (!valid1) {
                    result = low1 ? this.zmin : this.zmax;
                    ratio = (result - vertex[index].z) / (vertex[loop].z - vertex[index].z);
                    new_x = ratio * (vertex[loop].x - vertex[index].x) + vertex[index].x;
                    new_y = ratio * (vertex[loop].y - vertex[index].y) + vertex[index].y;
                    this.projection = low1 ? this.projector.project(new_x, new_y, -10.0f) : this.projector.project(new_x, new_y, 10.0f);
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += result;
                }
                if (valid2) {
                    this.projection = vertex[index].projection(this.projector);
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += vertex[index].z;
                } else {
                    result = low2 ? this.zmin : this.zmax;
                    ratio = (result - vertex[loop].z) / (vertex[index].z - vertex[loop].z);
                    new_x = ratio * (vertex[index].x - vertex[loop].x) + vertex[loop].x;
                    new_y = ratio * (vertex[index].y - vertex[loop].y) + vertex[loop].y;
                    this.projection = low2 ? this.projector.project(new_x, new_y, -10.0f) : this.projector.project(new_x, new_y, 10.0f);
                    this.poly_x[count] = this.projection.x;
                    this.poly_y[count] = this.projection.y;
                    ++count;
                    z += result;
                }
            }
            if (++index == verticescount) {
                index = 0;
            }
            valid1 = valid2;
            low1 = low2;
        }
        if (count > 0) {
            z = (z / (float)count - this.zmin) * this.color_factor;
            this.graphics.setColor(this.colors.getPolygonColor(this.curve, z));
            this.graphics.fillPolygon(this.poly_x, this.poly_y, count);
            this.graphics.setColor(this.colors.getLineColor(1, z));
            if (this.isMesh) {
                this.poly_x[count] = this.poly_x[0];
                this.poly_y[count] = this.poly_y[0];
                this.graphics.drawPolygon(this.poly_x, this.poly_y, ++count);
            }
        }
    }

    private final void splitPlotPlane(SurfaceVertex[] values1, SurfaceVertex[] values2) {
        int trackposition = 0;
        int uppercount = 0;
        int lowercount = 0;
        boolean coincide = true;
        boolean upper_first = false;
        int i = 0;
        int j = 0;
        for (int counter = 0; counter <= 4; ++counter) {
            float zi;
            float xi;
            float yi;
            float factor;
            if (values1[i].z < values2[i].z) {
                coincide = false;
                if (trackposition == 0) {
                    trackposition = 1;
                    this.upperpart[uppercount++] = values2[i];
                } else if (trackposition != 1) {
                    factor = (values1[i].z - values2[i].z) / (values1[i].z - values2[i].z + values2[j].z - values1[j].z);
                    if (values1[i].x == values1[j].x) {
                        yi = factor * (values1[j].y - values1[i].y) + values1[i].y;
                        xi = values1[i].x;
                    } else {
                        xi = factor * (values1[j].x - values1[i].x) + values1[i].x;
                        yi = values1[i].y;
                    }
                    zi = factor * (values2[j].z - values2[i].z) + values2[i].z;
                    int n = uppercount++;
                    int n2 = lowercount++;
                    SurfaceVertex surfaceVertex = new SurfaceVertex(xi, yi, zi);
                    this.lowerpart[n2] = surfaceVertex;
                    this.upperpart[n] = surfaceVertex;
                    this.upperpart[uppercount++] = values2[i];
                    trackposition = 1;
                } else {
                    this.upperpart[uppercount++] = values2[i];
                }
            } else if (values1[i].z > values2[i].z) {
                coincide = false;
                if (trackposition == 0) {
                    trackposition = -1;
                    this.lowerpart[lowercount++] = values2[i];
                } else if (trackposition != -1) {
                    factor = (values1[i].z - values2[i].z) / (values1[i].z - values2[i].z + values2[j].z - values1[j].z);
                    if (values1[i].x == values1[j].x) {
                        yi = factor * (values1[j].y - values1[i].y) + values1[i].y;
                        xi = values1[i].x;
                    } else {
                        xi = factor * (values1[j].x - values1[i].x) + values1[i].x;
                        yi = values1[i].y;
                    }
                    zi = factor * (values2[j].z - values2[i].z) + values2[i].z;
                    int n = lowercount++;
                    int n3 = uppercount++;
                    SurfaceVertex surfaceVertex = new SurfaceVertex(xi, yi, zi);
                    this.upperpart[n3] = surfaceVertex;
                    this.lowerpart[n] = surfaceVertex;
                    this.lowerpart[lowercount++] = values2[i];
                    trackposition = -1;
                } else {
                    this.lowerpart[lowercount++] = values2[i];
                }
            } else {
                this.upperpart[uppercount++] = values2[i];
                this.lowerpart[lowercount++] = values2[i];
                trackposition = 0;
            }
            j = i;
            i = (i + 1) % 4;
        }
        if (coincide) {
            this.plotPlane(values1, 4);
        } else {
            if (this.critical) {
                upper_first = false;
            } else if (values1[1].x == values1[2].x) {
                upper_first = (values1[2].z - values1[3].z) * (this.cop.x - values1[3].x) / (values1[2].x - values1[3].x) + values1[3].z + (values1[2].z - values1[1].z) * (this.cop.y - values1[1].y) / (values1[2].y - values1[1].y) + values1[1].z - values1[2].z > this.cop.z;
            } else {
                boolean bl = upper_first = (values1[2].z - values1[1].z) * (this.cop.x - values1[1].x) / (values1[2].x - values1[1].x) + values1[1].z + (values1[2].z - values1[3].z) * (this.cop.y - values1[3].y) / (values1[2].y - values1[3].y) + values1[3].z - values1[2].z > this.cop.z;
            }
            if (lowercount < 3) {
                if (upper_first) {
                    this.curve = 2;
                    this.plotPlane(this.upperpart, uppercount);
                    this.curve = 1;
                    this.plotPlane(values1, 4);
                } else {
                    this.curve = 1;
                    this.plotPlane(values1, 4);
                    this.curve = 2;
                    this.plotPlane(this.upperpart, uppercount);
                }
            } else if (uppercount < 3) {
                if (upper_first) {
                    this.curve = 1;
                    this.plotPlane(values1, 4);
                    this.curve = 2;
                    this.plotPlane(this.lowerpart, lowercount);
                } else {
                    this.curve = 2;
                    this.plotPlane(this.lowerpart, lowercount);
                    this.curve = 1;
                    this.plotPlane(values1, 4);
                }
            } else if (upper_first) {
                this.curve = 2;
                this.plotPlane(this.upperpart, uppercount);
                this.curve = 1;
                this.plotPlane(values1, 4);
                this.curve = 2;
                this.plotPlane(this.lowerpart, lowercount);
            } else {
                this.curve = 2;
                this.plotPlane(this.lowerpart, lowercount);
                this.curve = 1;
                this.plotPlane(values1, 4);
                this.curve = 2;
                this.plotPlane(this.upperpart, uppercount);
            }
        }
    }

    private final boolean plottable(SurfaceVertex[] values) {
        return !values[0].isInvalid() && !values[1].isInvalid() && !values[2].isInvalid() && !values[3].isInvalid();
    }

    private final void plotArea(int start_lx, int start_ly, int end_lx, int end_ly, int sx, int sy) {
        sx *= this.calc_divisions + 1;
        end_lx *= this.calc_divisions + 1;
        int lx = start_lx *= this.calc_divisions + 1;
        for (int ly = start_ly; ly != end_ly; ly += sy) {
            if (this.plotfunc1) {
                this.values1[1] = this.surfaceVertex[0][lx + ly];
                this.values1[2] = this.surfaceVertex[0][lx + ly + sy];
            }
            if (this.plotfunc2) {
                this.values2[1] = this.surfaceVertex[1][lx + ly];
                this.values2[2] = this.surfaceVertex[1][lx + ly + sy];
            }
            while (lx != end_lx) {
                Thread.yield();
                if (this.plotfunc1) {
                    this.values1[0] = this.values1[1];
                    this.values1[1] = this.surfaceVertex[0][lx + sx + ly];
                    this.values1[3] = this.values1[2];
                    this.values1[2] = this.surfaceVertex[0][lx + sx + ly + sy];
                }
                if (this.plotfunc2) {
                    this.values2[0] = this.values2[1];
                    this.values2[1] = this.surfaceVertex[1][lx + sx + ly];
                    this.values2[3] = this.values2[2];
                    this.values2[2] = this.surfaceVertex[1][lx + sx + ly + sy];
                }
                if (!this.plotboth) {
                    if (this.plotfunc1) {
                        this.curve = 1;
                        if (this.plottable(this.values1)) {
                            this.plotPlane(this.values1, 4);
                        }
                    } else {
                        this.curve = 2;
                        if (this.plottable(this.values2)) {
                            this.plotPlane(this.values2, 4);
                        }
                    }
                } else if (this.plottable(this.values1)) {
                    if (this.plottable(this.values2)) {
                        this.splitPlotPlane(this.values1, this.values2);
                    } else {
                        this.curve = 1;
                        this.plotPlane(this.values1, 4);
                    }
                } else if (this.plottable(this.values2)) {
                    this.curve = 2;
                    this.plotPlane(this.values2, 4);
                }
                lx += sx;
            }
            lx = start_lx;
        }
    }

    private final void plotSurface() {
        int sy;
        int end_ly;
        int start_ly;
        int sx;
        int end_lx;
        int start_lx;
        float zx;
        float zi;
        try {
            zi = this.model.getZMin();
            zx = this.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            return;
        }
        int plot_density = this.model.getDispDivisions();
        int multiple_factor = this.calc_divisions / plot_density;
        Thread.yield();
        this.zmin = zi;
        this.zmax = zx;
        this.color_factor = 1.0f / (this.zmax - this.zmin);
        if (!this.printing) {
            this.graphics.setColor(this.colors.getBackgroundColor());
            this.graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        this.drawBoxGridsTicksLabels(this.graphics, false);
        if (!this.plotfunc1 && !this.plotfunc2) {
            if (this.isBoxed) {
                this.drawBoundingBox();
            }
            return;
        }
        this.projector.setZRange(this.zmin, this.zmax);
        float distance = this.projector.getDistance() * this.projector.getCosElevationAngle();
        this.cop = new SurfaceVertex(distance * this.projector.getSinRotationAngle(), distance * this.projector.getCosRotationAngle(), this.projector.getDistance() * this.projector.getSinElevationAngle());
        this.cop.transform(this.projector);
        boolean inc_x = this.cop.x > 0.0f;
        boolean inc_y = this.cop.y > 0.0f;
        this.critical = false;
        if (inc_x) {
            start_lx = 0;
            end_lx = this.calc_divisions;
            sx = multiple_factor;
        } else {
            start_lx = this.calc_divisions;
            end_lx = 0;
            sx = -multiple_factor;
        }
        if (inc_y) {
            start_ly = 0;
            end_ly = this.calc_divisions;
            sy = multiple_factor;
        } else {
            start_ly = this.calc_divisions;
            end_ly = 0;
            sy = -multiple_factor;
        }
        if (this.cop.x > 10.0f || this.cop.x < -10.0f) {
            if (this.cop.y > 10.0f || this.cop.y < -10.0f) {
                this.plotArea(start_lx, start_ly, end_lx, end_ly, sx, sy);
            } else {
                int split_y = (int)((this.cop.y + 10.0f) * (float)plot_density / 20.0f) * multiple_factor;
                this.plotArea(start_lx, 0, end_lx, split_y, sx, multiple_factor);
                this.plotArea(start_lx, this.calc_divisions, end_lx, split_y, sx, -multiple_factor);
            }
        } else if (this.cop.y > 10.0f || this.cop.y < -10.0f) {
            int split_x = (int)((this.cop.x + 10.0f) * (float)plot_density / 20.0f) * multiple_factor;
            this.plotArea(0, start_ly, split_x, end_ly, multiple_factor, sy);
            this.plotArea(this.calc_divisions, start_ly, split_x, end_ly, -multiple_factor, sy);
        } else {
            int split_x = (int)((this.cop.x + 10.0f) * (float)plot_density / 20.0f) * multiple_factor;
            int split_y = (int)((this.cop.y + 10.0f) * (float)plot_density / 20.0f) * multiple_factor;
            this.critical = true;
            this.plotArea(0, 0, split_x, split_y, multiple_factor, multiple_factor);
            this.plotArea(0, this.calc_divisions, split_x, split_y, multiple_factor, -multiple_factor);
            this.plotArea(this.calc_divisions, 0, split_x, split_y, -multiple_factor, multiple_factor);
            this.plotArea(this.calc_divisions, this.calc_divisions, split_x, split_y, -multiple_factor, -multiple_factor);
        }
        if (this.isBoxed) {
            this.drawBoundingBox();
        }
    }

    private final int contourConvertX(float x) {
        return Math.round(x * this.contour_width_x + (float)this.contour_center_x);
    }

    private final int contourConvertY(float y) {
        return Math.round(-y * this.contour_width_y + (float)this.contour_center_y);
    }

    private final void drawBoundingRect() {
        int i;
        this.graphics.setColor(this.colors.getLineBoxColor());
        int x1 = this.contourConvertX(-10.0f);
        int y1 = this.contourConvertY(10.0f);
        int x2 = this.contourConvertX(10.0f);
        int y2 = this.contourConvertY(-10.0f);
        this.graphics.drawRect(x1, y1, x2 - x1, y2 - y1);
        if (this.isDisplayXY || this.isDisplayGrids) {
            if (this.isDisplayXY) {
                x1 = this.contourConvertX(-10.5f);
                y1 = this.contourConvertY(10.5f);
                x2 = this.contourConvertX(10.5f);
                y2 = this.contourConvertY(-10.5f);
                this.graphics.drawRect(x1, y1, x2 - x1, y2 - y1);
            }
            int labelindex = 0;
            for (i = -10; i <= 10; ++i) {
                if (!this.isDisplayGrids || i % (this.t_y / 2) == 0 || this.isDisplayXY) {
                    int yc = this.contourConvertY(i);
                    if (this.isDisplayGrids && i % this.t_y == 0) {
                        this.graphics.drawLine(this.contourConvertX(-10.0f), yc, this.contourConvertX(10.0f), yc);
                    }
                    if (this.isDisplayXY) {
                        if (i % this.t_y != 0) {
                            this.graphics.drawLine(this.contourConvertX(10.3f), yc, x2, yc);
                            this.graphics.drawLine(this.contourConvertX(-10.3f), yc, x1, yc);
                        } else {
                            this.graphics.drawLine(this.contourConvertX(10.0f), yc, x2, yc);
                            this.graphics.drawLine(this.contourConvertX(-10.0f), yc, x1, yc);
                        }
                    }
                    if (i % this.t_y == 0 && this.isDisplayXY) {
                        this.outString(this.graphics, this.contourConvertX(10.7f), yc, this.ylabels[labelindex++], 0, 1);
                    }
                }
                if (!this.isDisplayGrids || i % (this.t_x / 2) == 0 || this.isDisplayXY) {
                    int xc = this.contourConvertX(i);
                    if (this.isDisplayGrids && i % this.t_x == 0) {
                        this.graphics.drawLine(xc, this.contourConvertY(-10.0f), xc, this.contourConvertY(10.0f));
                    }
                    if (this.isDisplayXY) {
                        if (i % this.t_x != 0) {
                            this.graphics.drawLine(xc, this.contourConvertY(-10.3f), xc, y2);
                            this.graphics.drawLine(xc, this.contourConvertY(10.3f), xc, y1);
                        } else {
                            this.graphics.drawLine(xc, this.contourConvertY(-10.0f), xc, y2);
                            this.graphics.drawLine(xc, this.contourConvertY(10.0f), xc, y1);
                        }
                    }
                    if (i % this.t_x == 0 && this.isDisplayXY) {
                        this.outFloat(this.graphics, xc, this.contourConvertY(-10.7f), (float)((double)(i + 10) / 20.0 * (double)(this.xmax - this.xmin) + (double)this.xmin), 1, 0);
                    }
                }
                if (!this.isDisplayXY) continue;
                this.outString(this.graphics, (x1 + x2) / 2, this.contourConvertY(-11.4f), this.xLabel, 1, 0);
                this.outString(this.graphics, this.contourConvertX(10.7f), this.contourConvertY(-1.0f), this.yLabel, 0, 1);
            }
        }
        if (this.isDisplayZ) {
            int lasty = y2;
            int height = y2 - y1;
            int divisions = this.contour_lines;
            x1 = (x2 += this.contour_space_x) - (this.legend_space + this.legend_width + this.legend_length);
            this.graphics.setColor(this.colors.getTextColor());
            this.outString(this.graphics, x2 -= this.legend_length, y2, this.legend_label[0], 0, 1);
            for (i = 1; i <= divisions + 1; ++i) {
                int y = y2 - i * height / (divisions + 1);
                this.graphics.setColor(this.contour_color[i - 1]);
                this.graphics.fillRect(x1, y, this.legend_width, lasty - y);
                this.graphics.setColor(this.colors.getLineColor());
                this.graphics.drawRect(x1, y, this.legend_width, lasty - y);
                this.outString(this.graphics, x2, y, this.legend_label[i], 0, 1);
                lasty = y;
            }
        }
    }

    private final void cleanUpMemory() {
        this.legend_label = null;
        this.contour_color = null;
        this.ylabels = null;
        this.accumulator.clearAccumulator();
    }

    private final void computePlotArea() {
        this.setAxesScale();
        this.contour_lines = this.model.getContourLines();
        float ratio = this.projector.getYScaling() / this.projector.getXScaling();
        float width = 0.0f;
        float height = 0.0f;
        if (this.printing) {
            width = this.printwidth;
            height = this.printheight;
        } else {
            width = this.getBounds().width;
            height = this.getBounds().height;
        }
        int fontsize = 0;
        fontsize = width < height ? (int)(width / 48.0f) : (int)(height / 48.0f);
        this.graphics.setFont(new Font("Helvetica", 0, fontsize));
        FontMetrics fm = this.graphics.getFontMetrics();
        width *= 0.9f;
        height *= 0.9f;
        int spacex = 0;
        int spacey = 0;
        if (this.isDisplayXY) {
            int i;
            int labelscount = 0;
            int index = 0;
            int maxwidth = 0;
            for (i = -10; i < 10; ++i) {
                if (i % this.t_y != 0) continue;
                ++labelscount;
            }
            this.ylabels = new String[labelscount];
            for (i = -10; i < 10; ++i) {
                int strwidth;
                if (i % this.t_y != 0) continue;
                this.ylabels[index] = this.format((float)((double)(i + 10) / 20.0 * (double)(this.ymax - this.ymin) + (double)this.ymin));
                if ((strwidth = fm.stringWidth(this.ylabels[index++])) <= maxwidth) continue;
                maxwidth = strwidth;
            }
            spacex += maxwidth;
            spacey += fm.getMaxAscent();
        }
        if (this.isDisplayZ) {
            this.legend_width = (int)((double)width * 0.05);
            spacex += this.legend_width * 2;
            this.legend_space = fontsize;
            int counts = this.contour_lines;
            this.legend_length = 0;
            this.legend_label = new String[counts += 2];
            for (int i = 0; i < counts; ++i) {
                float label = (float)((double)i / (double)(counts - 1) * (double)(this.zmax - this.zmin) + (double)this.zmin);
                this.legend_label[i] = this.format(label);
                int labelwidth = fm.stringWidth(this.legend_label[i]);
                if (labelwidth <= this.legend_length) continue;
                this.legend_length = labelwidth;
            }
            spacex += this.legend_length + this.legend_space;
        }
        height -= (float)spacey;
        this.contour_width_x = width -= (float)spacex;
        this.contour_width_y = width * ratio;
        if (this.contour_width_y > height) {
            this.contour_width_y = height;
            this.contour_width_x = height / ratio;
        }
        float scaling_factor = 10.0f;
        if (this.isDisplayXY) {
            scaling_factor = 10.7f;
        }
        this.contour_width_x = this.contour_width_x / scaling_factor / 2.0f;
        this.contour_width_y = this.contour_width_y / scaling_factor / 2.0f;
        this.contour_center_x = 0;
        this.contour_center_y = 0;
        int x1 = this.contourConvertX(-scaling_factor);
        int y1 = this.contourConvertY(scaling_factor);
        int x2 = this.contourConvertX(scaling_factor) + spacex;
        int y2 = this.contourConvertY(-scaling_factor) + spacey;
        this.contour_center_x = (this.getBounds().width - (x1 + x2)) / 2;
        this.contour_center_y = (this.getBounds().height - (y1 + y2)) / 2;
        this.contour_space_x = spacex;
        this.contour_color = new Color[this.contour_lines + 1];
        for (int i = 0; i <= this.contour_lines; ++i) {
            float level = (float)i / (float)this.contour_lines;
            this.contour_color[i] = this.colors.getPolygonColor(this.curve, level);
        }
    }

    private final void createContour() {
        float z = this.zmin;
        int xmin = this.xpoints[0] = this.contourConvertX(this.contour_vertex[0].x);
        int xmax = this.xpoints[4] = this.contourConvertX(this.contour_vertex[2].x);
        this.ypoints[0] = this.contourConvertY(this.contour_vertex[0].y);
        this.xpoints[2] = this.contourConvertX(this.contour_vertex[1].x);
        this.ypoints[4] = this.contourConvertY(this.contour_vertex[2].y);
        this.xpoints[6] = this.contourConvertX(this.contour_vertex[3].x);
        this.ypoints[2] = this.ypoints[3] = this.contourConvertY(this.contour_vertex[1].y);
        this.ypoints[6] = this.ypoints[7] = this.contourConvertY(this.contour_vertex[3].y);
        this.xpoints[7] = -1;
        this.xpoints[5] = -1;
        this.xpoints[3] = -1;
        this.xpoints[1] = -1;
        for (int counter = 0; counter <= this.contour_lines + 1; ++counter) {
            block7: for (int edge = 0; edge < 4; ++edge) {
                int index = (edge << 1) + 1;
                int nextedge = edge + 1 & 3;
                if (z > this.contour_vertex[edge].z) {
                    this.xpoints[index - 1] = -2;
                    if (z > this.contour_vertex[nextedge].z) {
                        this.xpoints[index + 1 & 7] = -2;
                        this.xpoints[index] = -2;
                    }
                } else if (z > this.contour_vertex[nextedge].z) {
                    this.xpoints[index + 1 & 7] = -2;
                }
                if (this.xpoints[index] == -2) continue;
                if (this.xpoints[index] != -1) {
                    int n = edge;
                    this.intersection[n] = this.intersection[n] + this.delta[edge];
                    if (index == 1 || index == 5) {
                        this.ypoints[index] = this.contourConvertY(this.intersection[edge]);
                        continue;
                    }
                    this.xpoints[index] = this.contourConvertX(this.intersection[edge]);
                    continue;
                }
                if (!(z > this.contour_vertex[edge].z) && !(z > this.contour_vertex[nextedge].z)) continue;
                switch (index) {
                    case 1: {
                        this.delta[edge] = (this.contour_vertex[nextedge].y - this.contour_vertex[edge].y) * this.contour_stepz / (this.contour_vertex[nextedge].z - this.contour_vertex[edge].z);
                        this.intersection[edge] = (this.contour_vertex[nextedge].y * (z - this.contour_vertex[edge].z) + this.contour_vertex[edge].y * (this.contour_vertex[nextedge].z - z)) / (this.contour_vertex[nextedge].z - this.contour_vertex[edge].z);
                        this.xpoints[index] = xmin;
                        this.ypoints[index] = this.contourConvertY(this.intersection[edge]);
                        continue block7;
                    }
                    case 3: {
                        this.delta[edge] = (this.contour_vertex[nextedge].x - this.contour_vertex[edge].x) * this.contour_stepz / (this.contour_vertex[nextedge].z - this.contour_vertex[edge].z);
                        this.intersection[edge] = (this.contour_vertex[nextedge].x * (z - this.contour_vertex[edge].z) + this.contour_vertex[edge].x * (this.contour_vertex[nextedge].z - z)) / (this.contour_vertex[nextedge].z - this.contour_vertex[edge].z);
                        this.xpoints[index] = this.contourConvertX(this.intersection[edge]);
                        continue block7;
                    }
                    case 5: {
                        this.delta[edge] = (this.contour_vertex[edge].y - this.contour_vertex[nextedge].y) * this.contour_stepz / (this.contour_vertex[edge].z - this.contour_vertex[nextedge].z);
                        this.intersection[edge] = (this.contour_vertex[edge].y * (z - this.contour_vertex[nextedge].z) + this.contour_vertex[nextedge].y * (this.contour_vertex[edge].z - z)) / (this.contour_vertex[edge].z - this.contour_vertex[nextedge].z);
                        this.xpoints[index] = xmax;
                        this.ypoints[index] = this.contourConvertY(this.intersection[edge]);
                        continue block7;
                    }
                    case 7: {
                        this.delta[edge] = (this.contour_vertex[edge].x - this.contour_vertex[nextedge].x) * this.contour_stepz / (this.contour_vertex[edge].z - this.contour_vertex[nextedge].z);
                        this.intersection[edge] = (this.contour_vertex[edge].x * (z - this.contour_vertex[nextedge].z) + this.contour_vertex[nextedge].x * (this.contour_vertex[edge].z - z)) / (this.contour_vertex[edge].z - this.contour_vertex[nextedge].z);
                        this.xpoints[index] = this.contourConvertX(this.intersection[edge]);
                    }
                }
            }
            this.contour_n = 0;
            for (int index = 0; index < 8; ++index) {
                if (this.xpoints[index] < 0) continue;
                this.contour_x[this.contour_n] = this.xpoints[index];
                this.contour_y[this.contour_n] = this.ypoints[index];
                ++this.contour_n;
            }
            if (counter > this.contour_lines) {
                if (this.printing) {
                    this.graphics.setColor(Color.white);
                } else {
                    this.graphics.setColor(this.colors.getBackgroundColor());
                }
            } else {
                this.graphics.setColor(this.contour_color[counter]);
            }
            if (this.ok(this.contour_x, this.contour_n) && this.ok(this.contour_y, this.contour_n)) {
                this.graphics.fillPolygon(this.contour_x, this.contour_y, this.contour_n);
            }
            if (this.isMesh) {
                int x = -1;
                int y = -1;
                for (int index = 1; index < 8; index += 2) {
                    if (this.xpoints[index] < 0) continue;
                    if (x != -1) {
                        this.accumulator.addLine(x, y, this.xpoints[index], this.ypoints[index]);
                    }
                    x = this.xpoints[index];
                    y = this.ypoints[index];
                }
                if (this.xpoints[1] > 0 && x != -1) {
                    this.accumulator.addLine(x, y, this.xpoints[1], this.ypoints[1]);
                }
            }
            if (this.contour_n < 3) break;
            z += this.contour_stepz;
        }
    }

    private boolean ok(int[] f, int x) {
        for (int i = 0; i < x; ++i) {
            if (f[i] > 0) continue;
            return false;
        }
        return true;
    }

    private final void plotContour() {
        float zx;
        float zi;
        this.accumulator.clearAccumulator();
        try {
            zi = this.model.getZMin();
            zx = this.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.out.println("plotContour:Error in ranges");
            return;
        }
        this.zmin = zi;
        this.zmax = zx;
        this.curve = this.plotfunc1 ? 1 : (this.plotfunc2 ? 2 : 1);
        this.computePlotArea();
        int plot_density = this.model.getDispDivisions();
        int multiple_factor = this.calc_divisions / plot_density;
        Thread.yield();
        this.contour_stepz = (zx - zi) / (float)(this.contour_lines + 1);
        if (!this.printing) {
            this.graphics.setColor(this.colors.getBackgroundColor());
            this.graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        if (this.plotfunc1 || this.plotfunc2) {
            int index = 0;
            int func = 0;
            if (!this.plotfunc1) {
                func = 1;
            }
            this.curve = func + 1;
            int delta = (this.calc_divisions + 1) * multiple_factor;
            for (int i = 0; i < this.calc_divisions; i += multiple_factor) {
                index = i * (this.calc_divisions + 1);
                for (int j = 0; j < this.calc_divisions; j += multiple_factor) {
                    this.contour_vertex[0] = this.surfaceVertex[func][index];
                    this.contour_vertex[1] = this.surfaceVertex[func][index + multiple_factor];
                    this.contour_vertex[2] = this.surfaceVertex[func][index + delta + multiple_factor];
                    this.contour_vertex[3] = this.surfaceVertex[func][index + delta];
                    this.createContour();
                    index += multiple_factor;
                }
            }
        }
        this.graphics.setColor(this.colors.getLineColor());
        this.accumulator.drawAll(this.graphics);
        this.drawBoundingRect();
    }

    private final void plotDensity() {
        float zx;
        float zi;
        try {
            zi = this.model.getZMin();
            zx = this.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Error in ranges");
            return;
        }
        this.zmin = zi;
        this.zmax = zx;
        this.curve = this.plotfunc1 ? 1 : (this.plotfunc2 ? 2 : 1);
        this.computePlotArea();
        int plot_density = this.model.getDispDivisions();
        int multiple_factor = this.calc_divisions / plot_density;
        this.color_factor = 1.0f / (zx - zi);
        if (!this.printing) {
            this.graphics.setColor(this.colors.getBackgroundColor());
            this.graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        if (this.plotfunc1 || this.plotfunc2) {
            int index = 0;
            int func = 0;
            if (!this.plotfunc1) {
                func = 1;
            }
            this.curve = func + 1;
            int delta = (this.calc_divisions + 1) * multiple_factor;
            for (int i = 0; i < this.calc_divisions; i += multiple_factor) {
                index = i * (this.calc_divisions + 1);
                for (int j = 0; j < this.calc_divisions; j += multiple_factor) {
                    this.contour_vertex[0] = this.surfaceVertex[func][index];
                    this.contour_vertex[1] = this.surfaceVertex[func][index + multiple_factor];
                    this.contour_vertex[2] = this.surfaceVertex[func][index + delta + multiple_factor];
                    this.contour_vertex[3] = this.surfaceVertex[func][index + delta];
                    int x = this.contourConvertX(this.contour_vertex[1].x);
                    int y = this.contourConvertY(this.contour_vertex[1].y);
                    int w = this.contourConvertX(this.contour_vertex[3].x) - x;
                    int h = this.contourConvertY(this.contour_vertex[3].y) - y;
                    float z = 0.0f;
                    boolean error = false;
                    for (int loop = 0; loop < 4; ++loop) {
                        if (Float.isNaN(this.contour_vertex[loop].z)) {
                            error = true;
                            break;
                        }
                        z += this.contour_vertex[loop].z;
                    }
                    if (error) {
                        index += multiple_factor;
                        continue;
                    }
                    z /= 4.0f;
                    z = (z - zi) * this.color_factor;
                    this.graphics.setColor(this.colors.getPolygonColor(this.curve, z));
                    this.graphics.fillRect(x, y, w, h);
                    if (this.isMesh) {
                        this.graphics.setColor(this.colors.getLineColor(this.curve, z));
                        this.graphics.drawRect(x, y, w, h);
                    }
                    index += multiple_factor;
                }
            }
        }
        this.drawBoundingRect();
    }

    private final void plotWireframe() {
        float zx;
        float zi;
        float lx = 0.0f;
        float ly = 0.0f;
        float lastz = 0.0f;
        Point lastproj = new Point(0, 0);
        this.projection = new Point(0, 0);
        try {
            zi = this.model.getZMin();
            zx = this.model.getZMax();
            if (zi >= zx) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Error in ranges");
            return;
        }
        int plot_density = this.model.getDispDivisions();
        int multiple_factor = this.calc_divisions / plot_density;
        this.zmin = zi;
        this.zmax = zx;
        if (!this.printing) {
            this.graphics.setColor(this.colors.getBackgroundColor());
            this.graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        }
        Thread.yield();
        this.drawBoxGridsTicksLabels(this.graphics, false);
        this.projector.setZRange(this.zmin, this.zmax);
        for (int func = 0; func < 2; ++func) {
            float ratio;
            boolean error;
            boolean invalid;
            float z;
            boolean lasterror;
            int i;
            if (func == 0 && !this.plotfunc1 || func == 1 && !this.plotfunc2) continue;
            int j = 0;
            int k = 0;
            int counter = 0;
            for (i = 0; i <= this.calc_divisions; ++i) {
                lasterror = true;
                if (counter == 0) {
                    while (j <= this.calc_divisions) {
                        Thread.yield();
                        z = this.surfaceVertex[func][k].z;
                        invalid = Float.isNaN(z);
                        if (!invalid) {
                            this.graphics.setColor(this.colors.getLineColor(this.curve, z));
                            if (z < this.zmin) {
                                error = true;
                                ratio = (this.zmin - lastz) / (z - lastz);
                                this.projection = this.projector.project(ratio * (this.surfaceVertex[func][k].x - lx) + lx, ratio * (this.surfaceVertex[func][k].y - ly) + ly, -10.0f);
                            } else if (z > this.zmax) {
                                error = true;
                                ratio = (this.zmax - lastz) / (z - lastz);
                                this.projection = this.projector.project(ratio * (this.surfaceVertex[func][k].x - lx) + lx, ratio * (this.surfaceVertex[func][k].y - ly) + ly, 10.0f);
                            } else {
                                error = false;
                                this.projection = this.surfaceVertex[func][k].projection(this.projector);
                            }
                            if (lasterror && !error && j != 0) {
                                if (lastz > this.zmax) {
                                    ratio = (this.zmax - z) / (lastz - z);
                                    lastproj = this.projector.project(ratio * (lx - this.surfaceVertex[func][k].x) + this.surfaceVertex[func][k].x, ratio * (ly - this.surfaceVertex[func][k].y) + this.surfaceVertex[func][k].y, 10.0f);
                                } else if (lastz < this.zmin) {
                                    ratio = (this.zmin - z) / (lastz - z);
                                    lastproj = this.projector.project(ratio * (lx - this.surfaceVertex[func][k].x) + this.surfaceVertex[func][k].x, ratio * (ly - this.surfaceVertex[func][k].y) + this.surfaceVertex[func][k].y, -10.0f);
                                }
                            } else {
                                invalid = error && lasterror;
                            }
                        } else {
                            error = true;
                        }
                        if (!invalid && j != 0) {
                            this.graphics.drawLine(lastproj.x, lastproj.y, this.projection.x, this.projection.y);
                        }
                        lastproj = this.projection;
                        lasterror = error;
                        lx = this.surfaceVertex[func][k].x;
                        ly = this.surfaceVertex[func][k].y;
                        lastz = z;
                        ++j;
                        ++k;
                    }
                } else {
                    k += this.calc_divisions + 1;
                }
                j = 0;
                counter = (counter + 1) % multiple_factor;
            }
            i = 0;
            j = 0;
            k = 0;
            counter = 0;
            while (j <= this.calc_divisions) {
                lasterror = true;
                if (counter == 0) {
                    while (i <= this.calc_divisions) {
                        Thread.yield();
                        z = this.surfaceVertex[func][k].z;
                        invalid = Float.isNaN(z);
                        if (!invalid) {
                            if (z < this.zmin) {
                                error = true;
                                ratio = (this.zmin - lastz) / (z - lastz);
                                this.projection = this.projector.project(ratio * (this.surfaceVertex[func][k].x - lx) + lx, ratio * (this.surfaceVertex[func][k].y - ly) + ly, -10.0f);
                            } else if (z > this.zmax) {
                                error = true;
                                ratio = (this.zmax - lastz) / (z - lastz);
                                this.projection = this.projector.project(ratio * (this.surfaceVertex[func][k].x - lx) + lx, ratio * (this.surfaceVertex[func][k].y - ly) + ly, 10.0f);
                            } else {
                                error = false;
                                this.projection = this.surfaceVertex[func][k].projection(this.projector);
                            }
                            if (lasterror && !error && i != 0) {
                                if (lastz > this.zmax) {
                                    ratio = (this.zmax - z) / (lastz - z);
                                    lastproj = this.projector.project(ratio * (lx - this.surfaceVertex[func][k].x) + this.surfaceVertex[func][k].x, ratio * (ly - this.surfaceVertex[func][k].y) + this.surfaceVertex[func][k].y, 10.0f);
                                } else if (lastz < this.zmin) {
                                    ratio = (this.zmin - z) / (lastz - z);
                                    lastproj = this.projector.project(ratio * (lx - this.surfaceVertex[func][k].x) + this.surfaceVertex[func][k].x, ratio * (ly - this.surfaceVertex[func][k].y) + this.surfaceVertex[func][k].y, -10.0f);
                                }
                            } else {
                                invalid = error && lasterror;
                            }
                        } else {
                            error = true;
                        }
                        if (!invalid && i != 0) {
                            this.graphics.drawLine(lastproj.x, lastproj.y, this.projection.x, this.projection.y);
                        }
                        lastproj = this.projection;
                        lasterror = error;
                        lx = this.surfaceVertex[func][k].x;
                        ly = this.surfaceVertex[func][k].y;
                        lastz = z;
                        ++i;
                        k += this.calc_divisions + 1;
                    }
                }
                i = 0;
                k = ++j;
                counter = (counter + 1) % multiple_factor;
            }
        }
        if (this.isBoxed) {
            this.drawBoundingBox();
        }
    }

    class JSurfaceChangesListener
    implements PropertyChangeListener,
    ChangeListener {
        JSurfaceChangesListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JSurface.this.destroyImage();
        }

        public void propertyChange(PropertyChangeEvent pe) {
            JSurface.this.init();
            JSurface.this.destroyImage();
        }
    }

    class JSurfaceMouseListener
    extends MouseAdapter
    implements MouseMotionListener,
    MouseWheelListener {
        int i = 0;

        JSurfaceMouseListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            float new_value = 0.0f;
            float old_value = JSurface.this.projector.get2DScaling();
            new_value = old_value * (1.0f - (float)(e.getScrollAmount() * e.getWheelRotation()) / 10.0f);
            if (new_value > 60.0f) {
                new_value = 60.0f;
            }
            if (new_value < 2.0f) {
                new_value = 2.0f;
            }
            if (new_value != old_value) {
                JSurface.this.projector.set2DScaling(new_value);
                JSurface.this.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            JSurface.this.click_x = x;
            JSurface.this.click_y = y;
        }

        public void mouseReleased(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (!JSurface.this.is3D()) {
                return;
            }
            if (JSurface.this.model.isExpectDelay() && JSurface.this.dragged) {
                JSurface.this.destroyImage();
                JSurface.this.data_available = JSurface.this.is_data_available;
                JSurface.this.repaint();
                JSurface.this.dragged = false;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            float new_value = 0.0f;
            if (!JSurface.this.is3D()) {
                return;
            }
            if (e.isControlDown()) {
                JSurface.this.projector.set2D_xTranslation(JSurface.this.projector.get2D_xTranslation() + (x - JSurface.this.click_x));
                JSurface.this.projector.set2D_yTranslation(JSurface.this.projector.get2D_yTranslation() + (y - JSurface.this.click_y));
            } else if (e.isShiftDown()) {
                new_value = JSurface.this.projector.get2DScaling() + (float)(y - JSurface.this.click_y) * 0.5f;
                if (new_value > 60.0f) {
                    new_value = 60.0f;
                }
                if (new_value < 2.0f) {
                    new_value = 2.0f;
                }
                JSurface.this.projector.set2DScaling(new_value);
            } else {
                for (new_value = JSurface.this.projector.getRotationAngle() + (float)(x - JSurface.this.click_x); new_value > 360.0f; new_value -= 360.0f) {
                }
                while (new_value < 0.0f) {
                    new_value += 360.0f;
                }
                JSurface.this.projector.setRotationAngle(new_value);
                new_value = JSurface.this.projector.getElevationAngle() + (float)(y - JSurface.this.click_y);
                if (new_value > 90.0f) {
                    new_value = 90.0f;
                } else if (new_value < 0.0f) {
                    new_value = 0.0f;
                }
                JSurface.this.projector.setElevationAngle(new_value);
            }
            if (!JSurface.this.model.isExpectDelay()) {
                JSurface.this.repaint();
            } else {
                if (!JSurface.this.dragged) {
                    JSurface.this.is_data_available = JSurface.this.data_available;
                    JSurface.this.dragged = true;
                }
                JSurface.this.data_available = false;
                JSurface.this.repaint();
            }
            JSurface.this.click_x = x;
            JSurface.this.click_y = y;
        }
    }
}

