/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter.beans;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import net.ericaro.surfaceplotter.beans.ModelBindedBeanProperty;
import net.ericaro.surfaceplotter.beans.ModelSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JEnumComboBox<T extends Enum<T>>
extends JComboBox {
    ModelBindedBeanProperty<T> property = new ModelBindedBeanProperty<T>("surfaceModel"){

        @Override
        protected void onPropertyChanged(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            if (newValue != null) {
                JEnumComboBox.this.setSelectedItem((Enum)newValue);
            }
        }
    };

    public JEnumComboBox(T[] values, String property) {
        super(values);
        this.property.setPropertyName(property);
        this.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(JEnumComboBox.this.getEnumLabel((Enum)value));
                return c;
            }
        });
    }

    protected abstract String getEnumLabel(T var1);

    @Override
    protected void fireItemStateChanged(ItemEvent e) {
        Enum old = (Enum)this.property.getProperty();
        if (old != null && !old.equals(e.getItem())) {
            this.property.setProperty((Enum)e.getItem());
        }
        super.fireItemStateChanged(e);
    }

    public T getProperty() {
        return (T)((Enum)this.property.getProperty());
    }

    public void setProperty(T value) {
        this.property.setProperty(value);
    }

    public ModelSource getSourceBean() {
        return this.property.getSourceBean();
    }

    public void setSourceBean(ModelSource modelSource) {
        this.property.setSourceBean(modelSource);
    }
}

