/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.java.ao.Common;
import net.java.ao.EntityManager;
import net.java.ao.Polymorphic;
import net.java.ao.RawEntity;
import net.java.ao.ReadOnlyEntityProxy;
import net.java.ao.schema.FieldNameConverter;

public class ReadOnlyEntityProxyFactory<T extends RawEntity<K>, K> {
    private final EntityManager entityManager;
    private final Class<T> type;
    private final Set<Method> accessors;
    private final Map<Method, String> fieldNames;
    private final Map<String, String> polymorphicFieldNames;
    private final Map<String, Class<?>> returnTypes;

    public ReadOnlyEntityProxyFactory(EntityManager entityManager, Class<T> type) {
        this.entityManager = entityManager;
        this.type = type;
        FieldNameConverter fieldNameConverter = entityManager.getNameConverters().getFieldNameConverter();
        HashSet types = new HashSet();
        this.readTypeHierarchy(types, type);
        HashSet<Method> accessors = new HashSet<Method>();
        HashMap<Method, String> fieldNames = new HashMap<Method, String>();
        HashMap<String, String> polymorphicFieldNames = new HashMap<String, String>();
        HashMap returnTypes = new HashMap();
        for (Class clazz : types) {
            for (Method method : clazz.getDeclaredMethods()) {
                String fieldName;
                if (!Common.isAccessor(method) || (fieldName = fieldNameConverter.getName(method)) == null) continue;
                fieldNames.put(method, fieldName);
                accessors.add(method);
                Class<?> attributeType = Common.getAttributeTypeFromMethod(method);
                if (attributeType != null) {
                    String polyFieldName = attributeType.getAnnotation(Polymorphic.class) == null ? null : fieldNameConverter.getPolyTypeName(method);
                    polymorphicFieldNames.put(fieldName, polyFieldName);
                }
                returnTypes.put(fieldName, method.getReturnType());
            }
        }
        this.accessors = Collections.unmodifiableSet(accessors);
        this.fieldNames = Collections.unmodifiableMap(fieldNames);
        this.polymorphicFieldNames = Collections.unmodifiableMap(polymorphicFieldNames);
        this.returnTypes = Collections.unmodifiableMap(returnTypes);
    }

    private void readTypeHierarchy(Set<Class<?>> types, Class<?> type) {
        types.add(type);
        for (Class<?> superType : type.getInterfaces()) {
            this.readTypeHierarchy(types, superType);
        }
    }

    public ReadOnlyEntityProxy<T, K> build(K primaryKey) {
        return new ReadOnlyEntityProxy<T, K>(this.entityManager, this.type, primaryKey, this.fieldNames, this.polymorphicFieldNames, this.returnTypes, this.accessors);
    }
}

