/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.benchmark;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.RawEntity;
import net.java.ao.benchmark.BenchmarkDatabaseUpdater;
import net.java.ao.benchmark.model.Person;
import net.java.ao.benchmark.model.PersonWithPreload;
import net.java.ao.benchmark.util.Report;
import net.java.ao.benchmark.util.ReportPrinter;
import net.java.ao.benchmark.util.StopWatch;
import net.java.ao.benchmark.util.WikiReportPrinter;
import net.java.ao.test.ActiveObjectsIntegrationTest;
import net.java.ao.test.converters.NameConverters;
import net.java.ao.test.converters.UpperCaseFieldNameConverter;
import net.java.ao.test.converters.UpperCaseTableNameConverter;
import net.java.ao.test.jdbc.Data;
import net.java.ao.test.jdbc.NonTransactional;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@Data(value=BenchmarkDatabaseUpdater.class)
@NameConverters(table=UpperCaseTableNameConverter.class, field=UpperCaseFieldNameConverter.class)
public final class Benchmark
extends ActiveObjectsIntegrationTest {
    private static final int NUMBER_OF_PERSONS = 10000;
    private final StopWatch<Integer> insertStopWatch = new StopWatch("Inserts");
    private final StopWatch<Integer> updateStopWatch = new StopWatch("Updates");
    private final StopWatch<Integer> findStopWatch = new StopWatch("Find");
    private final StopWatch<String> findLoopStopWatch = new StopWatch("Find loop");
    private final StopWatch<String> streamStopWatch = new StopWatch("Stream");
    private final StopWatch<Integer> deleteStopWatch = new StopWatch("Delete");

    @Before
    public void warmUp() {
        Objects.requireNonNull(this.entityManager, "entityManager can't be null");
    }

    @Test
    @NonTransactional
    public void runWithoutPreload() throws Exception {
        this.run(Person.class);
    }

    @Test
    @NonTransactional
    public void runWithPreload() throws Exception {
        this.run(PersonWithPreload.class);
    }

    private void run(Class<? extends Person> personClass) throws Exception {
        System.out.printf("*** %s : %s ***\n", personClass.getName(), 10000);
        for (int i = 0; i < 2; ++i) {
            List<Integer> pks = this.insertPersons(personClass);
            this.updatePersons(personClass, pks);
            this.streamPersons(personClass);
            Person[] all = this.findPersons(personClass);
            this.deletePersons(all);
        }
    }

    private int warmUpInsertPersons(Class<? extends Person> personClass) throws SQLException {
        int warmUpNumber = 10;
        for (int i = 0; i < 10; ++i) {
            this.insertPerson(personClass, i);
        }
        return 10;
    }

    private List<Integer> insertPersons(Class<? extends Person> personClass) throws SQLException {
        int warmUpNumber = this.warmUpInsertPersons(personClass);
        int lastInsertIndex = warmUpNumber + 10000;
        ArrayList<Integer> personsKey = new ArrayList<Integer>(10000);
        this.insertStopWatch.start();
        for (int i = warmUpNumber; i < lastInsertIndex; ++i) {
            personsKey.add(this.insertPerson(personClass, i));
        }
        this.insertStopWatch.stop();
        return personsKey;
    }

    private void updatePersons(Class<? extends Person> personClass, List<Integer> pks) throws SQLException {
        this.updateStopWatch.start();
        for (Integer i : pks) {
            this.updatePerson(personClass, i);
        }
        this.updateStopWatch.stop();
    }

    private <P extends Person> void streamPersons(Class<P> personClass) throws Exception {
        this.streamStopWatch.start();
        this.entityManager.stream(personClass, new EntityStreamCallback<P, Integer>(){

            public void onRowRead(P person) {
                Benchmark.this.streamStopWatch.lap(person.getID() + "-" + person.getFirstName() + "-" + person.getLastName());
            }
        });
        this.streamStopWatch.stop();
    }

    private <P extends Person> P[] findPersons(Class<P> personClass) throws Exception {
        this.findStopWatch.start();
        Person[] all = (Person[])this.entityManager.find(personClass);
        this.findStopWatch.stop();
        this.findLoopStopWatch.start();
        for (Person person : all) {
            this.findLoopStopWatch.lap(person.getID() + "-" + person.getFirstName() + "-" + person.getLastName());
        }
        this.findLoopStopWatch.stop();
        return all;
    }

    private <P extends Person> void deletePersons(P[] persons) throws Exception {
        this.deleteStopWatch.start();
        for (P person : persons) {
            this.entityManager.delete(new RawEntity[]{person});
            this.deleteStopWatch.lap(person.getID());
        }
        this.deleteStopWatch.stop();
    }

    private <P extends Person> int insertPerson(Class<P> personClass, int i) throws SQLException {
        Person p = (Person)this.entityManager.create(personClass, new DBParam[0]);
        p.setFirstName("firstName " + i);
        p.setLastName("lastName" + i);
        p.save();
        this.insertStopWatch.lap(i);
        return p.getID();
    }

    private void updatePerson(Class<? extends Person> personClass, int i) throws SQLException {
        Person p = (Person)this.entityManager.get(personClass, (Object)i);
        p.setFirstName(p.getFirstName() + "#updated");
        p.setLastName(p.getLastName() + "#updated");
        this.updateStopWatch.lap(i);
    }

    @After
    public void results() {
        ReportPrinter printer = Benchmark.newReportPrinter();
        printer.print(Benchmark.newReport(this.insertStopWatch));
        printer.print(Benchmark.newReport(this.updateStopWatch));
        printer.print(Benchmark.newReport(this.streamStopWatch));
        printer.print(Benchmark.newReport(this.findStopWatch));
        printer.print(Benchmark.newReport(this.findLoopStopWatch));
        printer.print(Benchmark.newReport(this.deleteStopWatch));
        System.out.println();
    }

    private static ReportPrinter newReportPrinter() {
        return new WikiReportPrinter();
    }

    private static Report newReport(StopWatch<?> stopWatch) {
        return stopWatch.getReport();
    }
}

