/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.Callable;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.db.OracleDatabaseProvider;
import net.java.ao.sql.SqlUtils;
import net.java.ao.test.SqlTracker;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbUtils {
    private static final Logger logger = LoggerFactory.getLogger(DbUtils.class);

    public static boolean isOracle(EntityManager em) {
        return em.getProvider() instanceof OracleDatabaseProvider;
    }

    public static <T> T checkSqlExecuted(EntityManager em, Callable<T> callable) throws Exception {
        return DbUtils.checkSql(em, true, callable);
    }

    public static <T> T checkSqlNotExecuted(EntityManager em, Callable<T> callable) throws Exception {
        return DbUtils.checkSql(em, false, callable);
    }

    public static <E extends RawEntity<?>> E checkSqlExecutedWhenSaving(EntityManager em, final E entity) throws Exception {
        return (E)((RawEntity)DbUtils.checkSqlExecuted(em, new Callable<E>(){

            @Override
            public E call() throws Exception {
                entity.save();
                return entity;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeUpdate(EntityManager em, String sql, UpdateCallback callback) throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = em.getProvider().getConnection();
            statement = connection.prepareStatement(sql);
            callback.setParameters(statement);
            statement.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(statement, (Connection)connection);
            throw throwable;
        }
        SqlUtils.closeQuietly((Statement)statement, (Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeStatement(EntityManager em, String sql, StatementCallback callback) throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = em.getProvider().getConnection();
            statement = connection.prepareStatement(sql);
            logger.debug(sql);
            callback.setParameters(statement);
            resultSet = statement.executeQuery();
            callback.processResult(resultSet);
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(resultSet, statement, (Connection)connection);
            throw throwable;
        }
        SqlUtils.closeQuietly((ResultSet)resultSet, (Statement)statement, (Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T checkSql(EntityManager em, boolean executed, Callable<T> callable) throws Exception {
        DatabaseProvider provider = em.getProvider();
        SqlTracker sqlTracker = new SqlTracker();
        try {
            provider.addSqlListener((DatabaseProvider.SqlListener)sqlTracker);
            T t = callable.call();
            Assert.assertEquals((Object)executed, (Object)sqlTracker.isSqlExecuted());
            T t2 = t;
            return t2;
        }
        finally {
            provider.removeSqlListener((DatabaseProvider.SqlListener)sqlTracker);
        }
    }

    public static abstract class UpdateCallback
    implements StatementCallback {
        @Override
        public final void processResult(ResultSet resultSet) throws Exception {
        }
    }

    public static interface StatementCallback {
        public void setParameters(PreparedStatement var1) throws Exception;

        public void processResult(ResultSet var1) throws Exception;
    }
}

