/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import com.google.common.io.Files;
import java.io.File;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.java.ao.test.jdbc.AbstractJdbcConfiguration;
import org.h2.tools.Server;

public class H2Server
extends AbstractJdbcConfiguration {
    private static final File TEMP_DIR = Files.createTempDir();
    private static final String DEFAULT_URL = "jdbc:h2:tcp://localhost/" + TEMP_DIR + "/ao-test;MVCC=TRUE";
    private static final String DEFAULT_USER = "";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_SCHEMA = "PUBLIC";
    private static Server h2Server;
    private static Lock h2ServerLock;

    public H2Server() {
        this(DEFAULT_URL, "", "", DEFAULT_SCHEMA);
    }

    public H2Server(String url, String username, String password, String schema) {
        super(url, username, password, schema);
    }

    @Override
    protected String getDefaultUsername() {
        return "";
    }

    @Override
    protected String getDefaultPassword() {
        return "";
    }

    @Override
    protected String getDefaultSchema() {
        return DEFAULT_SCHEMA;
    }

    @Override
    protected String getDefaultUrl() {
        return DEFAULT_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        block5: {
            h2ServerLock.lock();
            try {
                if (h2Server != null) break block5;
                try {
                    h2Server = Server.createTcpServer((String[])new String[0]).start();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                h2ServerLock.unlock();
            }
        }
    }

    static {
        h2ServerLock = new ReentrantLock();
    }
}

