/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.converters;

import com.google.common.base.Preconditions;
import net.java.ao.RawEntity;
import net.java.ao.schema.CanonicalClassNameTableNameConverter;
import net.java.ao.schema.Case;
import net.java.ao.schema.TableAnnotationTableNameConverter;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.UnderscoreTableNameConverter;
import net.java.ao.test.converters.Prefix;
import net.java.ao.test.converters.PrefixedTableNameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestTableNameConverter
implements TableNameConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TableNameConverter tableNameConverter;

    public TestTableNameConverter(Prefix prefix) {
        UnderscoreTableNameConverter baseConverter = new UnderscoreTableNameConverter(Case.UPPER);
        this.tableNameConverter = new PrefixedTableNameConverter((Prefix)Preconditions.checkNotNull((Object)prefix), (TableNameConverter)new TableAnnotationTableNameConverter((TableNameConverter)baseConverter, (CanonicalClassNameTableNameConverter)baseConverter));
    }

    public String getName(Class<? extends RawEntity<?>> entityClass) {
        String name = this.tableNameConverter.getName(entityClass);
        this.logger.debug("Table name for '{}' is '{}'", (Object)entityClass.getName(), (Object)name);
        return name;
    }
}

