/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import com.google.common.io.Files;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.java.ao.test.jdbc.H2;
import org.h2.tools.Server;

public class H2Server
extends H2 {
    private static final File TEMP_DIR = Files.createTempDir();
    private static final String DEFAULT_URL = H2Server.makeDefaultUrl();
    private static Server h2Server;
    private static Lock h2ServerLock;

    private static String makeDefaultUrl() {
        StringBuilder url = new StringBuilder("jdbc:h2:tcp:");
        url.append("//localhost/").append(TEMP_DIR).append("/ao-test");
        if (H2Server.h2VersionCompareTo(2, 1, 200) >= 0) {
            url.append(";MODE=LEGACY");
        }
        H2Server.appendDriverSettings(url);
        return url.toString();
    }

    public H2Server() {
        super(DEFAULT_URL);
    }

    public H2Server(String url, String username, String password, String schema) {
        super(url, username, password, schema);
    }

    @Override
    protected String getDefaultUrl() {
        return DEFAULT_URL;
    }

    @Override
    public void init() {
        block5: {
            h2ServerLock.lock();
            try {
                if (h2Server != null) break block5;
                try {
                    h2Server = Server.createTcpServer((String[])H2Server.getTcpServerParams()).start();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                h2ServerLock.unlock();
            }
        }
    }

    private static String[] getTcpServerParams() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("-baseDir");
        params.add(TEMP_DIR.getPath());
        if (H2Server.h2VersionCompareTo(1, 4, 198) >= 0) {
            params.add("-ifNotExists");
        }
        return params.toArray(new String[0]);
    }

    static {
        h2ServerLock = new ReentrantLock();
    }
}

