/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs.model;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsHeader;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.model.Data;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.NoteWithPanning;
import net.raphimc.noteblocklib.model.NoteWithVolume;
import net.raphimc.noteblocklib.model.SongView;
import net.raphimc.noteblocklib.util.SongUtil;

public class NbsData
implements Data<NbsNote> {
    private List<NbsLayer> layers;
    private List<NbsCustomInstrument> customInstruments;

    public NbsData(NbsHeader header, LittleEndianDataInputStream dis) throws IOException {
        short jumpTicks;
        this.layers = new ArrayList<NbsLayer>(header.getLayerCount());
        this.customInstruments = new ArrayList<NbsCustomInstrument>();
        for (int i = 0; i < header.getLayerCount(); ++i) {
            this.layers.add(new NbsLayer());
        }
        int tick = -1;
        while ((jumpTicks = dis.readShort()) != 0) {
            short jumpLayers;
            tick += jumpTicks;
            int layer = -1;
            while ((jumpLayers = dis.readShort()) != 0) {
                layer += jumpLayers;
                while (this.layers.size() <= layer) {
                    this.layers.add(new NbsLayer());
                }
                this.layers.get(layer).getNotesAtTick().put(tick, new NbsNote(header, this.layers.get(layer), dis));
            }
        }
        if (dis.available() > 0) {
            for (int i = 0; i < header.getLayerCount(); ++i) {
                NbsLayer layer = new NbsLayer(header, dis);
                layer.setNotesAtTick(this.layers.get(i).getNotesAtTick());
                this.layers.set(i, layer);
                for (NbsNote note : layer.getNotesAtTick().values()) {
                    note.setLayer(layer);
                }
            }
        }
        if (dis.available() > 0) {
            int customInstrumentsAmount = dis.readUnsignedByte();
            for (int i = 0; i < customInstrumentsAmount; ++i) {
                this.customInstruments.add(new NbsCustomInstrument(dis));
            }
            for (NbsLayer layer : this.layers) {
                for (NbsNote note : layer.getNotesAtTick().values()) {
                    note.resolveCustomInstrument(header, this);
                }
            }
        }
    }

    public NbsData(List<NbsLayer> layers, List<NbsCustomInstrument> customInstruments) {
        this.layers = layers;
        this.customInstruments = customInstruments;
    }

    public <N extends Note> NbsData(SongView<N> songView) {
        this.layers = new ArrayList<NbsLayer>();
        this.customInstruments = new ArrayList<NbsCustomInstrument>();
        for (Map.Entry<Integer, List<N>> entry : songView.getNotes().entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                NbsLayer layer;
                Note note = (Note)entry.getValue().get(i);
                if (this.layers.size() <= i) {
                    layer = new NbsLayer();
                    this.layers.add(layer);
                } else {
                    layer = this.layers.get(i);
                }
                if (note instanceof NbsNote) {
                    NbsNote clonedNote = (NbsNote)note.clone();
                    clonedNote.setLayer(layer);
                    layer.getNotesAtTick().put(entry.getKey(), clonedNote);
                    continue;
                }
                NbsNote nbsNote = new NbsNote(layer, note.getInstrument(), note.getKey());
                if (note instanceof NoteWithVolume) {
                    NoteWithVolume noteWithVolume = (NoteWithVolume)((Object)note);
                    nbsNote.setVolume(noteWithVolume.getVolume());
                }
                if (note instanceof NoteWithPanning) {
                    NoteWithPanning noteWithPanning = (NoteWithPanning)((Object)note);
                    nbsNote.setPanning(noteWithPanning.getPanning());
                }
                layer.getNotesAtTick().put(entry.getKey(), nbsNote);
            }
        }
        this.customInstruments.addAll(SongUtil.getUsedCustomInstruments(songView));
    }

    /*
     * WARNING - void declaration
     */
    public void write(NbsHeader header, LittleEndianDataOutputStream dos) throws IOException {
        void var5_9;
        TreeMap<Integer, List> notes = new TreeMap<Integer, List>();
        for (NbsLayer nbsLayer : this.layers) {
            for (Map.Entry<Integer, NbsNote> note : nbsLayer.getNotesAtTick().entrySet()) {
                notes.computeIfAbsent(note.getKey(), k -> new ArrayList()).add(note.getValue());
            }
        }
        int lastTick = -1;
        for (Map.Entry entry : notes.entrySet()) {
            dos.writeShort((Integer)entry.getKey() - lastTick);
            lastTick = (Integer)entry.getKey();
            int lastLayer = -1;
            for (NbsNote note : (List)entry.getValue()) {
                if (!this.layers.contains(note.getLayer())) {
                    throw new IllegalArgumentException("Note layer not found in NbsData layers list");
                }
                dos.writeShort(this.layers.indexOf(note.getLayer()) - lastLayer);
                lastLayer = this.layers.indexOf(note.getLayer());
                note.write(header, this, dos);
            }
            dos.writeShort(0);
        }
        dos.writeShort(0);
        boolean bl = false;
        while (var5_9 < header.getLayerCount()) {
            this.layers.get((int)var5_9).write(header, dos);
            ++var5_9;
        }
        dos.writeByte(this.customInstruments.size());
        for (NbsCustomInstrument nbsCustomInstrument : this.customInstruments) {
            nbsCustomInstrument.write(dos);
        }
    }

    public List<NbsLayer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<NbsLayer> layers) {
        this.layers = layers;
    }

    public List<NbsCustomInstrument> getCustomInstruments() {
        return this.customInstruments;
    }

    public void setCustomInstruments(List<NbsCustomInstrument> customInstruments) {
        this.customInstruments = customInstruments;
    }
}

