/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.rootdev.javardfa.Constants;
import net.rootdev.javardfa.EvalContext;
import net.rootdev.javardfa.IRIResolver;
import net.rootdev.javardfa.Resolver;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements ContentHandler {
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;
    private final XMLEventReader reader;
    private final StatementSink sink;
    private final Set<Setting> settings;
    private final Constants consts;
    private final Resolver resolver;
    int bnodeId = 0;
    private Locator locator;
    private EvalContext context = new EvalContext("http://www.example.com/");
    private List<XMLEvent> queuedEvents;
    private int level = -1;
    private XMLEventWriter xmlWriter;
    private StringWriter literalWriter;
    private String theDatatype;
    private List<String> litProps;

    public Parser(StatementSink sink) {
        this(sink, XMLOutputFactory.newInstance(), XMLEventFactory.newInstance(), new IRIResolver());
    }

    public Parser(StatementSink sink, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, Resolver resolver) {
        this.sink = sink;
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
        this.reader = null;
        this.settings = EnumSet.noneOf(Setting.class);
        this.consts = new Constants();
        this.resolver = resolver;
        outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }

    public void enable(Setting setting) {
        this.settings.add(setting);
    }

    public void disable(Setting setting) {
        this.settings.remove((Object)setting);
    }

    public void setBase(String base) {
        this.context = new EvalContext(base);
    }

    EvalContext parse(EvalContext context, StartElement element) throws XMLStreamException {
        Attribute nSubj;
        boolean recurse = true;
        boolean skipElement = false;
        String newSubject = null;
        String currentObject = null;
        LinkedList<String> forwardProperties = new LinkedList<String>(context.forwardProperties);
        LinkedList<String> backwardProperties = new LinkedList<String>(context.backwardProperties);
        String currentLanguage = context.language;
        boolean langIsLang = context.langIsLang;
        if (element.getAttributeByName(this.consts.xmllang) != null) {
            currentLanguage = element.getAttributeByName(this.consts.xmllang).getValue();
        }
        if (this.settings.contains((Object)Setting.ManualNamespaces) && element.getAttributeByName(this.consts.fakeXmlLang) != null && !langIsLang) {
            currentLanguage = element.getAttributeByName(this.consts.fakeXmlLang).getValue();
        }
        if (this.settings.contains((Object)Setting.ManualNamespaces) && element.getAttributeByName(this.consts.lang) != null) {
            langIsLang = true;
            currentLanguage = element.getAttributeByName(this.consts.lang).getValue();
        }
        if (this.consts.base.equals(element.getName()) && element.getAttributeByName(this.consts.href) != null) {
            context.setBase(element.getAttributeByName(this.consts.href).getValue());
        }
        if (element.getAttributeByName(this.consts.rev) == null && element.getAttributeByName(this.consts.rel) == null) {
            nSubj = this.findAttribute(element, this.consts.about, this.consts.src, this.consts.resource, this.consts.href);
            if (nSubj != null) {
                newSubject = this.getURI(context.base, element, nSubj);
            } else if (element.getAttributeByName(this.consts.typeof) != null) {
                newSubject = this.consts.body.equals(element.getName()) || this.consts.head.equals(element.getName()) ? context.base : this.createBNode();
            } else {
                if (context.parentObject != null) {
                    newSubject = context.parentObject;
                }
                if (element.getAttributeByName(this.consts.property) == null) {
                    skipElement = true;
                }
            }
        } else {
            nSubj = this.findAttribute(element, this.consts.about, this.consts.src);
            if (nSubj != null) {
                newSubject = this.getURI(context.base, element, nSubj);
            } else if (element.getAttributeByName(this.consts.typeof) != null) {
                newSubject = this.createBNode();
            } else if (context.parentObject != null) {
                newSubject = context.parentObject;
            }
            Attribute cObj = this.findAttribute(element, this.consts.resource, this.consts.href);
            if (cObj != null) {
                currentObject = this.getURI(context.base, element, cObj);
            }
        }
        if (newSubject != null && element.getAttributeByName(this.consts.typeof) != null) {
            List<String> types = this.getURIs(context.base, element, element.getAttributeByName(this.consts.typeof));
            for (String type : types) {
                this.emitTriples(newSubject, this.consts.rdfType, type);
            }
        }
        if (newSubject == null) {
            newSubject = context.parentSubject;
        }
        if (this.settings.contains((Object)Setting.FormMode)) {
            if (this.consts.form.equals(element.getName())) {
                this.emitTriples(newSubject, this.consts.rdfType, "http://www.w3.org/1999/xhtml/vocab/#form");
            }
            if (this.consts.input.equals(element.getName()) && element.getAttributeByName(this.consts.name) != null) {
                currentObject = "?" + element.getAttributeByName(this.consts.name).getValue();
            }
        }
        if (currentObject != null) {
            if (element.getAttributeByName(this.consts.rel) != null) {
                this.emitTriples(newSubject, this.getURIs(context.base, element, element.getAttributeByName(this.consts.rel)), currentObject);
            }
            if (element.getAttributeByName(this.consts.rev) != null) {
                this.emitTriples(currentObject, this.getURIs(context.base, element, element.getAttributeByName(this.consts.rev)), newSubject);
            }
        } else {
            if (element.getAttributeByName(this.consts.rel) != null) {
                forwardProperties.addAll(this.getURIs(context.base, element, element.getAttributeByName(this.consts.rel)));
            }
            if (element.getAttributeByName(this.consts.rev) != null) {
                backwardProperties.addAll(this.getURIs(context.base, element, element.getAttributeByName(this.consts.rev)));
            }
            if (element.getAttributeByName(this.consts.rel) != null || element.getAttributeByName(this.consts.rev) != null) {
                currentObject = this.createBNode();
            }
        }
        if (element.getAttributeByName(this.consts.property) != null) {
            List<String> props = this.getURIs(context.base, element, element.getAttributeByName(this.consts.property));
            String dt = this.getDatatype(element);
            if (element.getAttributeByName(this.consts.content) != null) {
                String lex = element.getAttributeByName(this.consts.content).getValue();
                if (dt == null || dt.length() == 0) {
                    this.emitTriplesPlainLiteral(newSubject, props, lex, currentLanguage);
                } else {
                    this.emitTriplesDatatypeLiteral(newSubject, props, lex, dt);
                }
            } else {
                this.level = 1;
                this.theDatatype = dt;
                this.literalWriter = new StringWriter();
                this.litProps = props;
                if (dt == null) {
                    this.queuedEvents = new LinkedList<XMLEvent>();
                } else if (this.consts.xmlLiteral.equals(dt)) {
                    this.xmlWriter = this.outputFactory.createXMLEventWriter(this.literalWriter);
                }
            }
        }
        if (!skipElement && newSubject != null) {
            this.emitTriples(context.parentSubject, context.forwardProperties, newSubject);
            this.emitTriples(newSubject, context.backwardProperties, context.parentSubject);
        }
        if (recurse) {
            EvalContext ec = new EvalContext(context);
            if (skipElement) {
                ec.language = currentLanguage;
                ec.langIsLang = langIsLang;
                ec.original = context.original;
            } else {
                ec.parentSubject = newSubject != null ? newSubject : context.parentSubject;
                ec.parentObject = currentObject != null ? currentObject : (newSubject != null ? newSubject : context.parentSubject);
                ec.language = currentLanguage;
                ec.langIsLang = langIsLang;
                ec.forwardProperties = forwardProperties;
                ec.backwardProperties = backwardProperties;
            }
            return ec;
        }
        return null;
    }

    private Attribute findAttribute(StartElement element, QName ... names) {
        for (QName aName : names) {
            Attribute a = element.getAttributeByName(aName);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    private void emitTriples(String subj, Collection<String> props, String obj) {
        for (String prop : props) {
            this.sink.addObject(subj, prop, obj);
        }
    }

    private void emitTriplesPlainLiteral(String subj, Collection<String> props, String lex, String language) {
        for (String prop : props) {
            this.sink.addLiteral(subj, prop, lex, language, null);
        }
    }

    private void emitTriplesDatatypeLiteral(String subj, Collection<String> props, String lex, String datatype) {
        for (String prop : props) {
            this.sink.addLiteral(subj, prop, lex, null, datatype);
        }
    }

    private String createBNode() {
        return "_:node" + this.bnodeId++;
    }

    private String getDatatype(StartElement element) {
        Attribute de = element.getAttributeByName(this.consts.datatype);
        if (de == null) {
            return null;
        }
        String dt = de.getValue();
        if (dt.length() == 0) {
            return dt;
        }
        return this.expandCURIE(element, dt);
    }

    private void getNamespaces(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            String prefix = this.getPrefix(qname);
            if (!"xmlns".equals(prefix)) continue;
            String pre = this.getLocal(prefix, qname);
            String uri = attrs.getValue(i);
            this.context.setNamespaceURI(pre, uri);
            this.sink.addPrefix(pre, uri);
        }
    }

    private String getPrefix(String qname) {
        if (!qname.contains(":")) {
            return "";
        }
        return qname.substring(0, qname.indexOf(":"));
    }

    private String getLocal(String prefix, String qname) {
        if (prefix.length() == 0) {
            return qname;
        }
        return qname.substring(prefix.length() + 1);
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
    }

    @Override
    public void startDocument() throws SAXException {
        this.sink.start();
    }

    @Override
    public void endDocument() throws SAXException {
        this.sink.end();
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.context.setNamespaceURI(arg0, arg1);
        this.sink.addPrefix(arg0, arg1);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void startElement(String arg0, String localname, String qname, Attributes arg3) throws SAXException {
        try {
            String prefix;
            String string = prefix = localname.equals(qname) ? "" : qname.substring(0, qname.indexOf(58));
            if (this.settings.contains((Object)Setting.ManualNamespaces)) {
                this.getNamespaces(arg3);
            }
            StartElement e = this.eventFactory.createStartElement(prefix, arg0, localname, this.fromAttributes(arg3), null, this.context);
            if (this.level != -1) {
                this.handleForLiteral(e);
                return;
            }
            this.context = this.parse(this.context, e);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Streaming issue", ex);
        }
    }

    @Override
    public void endElement(String arg0, String localname, String qname) throws SAXException {
        if (this.level != -1) {
            String prefix = localname.equals(qname) ? "" : qname.substring(0, qname.indexOf(58));
            EndElement e = this.eventFactory.createEndElement(prefix, arg0, localname);
            this.handleForLiteral(e);
            if (this.level != -1) {
                return;
            }
        }
        this.context = this.context.parent;
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.level != -1) {
            Characters e = this.eventFactory.createCharacters(String.valueOf(arg0, arg1, arg2));
            this.handleForLiteral(e);
            return;
        }
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.level != -1) {
            Characters e = this.eventFactory.createIgnorableSpace(String.valueOf(arg0, arg1, arg2));
            this.handleForLiteral(e);
        }
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    private Iterator fromAttributes(Attributes attributes) {
        LinkedList<Attribute> toReturn = new LinkedList<Attribute>();
        boolean haveLang = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            String prefix = qname.contains(":") ? qname.substring(0, qname.indexOf(":")) : "";
            Attribute attr = this.eventFactory.createAttribute(prefix, attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            if (this.consts.xmllang.getLocalPart().equals(attributes.getLocalName(i)) && this.consts.xmllang.getNamespaceURI().equals(attributes.getURI(i))) {
                haveLang = true;
            }
            toReturn.add(attr);
        }
        if (this.level == 1 && this.context.language != null && !haveLang) {
            toReturn.add(this.eventFactory.createAttribute(this.consts.xmllang, this.context.language));
        }
        return toReturn.iterator();
    }

    private void handleForLiteral(XMLEvent e) {
        try {
            this.handleForLiteralEx(e);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Literal handling error", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Literal handling error", ex);
        }
    }

    private void handleForLiteralEx(XMLEvent e) throws XMLStreamException, IOException {
        if (e.isStartElement()) {
            ++this.level;
            if (this.queuedEvents != null) {
                this.xmlWriter = this.outputFactory.createXMLEventWriter(this.literalWriter);
                for (XMLEvent ev : this.queuedEvents) {
                    this.xmlWriter.add(ev);
                }
                this.queuedEvents = null;
                this.theDatatype = this.consts.xmlLiteral;
            }
        }
        if (e.isEndElement()) {
            --this.level;
            if (this.level == 0) {
                if (this.xmlWriter != null) {
                    this.xmlWriter.close();
                } else if (this.queuedEvents != null) {
                    for (XMLEvent ev : this.queuedEvents) {
                        this.literalWriter.append(ev.asCharacters().getData());
                    }
                }
                String lex = this.literalWriter.toString();
                if (this.theDatatype == null || this.theDatatype.length() == 0) {
                    this.emitTriplesPlainLiteral(this.context.parentSubject, this.litProps, lex, this.context.language);
                } else {
                    this.emitTriplesDatatypeLiteral(this.context.parentSubject, this.litProps, lex, this.theDatatype);
                }
                this.queuedEvents = null;
                this.xmlWriter = null;
                this.literalWriter = null;
                this.theDatatype = null;
                this.litProps = null;
                this.level = -1;
                return;
            }
        }
        if (this.xmlWriter != null) {
            this.xmlWriter.add(e);
        } else if (e.isCharacters() && this.queuedEvents != null) {
            this.queuedEvents.add(e);
        } else if (e.isCharacters()) {
            this.literalWriter.append(e.asCharacters().getData());
        }
    }

    public String getURI(String base, StartElement element, Attribute attr) {
        QName attrName = attr.getName();
        if (attrName.equals(this.consts.href) || attrName.equals(this.consts.src)) {
            if (attr.getValue().length() == 0) {
                return base;
            }
            return this.resolver.resolve(base, attr.getValue());
        }
        if (attrName.equals(this.consts.about) || attrName.equals(this.consts.resource)) {
            return this.expandSafeCURIE(base, element, attr.getValue());
        }
        if (attrName.equals(this.consts.datatype)) {
            return this.expandCURIE(element, attr.getValue());
        }
        throw new RuntimeException("Unexpected attribute: " + attr);
    }

    public List<String> getURIs(String base, StartElement element, Attribute attr) {
        LinkedList<String> uris = new LinkedList<String>();
        String[] curies = attr.getValue().split("\\s+");
        boolean permitReserved = this.consts.rel.equals(attr.getName()) || this.consts.rev.equals(attr.getName());
        for (String curie : curies) {
            String uri;
            boolean isSpecial;
            boolean bl = isSpecial = this.settings.contains((Object)Setting.ManualNamespaces) ? this.consts.SpecialRels.contains(curie.toLowerCase()) : this.consts.SpecialRels.contains(curie);
            if (isSpecial && this.settings.contains((Object)Setting.ManualNamespaces)) {
                curie = curie.toLowerCase();
            }
            if (permitReserved && isSpecial) {
                uris.add("http://www.w3.org/1999/xhtml/vocab#" + curie);
                continue;
            }
            if (isSpecial || (uri = this.expandCURIE(element, curie)) == null) continue;
            uris.add(uri);
        }
        return uris;
    }

    public String expandCURIE(StartElement element, String value) {
        String namespaceURI;
        if (value.startsWith("_:") && element.getNamespaceURI("_") == null) {
            return value;
        }
        if (this.settings.contains((Object)Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        int offset = value.indexOf(":") + 1;
        if (offset == 0) {
            return null;
        }
        String prefix = value.substring(0, offset - 1);
        String string = namespaceURI = prefix.length() == 0 ? "http://www.w3.org/1999/xhtml/vocab#" : element.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            return null;
        }
        if (offset != value.length() && value.charAt(offset) == '#') {
            ++offset;
        }
        if (namespaceURI.endsWith("/") || namespaceURI.endsWith("#")) {
            return namespaceURI + value.substring(offset);
        }
        return namespaceURI + "#" + value.substring(offset);
    }

    public String expandSafeCURIE(String base, StartElement element, String value) {
        if (value.startsWith("[") && value.endsWith("]")) {
            return this.expandCURIE(element, value.substring(1, value.length() - 1));
        }
        if (value.length() == 0) {
            return base;
        }
        if (this.settings.contains((Object)Setting.FormMode) && value.startsWith("?")) {
            return value;
        }
        return this.resolver.resolve(base, value);
    }
}

