/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.io.Serializable;
import nl.crashdata.chartjs.data.ChartJsChartType;
import nl.crashdata.chartjs.data.simple.SimpleChartJsConfig;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsDataBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsOptionsBuilder;

public class SimpleChartJsConfigBuilder<K extends Serializable, V extends Serializable>
implements SimpleChartJsBuilder<SimpleChartJsConfig<K, V>> {
    private ChartJsChartType type;
    private SimpleChartJsDataBuilder<K, V> dataBuilder = new SimpleChartJsDataBuilder();
    private SimpleChartJsOptionsBuilder<K, V> optionsBuilder = new SimpleChartJsOptionsBuilder();

    public static <K extends Serializable, V extends Serializable> SimpleChartJsConfigBuilder<K, V> lineChart() {
        return super.withType(ChartJsChartType.LINE);
    }

    public static <K extends Serializable, V extends Serializable> SimpleChartJsConfigBuilder<K, V> barChart() {
        return super.withType(ChartJsChartType.BAR);
    }

    public static <K extends Serializable, V extends Serializable> SimpleChartJsConfigBuilder<K, V> pieChart() {
        return super.withType(ChartJsChartType.PIE);
    }

    public static <K extends Serializable, V extends Serializable> SimpleChartJsConfigBuilder<K, V> radarChart() {
        return super.withType(ChartJsChartType.RADAR);
    }

    public static <K extends Serializable, V extends Serializable> SimpleChartJsConfigBuilder<K, V> scatterPlot() {
        return super.withType(ChartJsChartType.SCATTER);
    }

    public static <K extends Serializable, V extends Serializable> SimpleChartJsConfigBuilder<K, V> bubbleChart() {
        return super.withType(ChartJsChartType.BUBBLE);
    }

    public static <K extends Serializable, V extends Serializable> SimpleChartJsConfigBuilder<K, V> polarAreaChart() {
        return super.withType(ChartJsChartType.POLAR_AREA);
    }

    private SimpleChartJsConfigBuilder() {
    }

    private SimpleChartJsConfigBuilder<K, V> withType(ChartJsChartType type) {
        this.type = type;
        return this;
    }

    public SimpleChartJsDataBuilder<K, V> data() {
        return this.dataBuilder;
    }

    public SimpleChartJsOptionsBuilder<K, V> options() {
        return this.optionsBuilder;
    }

    @Override
    public boolean isValid() {
        return this.type != null && this.dataBuilder.isValid() && this.optionsBuilder.isValid();
    }

    @Override
    public SimpleChartJsConfig<K, V> build() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsConfig ret = new SimpleChartJsConfig();
        ret.setChartType(this.type);
        ret.setData(this.dataBuilder.build());
        ret.setOptions(this.optionsBuilder.build());
        return ret;
    }
}

