/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.io.Serializable;
import nl.crashdata.chartjs.data.ChartJsChartType;
import nl.crashdata.chartjs.data.simple.SimpleChartJsConfig;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsDataBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsOptionsBuilder;

public class SimpleChartJsConfigBuilder<E extends Serializable>
implements SimpleChartJsBuilder<SimpleChartJsConfig<E>> {
    private ChartJsChartType type;
    private SimpleChartJsOptionsBuilder optionsBuilder = new SimpleChartJsOptionsBuilder();
    private SimpleChartJsDataBuilder<E> dataBuilder = new SimpleChartJsDataBuilder();

    public static <E extends Serializable> SimpleChartJsConfigBuilder<E> lineChart() {
        return new SimpleChartJsConfigBuilder<E>().withType(ChartJsChartType.LINE);
    }

    public static <E extends Serializable> SimpleChartJsConfigBuilder<E> barChart() {
        return new SimpleChartJsConfigBuilder<E>().withType(ChartJsChartType.BAR);
    }

    public static <E extends Serializable> SimpleChartJsConfigBuilder<E> pieChart() {
        return new SimpleChartJsConfigBuilder<E>().withType(ChartJsChartType.PIE);
    }

    public static <E extends Serializable> SimpleChartJsConfigBuilder<E> radarChart() {
        return new SimpleChartJsConfigBuilder<E>().withType(ChartJsChartType.RADAR);
    }

    public static <E extends Serializable> SimpleChartJsConfigBuilder<E> scatterPlot() {
        return new SimpleChartJsConfigBuilder<E>().withType(ChartJsChartType.SCATTER);
    }

    public static <E extends Serializable> SimpleChartJsConfigBuilder<E> bubbleChart() {
        return new SimpleChartJsConfigBuilder<E>().withType(ChartJsChartType.BUBBLE);
    }

    public static <E extends Serializable> SimpleChartJsConfigBuilder<E> polarAreaChart() {
        return new SimpleChartJsConfigBuilder<E>().withType(ChartJsChartType.POLAR_AREA);
    }

    public static <E extends Serializable> SimpleChartJsConfigBuilder<E> doughnut() {
        return new SimpleChartJsConfigBuilder<E>().withType(ChartJsChartType.DOUGHNUT);
    }

    SimpleChartJsConfigBuilder() {
    }

    public SimpleChartJsConfigBuilder<E> withType(ChartJsChartType type) {
        this.type = type;
        return this;
    }

    public SimpleChartJsDataBuilder<E> data() {
        return this.dataBuilder;
    }

    public SimpleChartJsOptionsBuilder options() {
        return this.optionsBuilder;
    }

    @Override
    public boolean isValid() {
        return this.type != null && this.data().isValid() && this.optionsBuilder.isValid();
    }

    @Override
    public SimpleChartJsConfig<E> build() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsConfig ret = new SimpleChartJsConfig();
        ret.setChartType(this.type);
        ret.setData(this.data().build());
        ret.setOptions(this.optionsBuilder.build());
        return ret;
    }
}

