/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.crashdata.chartjs.data.ChartJsScalesConfig;
import nl.crashdata.chartjs.data.simple.SimpleChartJsOptions;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsHoverConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsLegendConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsScalesConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsTitleConfigBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsTooltipConfigBuilder;

public class SimpleChartJsOptionsBuilder
implements SimpleChartJsBuilder<SimpleChartJsOptions> {
    private Boolean responsive;
    private Boolean maintainAspectRatio;
    private Integer cutoutPercentage;
    private Integer rotation;
    private Integer circumference;
    private SimpleChartJsTooltipConfigBuilder tooltipConfigBuilder = new SimpleChartJsTooltipConfigBuilder();
    private SimpleChartJsHoverConfigBuilder hoverConfigBuilder = new SimpleChartJsHoverConfigBuilder();
    private SimpleChartJsScalesConfigBuilder<?, ?> scalesConfigBuilder = new SimpleChartJsScalesConfigBuilder();
    private SimpleChartJsTitleConfigBuilder titleConfigBuilder;
    private SimpleChartJsLegendConfigBuilder legendConfigBuilder;
    private Map<String, Serializable> plugins;

    public SimpleChartJsOptionsBuilder withResponsive(Boolean responsive) {
        this.responsive = responsive;
        return this;
    }

    public SimpleChartJsOptionsBuilder withMaintainAspectRatio(Boolean maintainAspectRatio) {
        this.maintainAspectRatio = maintainAspectRatio;
        return this;
    }

    public SimpleChartJsOptionsBuilder withCutoutPercentage(Integer cutoutPercentage) {
        this.cutoutPercentage = cutoutPercentage;
        return this;
    }

    public SimpleChartJsOptionsBuilder withRotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    public SimpleChartJsOptionsBuilder withCircumference(Integer circumference) {
        this.circumference = circumference;
        return this;
    }

    public SimpleChartJsTooltipConfigBuilder tooltipConfig() {
        return this.tooltipConfigBuilder;
    }

    public SimpleChartJsHoverConfigBuilder hoverConfig() {
        return this.hoverConfigBuilder;
    }

    public SimpleChartJsScalesConfigBuilder<?, ?> scalesConfig() {
        return this.scalesConfigBuilder;
    }

    public SimpleChartJsTitleConfigBuilder titleConfig() {
        if (this.titleConfigBuilder == null) {
            this.titleConfigBuilder = new SimpleChartJsTitleConfigBuilder();
        }
        return this.titleConfigBuilder;
    }

    public SimpleChartJsLegendConfigBuilder legendConfig() {
        if (this.legendConfigBuilder == null) {
            this.legendConfigBuilder = new SimpleChartJsLegendConfigBuilder();
        }
        return this.legendConfigBuilder;
    }

    public SimpleChartJsOptionsBuilder withPlugin(String name, Serializable configuration) {
        if (this.plugins == null) {
            this.plugins = new LinkedHashMap<String, Serializable>();
        }
        this.plugins.put(name, configuration);
        return this;
    }

    @Override
    public boolean isValid() {
        return !(!this.tooltipConfigBuilder.isValid() || !this.hoverConfigBuilder.isValid() || !this.scalesConfigBuilder.isValid() || this.titleConfigBuilder != null && !this.titleConfigBuilder.isValid() || this.legendConfigBuilder != null && !this.legendConfigBuilder.isValid());
    }

    @Override
    public SimpleChartJsOptions build() {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsOptions ret = new SimpleChartJsOptions();
        ret.setResponsive(this.responsive);
        ret.setMaintainAspectRatio(this.maintainAspectRatio);
        ret.setCutoutPercentage(this.cutoutPercentage);
        ret.setRotation(this.rotation);
        ret.setCircumference(this.circumference);
        ret.setHoverConfig(this.hoverConfigBuilder.build());
        ret.setScalesConfig((ChartJsScalesConfig)this.scalesConfigBuilder.build());
        ret.setTooltipConfig(this.tooltipConfigBuilder.build());
        ret.setTitleConfig(this.titleConfigBuilder == null ? null : this.titleConfigBuilder.build());
        ret.setLegendConfig(this.legendConfigBuilder == null ? null : this.legendConfigBuilder.build());
        ret.setPlugins(this.plugins);
        return ret;
    }
}

