/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.function.Supplier;
import nl.crashdata.chartjs.data.ChartJsChartType;
import nl.crashdata.chartjs.data.ChartJsLegendConfig;
import nl.crashdata.chartjs.data.ChartJsPosition;
import nl.crashdata.chartjs.data.simple.SimpleChartJsLegendConfig;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsEventHandlerBuilder;

public class SimpleChartJsLegendConfigBuilder
implements SimpleChartJsBuilder<ChartJsLegendConfig> {
    private Supplier<ChartJsChartType> chartTypeSupplier;
    private boolean display = true;
    private ChartJsPosition position;
    private Boolean fullWidth;
    private Boolean reverse;
    private List<String> labels;
    private SimpleChartJsEventHandlerBuilder onClickBuilder;

    public SimpleChartJsLegendConfigBuilder(Supplier<ChartJsChartType> chartTypeSupplier) {
        this.chartTypeSupplier = chartTypeSupplier;
    }

    public SimpleChartJsLegendConfigBuilder withDisplay(boolean display) {
        this.display = display;
        return this;
    }

    public SimpleChartJsLegendConfigBuilder withFullWidth(boolean fullWidth) {
        this.fullWidth = fullWidth;
        return this;
    }

    public SimpleChartJsLegendConfigBuilder withFontSize(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    public SimpleChartJsLegendConfigBuilder withText(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public SimpleChartJsLegendConfigBuilder withPosition(ChartJsPosition position) {
        this.position = position;
        return this;
    }

    public SimpleChartJsEventHandlerBuilder onClick() {
        if (this.onClickBuilder == null) {
            this.onClickBuilder = new SimpleChartJsEventHandlerBuilder();
            this.onClickBuilder.withParameters("event", "item");
            this.onClickBuilder.withDefaultHandlerBodySupplier(() -> this.createDefaultLegendHandlerBody(this.chartTypeSupplier.get(), "onClick"));
        }
        return this.onClickBuilder;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ChartJsLegendConfig build() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsLegendConfig ret = new SimpleChartJsLegendConfig();
        ret.setDisplay(this.display);
        ret.setPosition(this.position);
        ret.setFullWidth(this.fullWidth);
        ret.setReverse(this.reverse);
        ret.setLabels(this.labels);
        ret.setOnClick(this.onClickBuilder == null ? null : this.onClickBuilder.build());
        return ret;
    }

    private String createDefaultLegendHandlerBody(ChartJsChartType type, String eventType) {
        try {
            JsonProperty jsonProperty = ((Object)((Object)type)).getClass().getField(type.name()).getAnnotation(JsonProperty.class);
            return "Chart.defaults." + jsonProperty.value() + ".legend." + eventType + ".call(this, event, item);";
        }
        catch (Exception e) {
            return null;
        }
    }
}

