/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.api.sharedpreferences;

import android.content.SharedPreferences;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.androidannotations.api.sharedpreferences.SetXmlSerializer;

public abstract class SharedPreferencesCompat {
    private static final Method sApplyMethod = SharedPreferencesCompat.findMethod(SharedPreferences.Editor.class, "apply", new Class[0]);
    private static final Method sGetStringSetMethod = SharedPreferencesCompat.findMethod(SharedPreferences.class, "getStringSet", String.class, Set.class);
    private static final Method sPutStringSetMethod = SharedPreferencesCompat.findMethod(SharedPreferences.Editor.class, "putStringSet", String.class, Set.class);

    private SharedPreferencesCompat() {
    }

    public static void apply(SharedPreferences.Editor editor) {
        try {
            SharedPreferencesCompat.invoke(sApplyMethod, editor, new Object[0]);
            return;
        }
        catch (NoSuchMethodException e) {
            editor.commit();
            return;
        }
    }

    public static Set<String> getStringSet(SharedPreferences preferences, String key, Set<String> defValues) {
        try {
            return (Set)SharedPreferencesCompat.invoke(sGetStringSetMethod, preferences, key, defValues);
        }
        catch (NoSuchMethodException e) {
            String serializedSet = preferences.getString(key, null);
            return SetXmlSerializer.deserialize(serializedSet);
        }
    }

    public static void putStringSet(SharedPreferences.Editor editor, String key, Set<String> values) {
        try {
            SharedPreferencesCompat.invoke(sPutStringSetMethod, editor, key, values);
        }
        catch (NoSuchMethodException e1) {
            editor.putString(key, SetXmlSerializer.serialize(values));
        }
    }

    private static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> T invoke(Method method, Object obj, Object ... args) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException();
        }
        try {
            return (T)method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new NoSuchMethodException(method.getName());
    }
}

