/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.generation;

import com.sun.codemodel.writer.PrologCodeWriter;
import java.io.IOException;
import javax.annotation.processing.Filer;
import org.androidannotations.generation.ApiCodeGenerator;
import org.androidannotations.generation.ResourceCodeWriter;
import org.androidannotations.generation.SourceCodewriter;
import org.androidannotations.process.ModelProcessor;

public class CodeModelGenerator {
    private final Filer filer;
    private final String aaVersion;

    public CodeModelGenerator(Filer filer, String aaVersion) {
        this.filer = filer;
        this.aaVersion = aaVersion;
    }

    public void generate(ModelProcessor.ProcessResult processResult) throws IOException {
        ApiCodeGenerator apiCodeGenerator = new ApiCodeGenerator(this.filer);
        apiCodeGenerator.writeApiClasses(processResult.apiClassesToGenerate, processResult.originatingElements);
        SourceCodewriter sourceCodeWriter = new SourceCodewriter(this.filer, processResult.originatingElements);
        PrologCodeWriter prologCodeWriter = new PrologCodeWriter(sourceCodeWriter, "DO NOT EDIT THIS FILE, IT HAS BEEN GENERATED USING AndroidAnnotations " + this.aaVersion + ".\n");
        processResult.codeModel.build(prologCodeWriter, new ResourceCodeWriter(this.filer));
    }
}

