/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.Trace;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class TraceHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public TraceHandler(ProcessingEnvironment processingEnvironment) {
        super(Trace.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.hasValidLogLevel(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) throws Exception {
        JTryBlock tryBlock;
        ExecutableElement executableElement = (ExecutableElement)element;
        String tag = this.extractTag(executableElement);
        int level = executableElement.getAnnotation(Trace.class).level();
        JMethod method = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(method);
        JBlock methodBody = method.body();
        JInvocation isLoggableInvocation = this.classes().LOG.staticInvoke("isLoggable");
        isLoggableInvocation.arg(JExpr.lit(tag)).arg(this.logLevelFromInt(level, this.classes().LOG));
        JConditional ifStatement = methodBody._if(isLoggableInvocation);
        JInvocation currentTimeInvoke = this.classes().SYSTEM.staticInvoke("currentTimeMillis");
        JBlock _thenBody = ifStatement._then();
        String logMethodName = this.logMethodNameFromLevel(level);
        JInvocation logEnterInvoke = this.classes().LOG.staticInvoke(logMethodName);
        logEnterInvoke.arg(tag);
        logEnterInvoke.arg(this.getEnterMessage(method, executableElement));
        _thenBody.add(logEnterInvoke);
        JVar startDeclaration = _thenBody.decl(this.codeModel().LONG, "start", currentTimeInvoke);
        JVar result = null;
        if (method.type().fullName().equals("void")) {
            tryBlock = _thenBody._try();
            tryBlock.body().add(previousMethodBody);
        } else {
            JInvocation superCall = this.codeModelHelper.getSuperCall(holder, method);
            result = _thenBody.decl(this.refClass(Object.class), "result", JExpr._null());
            tryBlock = _thenBody._try();
            tryBlock.body().assign(result, superCall);
            tryBlock.body()._return(JExpr.cast(this.boxify(method.type()), result));
        }
        JBlock finallyBlock = tryBlock._finally();
        JVar durationDeclaration = finallyBlock.decl(this.codeModel().LONG, "duration", currentTimeInvoke.minus(startDeclaration));
        JInvocation logExitInvoke = this.classes().LOG.staticInvoke(logMethodName);
        logExitInvoke.arg(tag);
        logExitInvoke.arg(this.getExitMessage(executableElement, method, result, durationDeclaration));
        finallyBlock.add(logExitInvoke);
        JBlock elseBlock = ifStatement._else();
        elseBlock.add(previousMethodBody);
    }

    private JClass boxify(JType type) throws ClassNotFoundException {
        return this.codeModel().parseType(type.fullName()).boxify();
    }

    private JExpression getExitMessage(ExecutableElement element, JMethod method, JVar result, JVar duration) throws ClassNotFoundException {
        String methodName = this.getMethodName(element);
        List<JVar> params = method.params();
        StringBuilder paramStr = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                paramStr.append(", ");
            }
            JVar var = params.get(i);
            paramStr.append(var.type().name());
        }
        methodName = methodName + "(" + paramStr.toString() + ")";
        JInvocation format = this.refClass(String.class).staticInvoke("format");
        if (result == null) {
            format.arg("Exiting [" + methodName + "], duration in ms: %d");
        } else {
            format.arg("Exiting [" + methodName + " returning: %s], duration in ms: %d");
            if (method.type().isArray()) {
                JClass arraysClass = this.refClass(Arrays.class);
                format.arg(arraysClass.staticInvoke("toString").arg(JExpr.cast(this.boxify(method.type()), result)));
            } else {
                format.arg(result);
            }
        }
        return format.arg(duration);
    }

    private JExpression getEnterMessage(JMethod method, ExecutableElement element) {
        String methodName = this.getMethodName(element);
        List<JVar> params = method.params();
        if (params.isEmpty()) {
            return JExpr.lit("Entering [" + methodName + "()]");
        }
        JClass arraysClass = this.refClass(Arrays.class);
        StringBuilder paramStr = new StringBuilder();
        ArrayList<JExpressionImpl> paramExpressions = new ArrayList<JExpressionImpl>();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                paramStr.append(", ");
            }
            JVar var = params.get(i);
            paramStr.append(var.name()).append(" = %s");
            if (var.type().isArray()) {
                paramExpressions.add(arraysClass.staticInvoke("toString").arg(var));
                continue;
            }
            paramExpressions.add(var);
        }
        JInvocation format = this.refClass(String.class).staticInvoke("format");
        format.arg(JExpr.lit("Entering [" + methodName + "(" + paramStr + ")]"));
        for (JExpression jExpression : paramExpressions) {
            format.arg(jExpression);
        }
        return format;
    }

    private String getMethodName(ExecutableElement element) {
        String returnType = element.getReturnType().toString();
        String simpleName = element.getSimpleName().toString();
        return returnType + " " + simpleName;
    }

    private String logMethodNameFromLevel(int level) {
        switch (level) {
            case 3: {
                return "d";
            }
            case 2: {
                return "v";
            }
            case 4: {
                return "i";
            }
            case 5: {
                return "w";
            }
            case 6: {
                return "e";
            }
        }
        throw new IllegalArgumentException("Unrecognized Log level : " + level);
    }

    private JFieldRef logLevelFromInt(int level, JClass logClass) {
        switch (level) {
            case 3: {
                return logClass.staticRef("DEBUG");
            }
            case 2: {
                return logClass.staticRef("VERBOSE");
            }
            case 4: {
                return logClass.staticRef("INFO");
            }
            case 5: {
                return logClass.staticRef("WARN");
            }
            case 6: {
                return logClass.staticRef("ERROR");
            }
        }
        throw new IllegalArgumentException("Unrecognized log level. Given value:" + level);
    }

    private String extractTag(Element element) {
        Trace annotation = element.getAnnotation(Trace.class);
        String tag = annotation.tag();
        if ("NO_TAG".equals(tag)) {
            tag = element.getEnclosingElement().getSimpleName().toString();
        }
        if (tag.length() > 23) {
            tag = tag.substring(0, 23);
        }
        return tag;
    }
}

