/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.process.ProcessHolder;

public class ReceiverRegistrationHolder {
    private EComponentHolder holder;
    private Map<Set<String>, JFieldVar> intentFilterFields = new HashMap<Set<String>, JFieldVar>();
    private IllegalStateException illegalStateException = new IllegalStateException("This shouldn't happen unless the validation is bad");

    public ReceiverRegistrationHolder(EComponentHolder holder) {
        this.holder = holder;
    }

    public JFieldVar getIntentFilterField(String[] actions) {
        Arrays.sort(actions);
        HashSet<String> actionSet = new HashSet<String>(Arrays.asList(actions));
        JFieldVar intentFilterField = this.intentFilterFields.get(actionSet);
        if (intentFilterField == null) {
            intentFilterField = this.createIntentFilterField(actionSet);
            this.intentFilterFields.put(actionSet, intentFilterField);
        }
        return intentFilterField;
    }

    private JFieldVar createIntentFilterField(Set<String> actionSet) {
        String intentFilterName = "intentFilter" + (this.intentFilterFields.size() + 1) + "_";
        JInvocation newIntentFilterExpr = JExpr._new(this.classes().INTENT_FILTER);
        JFieldVar intentFilterField = this.getGeneratedClass().field(12, this.classes().INTENT_FILTER, intentFilterName, (JExpression)newIntentFilterExpr);
        JBlock initBody = this.holder.getInitBody();
        for (String action : actionSet) {
            initBody.invoke((JExpression)intentFilterField, "addAction").arg(action);
        }
        return intentFilterField;
    }

    public JBlock getOnStartAfterSuperBlock() {
        throw this.illegalStateException;
    }

    public JBlock getOnStopBeforeSuperBlock() {
        throw this.illegalStateException;
    }

    public JBlock getOnPauseBeforeSuperBlock() {
        throw this.illegalStateException;
    }

    public JBlock getOnAttachAfterSuperBlock() {
        throw this.illegalStateException;
    }

    public JBlock getOnDetachBeforeSuperBlock() {
        throw this.illegalStateException;
    }

    public JDefinedClass getGeneratedClass() {
        return this.holder.getGeneratedClass();
    }

    public ProcessHolder.Classes classes() {
        return this.holder.classes();
    }
}

